/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Date;
import org.drools.base.time.Trigger;
import org.kie.api.runtime.Calendars;
import org.kie.api.time.Calendar;

public class IntervalTrigger
implements Trigger {
    private Date startTime;
    private Date endTime;
    private int repeatLimit;
    private int repeatCount;
    private Date nextFireTime;
    private Date lastFireTime;
    private Date createdTime;
    private long delay;
    private long period;
    private String[] calendarNames;
    private Calendars calendars;

    public IntervalTrigger() {
    }

    public IntervalTrigger(long timestamp, Date startTime, Date endTime, int repeatLimit, long delay, long period, String[] calendarNames, Calendars calendars) {
        this(timestamp, startTime, endTime, repeatLimit, delay, period, calendarNames, calendars, null, null);
    }

    public IntervalTrigger(long timestamp, Date startTime, Date endTime, int repeatLimit, long delay, long period, String[] calendarNames, Calendars calendars, Date createdTime, Date lastFireTime) {
        this.delay = delay;
        this.period = period;
        this.createdTime = createdTime == null ? new Date(timestamp) : createdTime;
        this.lastFireTime = lastFireTime;
        if (startTime == null) {
            this.nextFireTime = new Date(timestamp + delay);
            startTime = new Date(timestamp);
        }
        this.setStartTime(startTime);
        if (endTime != null) {
            this.setEndTime(endTime);
        }
        this.repeatLimit = repeatLimit;
        this.calendarNames = calendarNames;
        this.calendars = calendars;
        this.setFirstFireTime(timestamp);
        this.updateToNextIncludeDate();
    }

    public int getRepeatLimit() {
        return this.repeatLimit;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public long getPeriod() {
        return this.period;
    }

    public String[] getCalendarNames() {
        return this.calendarNames;
    }

    public Calendars getCalendars() {
        return this.calendars;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        java.util.Calendar cl = java.util.Calendar.getInstance();
        cl.setTime(startTime);
        this.startTime = cl.getTime();
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = endTime;
    }

    public Date getLastFireTime() {
        return this.lastFireTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    private void setFirstFireTime(long timestamp) {
        if (this.nextFireTime == null) {
            long start = this.startTime.getTime() + this.delay;
            if (timestamp > start) {
                long distanceFromLastPhase = (timestamp - start) % this.period;
                if (distanceFromLastPhase == 0L) {
                    this.nextFireTime = new Date(timestamp);
                } else {
                    long phase = this.period - distanceFromLastPhase;
                    this.nextFireTime = new Date(timestamp + phase);
                }
            } else {
                this.nextFireTime = new Date(start);
            }
        }
        if (this.getEndTime() != null && this.nextFireTime.after(this.getEndTime())) {
            this.nextFireTime = null;
        }
        Date pot = this.getTimeAfter();
        if (this.getEndTime() != null && pot != null && pot.after(this.getEndTime())) {
            this.nextFireTime = null;
        }
    }

    public Date hasNextFireTime() {
        return this.nextFireTime;
    }

    public synchronized Date nextFireTime() {
        if (this.nextFireTime == null) {
            return null;
        }
        Date date = this.nextFireTime;
        this.nextFireTime = this.getTimeAfter();
        this.updateToNextIncludeDate();
        if (this.endTime != null && this.nextFireTime.after(this.endTime)) {
            this.nextFireTime = null;
        } else if (this.repeatLimit != -1 && this.repeatCount >= this.repeatLimit) {
            this.nextFireTime = null;
        }
        this.lastFireTime = date;
        return date;
    }

    private Date getTimeAfter() {
        ++this.repeatCount;
        return this.period != 0L && this.nextFireTime != null ? new Date(this.nextFireTime.getTime() + this.period) : null;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nextFireTime = (Date)in.readObject();
        this.period = in.readLong();
        this.delay = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.nextFireTime);
        out.writeLong(this.period);
        out.writeLong(this.delay);
    }

    public void updateToNextIncludeDate() {
        if (this.calendars == null || this.calendarNames == null || this.calendarNames.length == 0) {
            return;
        }
        while (this.nextFireTime != null && (this.endTime == null || this.nextFireTime.before(this.endTime))) {
            boolean included = true;
            for (String calName : this.calendarNames) {
                Calendar cal = this.calendars.get(calName);
                if (cal == null || cal.isTimeIncluded(this.nextFireTime.getTime())) continue;
                included = false;
                break;
            }
            if (included) break;
            this.nextFireTime = this.getTimeAfter();
        }
    }

    public void setRepeatLimit(int repeatLimit) {
        this.repeatLimit = repeatLimit;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public void setCalendarNames(String[] calendarNames) {
        this.calendarNames = calendarNames;
    }

    public void setCalendars(Calendars calendars) {
        this.calendars = calendars;
    }

    public String toString() {
        return "IntervalTrigger [startTime=" + this.startTime + ", endTime=" + this.endTime + ", repeatLimit=" + this.repeatLimit + ", repeatCount=" + this.repeatCount + ", nextFireTime=" + this.nextFireTime + ", delay=" + this.delay + ", period=" + this.period + ", calendarNames=" + Arrays.toString(this.calendarNames) + ", calendars=" + this.calendars + "]";
    }
}

