/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import org.drools.base.base.AcceptsClassObjectType;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.DroolsQuery;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ValueResolver;
import org.drools.base.definitions.rule.impl.QueryImpl;
import org.drools.base.rule.Declaration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.tms.TruthMaintenanceSystemEqualityKey;
import org.drools.tms.beliefsystem.BeliefSet;
import org.drools.tms.beliefsystem.abductive.Abductive;
import org.kie.api.runtime.rule.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbductiveQuery
extends QueryImpl
implements Externalizable,
AcceptsClassObjectType {
    private static final Logger LOG = LoggerFactory.getLogger(AbductiveQuery.class);
    private ObjectType returnType;
    private transient Constructor cachedConstructor;
    private String[] params;
    private String[] abducibleArgs;
    private int[] arg2param;
    private Object value;
    private boolean returnBound;

    public AbductiveQuery() {
    }

    public AbductiveQuery(String name) {
        super(name);
    }

    public boolean isAbductive() {
        return true;
    }

    public void setReturnType(ObjectType objectType, String[] params, String[] args, Declaration[] declarations) throws NoSuchMethodException {
        this.returnType = objectType;
        this.params = params;
        if (args != null) {
            this.abducibleArgs = Arrays.copyOf(args, args.length);
            this.arg2param = new int[this.abducibleArgs.length];
            for (int j = 0; j < this.abducibleArgs.length; ++j) {
                boolean matched = false;
                for (int k = 0; k < params.length; ++k) {
                    if (!this.abducibleArgs[j].equals(params[k])) continue;
                    this.arg2param[j] = k;
                    matched = true;
                    break;
                }
                if (matched) continue;
                throw new IllegalArgumentException("Constructor argument " + this.abducibleArgs[j] + " cannot be resolved ");
            }
        } else {
            this.abducibleArgs = Arrays.copyOf(params, params.length - 1);
            this.arg2param = new int[this.abducibleArgs.length];
            for (int j = 0; j < this.abducibleArgs.length; ++j) {
                this.arg2param[j] = j;
            }
        }
        this.findConstructor(declarations);
    }

    private void findConstructor(Declaration[] declarations) throws NoSuchMethodException {
        int argsLength = this.abducibleArgs.length;
        this.cachedConstructor = null;
        ArrayList<Class> availableArgs = argsLength > 0 ? new ArrayList<Class>(argsLength) : Collections.emptyList();
        for (int j = 0; j < argsLength; ++j) {
            Declaration decl;
            Declaration declaration = decl = declarations != null ? declarations[this.arg2param[j]] : this.getDeclaration(this.abducibleArgs[j]);
            if (decl == null) continue;
            availableArgs.add(decl.getDeclarationClass());
        }
        Class klass = ((ClassObjectType)this.returnType).getClassType();
        while (this.cachedConstructor == null) {
            try {
                this.cachedConstructor = klass.getConstructor(availableArgs.toArray(new Class[availableArgs.size()]));
            }
            catch (NoSuchMethodException nsme) {
                if (klass == Object.class) {
                    throw nsme;
                }
                klass = klass.getSuperclass();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.returnType);
        out.writeObject(this.params);
        out.writeObject(this.value);
        out.writeBoolean(this.returnBound);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.returnType = (ClassObjectType)in.readObject();
        this.params = (String[])in.readObject();
        this.value = in.readObject();
        this.returnBound = in.readBoolean();
    }

    public void setClassObjectType(ClassObjectType classObjectType) {
        this.returnType = classObjectType;
        if (this.params != null) {
            this.getConstructor();
        }
    }

    private Constructor getConstructor() {
        if (this.cachedConstructor == null || this.cachedConstructor.getDeclaringClass() != ((ClassObjectType)this.returnType).getClassType()) {
            try {
                this.findConstructor(null);
            }
            catch (NoSuchMethodException e) {
                LOG.error("Exception", (Throwable)e);
                this.cachedConstructor = null;
                this.returnType = null;
            }
        }
        return this.cachedConstructor;
    }

    public boolean isReturnBound() {
        return this.returnBound;
    }

    public boolean processAbduction(Match resultLeftTuple, DroolsQuery dquery, Object[] objects, ValueResolver valueResolver) {
        boolean pass = true;
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)valueResolver;
        int numArgs = this.abducibleArgs.length;
        Object[] constructorArgs = new Object[this.abducibleArgs.length];
        for (int j = 0; j < numArgs; ++j) {
            int k = this.arg2param[j];
            if (objects[k] != null) {
                constructorArgs[j] = objects[k];
                continue;
            }
            if (dquery.getElements()[k] == null) continue;
            constructorArgs[j] = dquery.getElements()[k];
        }
        Object abduced = this.abduce(constructorArgs);
        if (abduced != null) {
            BeliefSet bs;
            boolean firstAssertion = true;
            ObjectStore store = workingMemory.getObjectStore();
            InternalFactHandle handle = store.getHandleForObject(abduced);
            if (handle != null) {
                abduced = handle.getObject();
                firstAssertion = false;
            } else {
                handle = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)workingMemory).insertPositive(abduced, (InternalMatch)resultLeftTuple);
            }
            BeliefSet beliefSet = bs = handle.getEqualityKey() != null ? ((TruthMaintenanceSystemEqualityKey)handle.getEqualityKey()).getBeliefSet() : null;
            if (bs == null) {
                abduced = handle.getObject();
            } else if (!bs.isPositive()) {
                pass = false;
            } else if (!firstAssertion) {
                TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)workingMemory).insertPositive(abduced, (InternalMatch)resultLeftTuple);
            }
        }
        objects[objects.length - 1] = abduced;
        return pass;
    }

    private Object abduce(Object ... args) {
        Constructor constructor = this.getConstructor();
        if (constructor == null) {
            return null;
        }
        try {
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null || !constructor.getParameterTypes()[j].isPrimitive()) continue;
                args[j] = Boolean.TYPE == constructor.getParameterTypes()[j] ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
            }
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            LOG.error("Exception", (Throwable)e);
            return null;
        }
    }

    public Class<? extends Annotation> getAbductiveAnnotationClass() {
        return Abductive.class;
    }

    public <T extends Annotation> Class<?> getAbductionClass(Function<Class<T>, T> annotationReader) {
        return ((Abductive)annotationReader.apply(Abductive.class)).target();
    }
}

