/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor.gizmo;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberHandler;

final class GizmoFieldHandler
implements GizmoMemberHandler {
    private final Class<?> declaringClass;
    private final FieldDescriptor fieldDescriptor;
    private final boolean canBeWritten;

    GizmoFieldHandler(Class<?> declaringClass, FieldDescriptor fieldDescriptor, boolean canBeWritten) {
        this.declaringClass = declaringClass;
        this.fieldDescriptor = fieldDescriptor;
        this.canBeWritten = canBeWritten;
    }

    @Override
    public void whenIsField(Consumer<FieldDescriptor> fieldDescriptorConsumer) {
        fieldDescriptorConsumer.accept(this.fieldDescriptor);
    }

    @Override
    public void whenIsMethod(Consumer<MethodDescriptor> methodDescriptorConsumer) {
    }

    @Override
    public ResultHandle readMemberValue(BytecodeCreator bytecodeCreator, ResultHandle thisObj) {
        return bytecodeCreator.readInstanceField(this.fieldDescriptor, thisObj);
    }

    @Override
    public boolean writeMemberValue(MethodDescriptor setter, BytecodeCreator bytecodeCreator, ResultHandle thisObj, ResultHandle newValue) {
        if (this.canBeWritten) {
            bytecodeCreator.writeInstanceField(this.fieldDescriptor, thisObj, newValue);
            return true;
        }
        return false;
    }

    @Override
    public String getDeclaringClassName() {
        return this.fieldDescriptor.getDeclaringClass();
    }

    @Override
    public String getTypeName() {
        return this.fieldDescriptor.getType();
    }

    @Override
    public Type getType() {
        try {
            return this.declaringClass.getDeclaredField(this.fieldDescriptor.getName()).getGenericType();
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Cannot find field (" + this.fieldDescriptor.getName() + ") on class (" + this.declaringClass + ").", e);
        }
    }

    public String toString() {
        return this.fieldDescriptor.toString();
    }
}

