/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor.gizmo;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.function.Consumer;
import org.objectweb.asm.Type;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberHandler;

public final class GizmoMemberDescriptor {
    private final String name;
    private final GizmoMemberHandler memberHandler;
    private final GizmoMemberHandler metadataHandler;
    private final MethodDescriptor setter;

    public GizmoMemberDescriptor(Member member) {
        Class<?> declaringClass = member.getDeclaringClass();
        if (!Modifier.isPublic(member.getModifiers())) {
            throw new IllegalStateException("Member (" + member.getName() + ") of class (" + member.getDeclaringClass().getName() + ") is not public and domainAccessType is GIZMO.\n" + (member instanceof Field ? "Maybe put the annotations onto the public getter of the field.\n" : "") + "Maybe use domainAccessType REFLECTION instead of GIZMO.");
        }
        if (member instanceof Field) {
            FieldDescriptor fieldDescriptor = FieldDescriptor.of((Field)((Field)member));
            this.name = member.getName();
            this.memberHandler = GizmoMemberHandler.of(declaringClass, this.name, fieldDescriptor, false);
            this.setter = null;
        } else if (member instanceof Method) {
            MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod((Method)((Method)member));
            this.name = ReflectionHelper.isGetterMethod((Method)member) ? ReflectionHelper.getGetterPropertyName(member) : member.getName();
            this.memberHandler = GizmoMemberHandler.of(declaringClass, methodDescriptor);
            this.setter = GizmoMemberDescriptor.lookupSetter(methodDescriptor, declaringClass, this.name).orElse(null);
        } else {
            throw new IllegalArgumentException(member + " is not a Method or a Field.");
        }
        this.metadataHandler = this.memberHandler;
    }

    public GizmoMemberDescriptor(String name, FieldDescriptor fieldDescriptor, Class<?> declaringClass) {
        this.name = name;
        this.metadataHandler = this.memberHandler = GizmoMemberHandler.of(declaringClass, name, fieldDescriptor, true);
        this.setter = null;
    }

    public GizmoMemberDescriptor(String name, MethodDescriptor memberDescriptor, MethodDescriptor metadataDescriptor, Class<?> declaringClass, MethodDescriptor setterDescriptor) {
        this.name = name;
        this.memberHandler = GizmoMemberHandler.of(declaringClass, memberDescriptor);
        this.metadataHandler = memberDescriptor == metadataDescriptor ? this.memberHandler : GizmoMemberHandler.of(declaringClass, metadataDescriptor);
        this.setter = setterDescriptor;
    }

    public GizmoMemberDescriptor(String name, MethodDescriptor memberDescriptor, Class<?> declaringClass, MethodDescriptor setterDescriptor) {
        this.name = name;
        this.metadataHandler = this.memberHandler = GizmoMemberHandler.of(declaringClass, memberDescriptor);
        this.setter = setterDescriptor;
    }

    public GizmoMemberDescriptor(String name, MethodDescriptor memberDescriptor, FieldDescriptor metadataDescriptor, Class<?> declaringClass, MethodDescriptor setterDescriptor) {
        this.name = name;
        this.memberHandler = GizmoMemberHandler.of(declaringClass, memberDescriptor);
        this.metadataHandler = GizmoMemberHandler.of(declaringClass, name, metadataDescriptor, true);
        this.setter = setterDescriptor;
    }

    public GizmoMemberDescriptor whenIsField(Consumer<FieldDescriptor> fieldDescriptorConsumer) {
        this.memberHandler.whenIsField(fieldDescriptorConsumer);
        return this;
    }

    public GizmoMemberDescriptor whenIsMethod(Consumer<MethodDescriptor> methodDescriptorConsumer) {
        this.memberHandler.whenIsMethod(methodDescriptorConsumer);
        return this;
    }

    public ResultHandle readMemberValue(BytecodeCreator bytecodeCreator, ResultHandle thisObj) {
        return this.memberHandler.readMemberValue(bytecodeCreator, thisObj);
    }

    public boolean writeMemberValue(BytecodeCreator bytecodeCreator, ResultHandle thisObj, ResultHandle newValue) {
        return this.memberHandler.writeMemberValue(this.setter, bytecodeCreator, thisObj, newValue);
    }

    public GizmoMemberDescriptor whenMetadataIsOnField(Consumer<FieldDescriptor> fieldDescriptorConsumer) {
        this.metadataHandler.whenIsField(fieldDescriptorConsumer);
        return this;
    }

    public GizmoMemberDescriptor whenMetadataIsOnMethod(Consumer<MethodDescriptor> methodDescriptorConsumer) {
        this.metadataHandler.whenIsMethod(methodDescriptorConsumer);
        return this;
    }

    public String getDeclaringClassName() {
        return this.memberHandler.getDeclaringClassName();
    }

    public Optional<MethodDescriptor> getSetter() {
        return Optional.ofNullable(this.setter);
    }

    private static Optional<MethodDescriptor> lookupSetter(Object memberDescriptor, Class<?> declaringClass, String name) {
        if (memberDescriptor instanceof MethodDescriptor) {
            return Optional.ofNullable(ReflectionHelper.getSetterMethod(declaringClass, name)).map(MethodDescriptor::ofMethod);
        }
        return Optional.empty();
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        String typeName = this.metadataHandler.getTypeName();
        return Type.getType((String)typeName).getClassName();
    }

    public java.lang.reflect.Type getType() {
        return this.metadataHandler.getType();
    }

    public String toString() {
        return this.memberHandler.toString();
    }
}

