/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.list;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import org.optaplanner.core.impl.heuristic.selector.AbstractSelector;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.list.SubList;
import org.optaplanner.core.impl.heuristic.selector.list.SubListSelector;
import org.optaplanner.core.impl.heuristic.selector.list.TriangleElementFactory;
import org.optaplanner.core.impl.heuristic.selector.list.TriangularNumbers;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class RandomSubListSelector<Solution_>
extends AbstractSelector<Solution_>
implements SubListSelector<Solution_> {
    private final EntitySelector<Solution_> entitySelector;
    private final EntityIndependentValueSelector<Solution_> valueSelector;
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final int minimumSubListSize;
    private final int maximumSubListSize;
    private TriangleElementFactory triangleElementFactory;
    private SingletonInverseVariableSupply inverseVariableSupply;

    public RandomSubListSelector(EntitySelector<Solution_> entitySelector, EntityIndependentValueSelector<Solution_> valueSelector, int minimumSubListSize, int maximumSubListSize) {
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.listVariableDescriptor = (ListVariableDescriptor)valueSelector.getVariableDescriptor();
        if (minimumSubListSize < 1) {
            throw new IllegalArgumentException("The minimumSubListSize (" + minimumSubListSize + ") must be greater than 0.");
        }
        if (minimumSubListSize > maximumSubListSize) {
            throw new IllegalArgumentException("The minimumSubListSize (" + minimumSubListSize + ") must be less than or equal to the maximumSubListSize (" + maximumSubListSize + ").");
        }
        this.minimumSubListSize = minimumSubListSize;
        this.maximumSubListSize = maximumSubListSize;
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.triangleElementFactory = new TriangleElementFactory(this.minimumSubListSize, this.maximumSubListSize, this.workingRandom);
        this.inverseVariableSupply = solverScope.getScoreDirector().getSupplyManager().demand(new SingletonListInverseVariableDemand<Solution_>(this.listVariableDescriptor));
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
    }

    @Override
    public ListVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.listVariableDescriptor;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return true;
    }

    @Override
    public long getSize() {
        long subListCount = 0L;
        for (Object entity : this.entitySelector::endingIterator) {
            int listSize = this.listVariableDescriptor.getListSize(entity);
            if (listSize < this.minimumSubListSize) continue;
            subListCount += (long)TriangularNumbers.nthTriangle(listSize - this.minimumSubListSize + 1);
            if (listSize <= this.maximumSubListSize) continue;
            subListCount -= (long)TriangularNumbers.nthTriangle(listSize - this.maximumSubListSize);
        }
        return subListCount;
    }

    @Override
    public Iterator<Object> endingValueIterator() {
        return this.valueSelector.endingIterator(null);
    }

    @Override
    public long getValueCount() {
        return this.valueSelector.getSize();
    }

    @Override
    public Iterator<SubList> iterator() {
        int biggestListSize = 0;
        for (Object entity : this.entitySelector::endingIterator) {
            biggestListSize = Math.max(biggestListSize, this.listVariableDescriptor.getListSize(entity));
        }
        if (biggestListSize < this.minimumSubListSize) {
            return new UpcomingSelectionIterator<SubList>(){

                @Override
                protected SubList createUpcomingSelection() {
                    return (SubList)this.noUpcomingSelection();
                }
            };
        }
        return new RandomSubListIterator(this.valueSelector.iterator());
    }

    public int getMinimumSubListSize() {
        return this.minimumSubListSize;
    }

    public int getMaximumSubListSize() {
        return this.maximumSubListSize;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.valueSelector + ")";
    }

    private final class RandomSubListIterator
    extends UpcomingSelectionIterator<SubList> {
        private final Iterator<Object> valueIterator;

        private RandomSubListIterator(Iterator<Object> valueIterator) {
            this.valueIterator = valueIterator;
        }

        @Override
        protected SubList createUpcomingSelection() {
            Object sourceEntity = null;
            int listSize = 0;
            while (listSize < RandomSubListSelector.this.minimumSubListSize) {
                if (!this.valueIterator.hasNext()) {
                    throw new IllegalStateException("The valueIterator (" + this.valueIterator + ") should never end.");
                }
                sourceEntity = RandomSubListSelector.this.inverseVariableSupply.getInverseSingleton(this.valueIterator.next());
                listSize = RandomSubListSelector.this.listVariableDescriptor.getListSize(sourceEntity);
            }
            TriangleElementFactory.TriangleElement triangleElement = RandomSubListSelector.this.triangleElementFactory.nextElement(listSize);
            int subListLength = listSize - triangleElement.getLevel() + 1;
            int sourceIndex = triangleElement.getIndexOnLevel() - 1;
            return new SubList(sourceEntity, sourceIndex, subListLength);
        }
    }
}

