/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface ObjectPool<T>
extends AutoCloseable {
    public T borrow();

    public void offer(T var1);

    public static <T> ObjectPool<T> newLockFreePool(Supplier<T> factory) {
        return new LockFreeObjectPool<T>(factory);
    }

    public static <T> ObjectPool<T> newLockFreePool(Supplier<T> factory, Consumer<T> destroyer) {
        return new LockFreeObjectPool<T>(factory, destroyer);
    }

    public static class LockFreeObjectPool<T>
    implements ObjectPool<T> {
        private final Supplier<T> factory;
        private final Consumer<T> destroyer;
        private final Queue<T> pool = new LinkedTransferQueue<T>();

        public LockFreeObjectPool(Supplier<T> factory) {
            this(factory, null);
        }

        public LockFreeObjectPool(Supplier<T> factory, Consumer<T> destroyer) {
            this.factory = factory;
            this.destroyer = destroyer;
        }

        @Override
        public T borrow() {
            T t = this.pool.poll();
            return t != null ? t : this.factory.get();
        }

        @Override
        public void offer(T t) {
            this.pool.offer(t);
        }

        @Override
        public void close() throws Exception {
            if (this.destroyer != null) {
                this.pool.forEach(this.destroyer);
            }
        }
    }
}

