/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.ScoreContext;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.stream.Constraint;

final class BendableLongScoreContext
extends ScoreContext<BendableLongScore> {
    private final int hardScoreLevelCount;
    private final int softScoreLevelCount;
    private final int scoreLevel;
    private final long scoreLevelWeight;
    private final IntLongConsumer softScoreLevelUpdater;
    private final IntLongConsumer hardScoreLevelUpdater;

    public BendableLongScoreContext(AbstractScoreInliner<BendableLongScore> parent, Constraint constraint, BendableLongScore constraintWeight, int hardScoreLevelCount, int softScoreLevelCount, int scoreLevel, long scoreLevelWeight, IntLongConsumer hardScoreLevelUpdater, IntLongConsumer softScoreLevelUpdater) {
        super(parent, constraint, constraintWeight);
        this.hardScoreLevelCount = hardScoreLevelCount;
        this.softScoreLevelCount = softScoreLevelCount;
        this.scoreLevel = scoreLevel;
        this.scoreLevelWeight = scoreLevelWeight;
        this.softScoreLevelUpdater = softScoreLevelUpdater;
        this.hardScoreLevelUpdater = hardScoreLevelUpdater;
    }

    public BendableLongScoreContext(AbstractScoreInliner<BendableLongScore> parent, Constraint constraint, BendableLongScore constraintWeight, int hardScoreLevelCount, int softScoreLevelCount, IntLongConsumer hardScoreLevelUpdater, IntLongConsumer softScoreLevelUpdater) {
        this(parent, constraint, constraintWeight, hardScoreLevelCount, softScoreLevelCount, -1, -1L, hardScoreLevelUpdater, softScoreLevelUpdater);
    }

    public UndoScoreImpacter changeSoftScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long softImpact = this.scoreLevelWeight * matchWeight;
        this.softScoreLevelUpdater.accept(this.scoreLevel, softImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.softScoreLevelUpdater.accept(this.scoreLevel, -softImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableLongScore.ofSoft((int)this.hardScoreLevelCount, (int)this.softScoreLevelCount, (int)this.scoreLevel, (long)softImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeHardScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long hardImpact = this.scoreLevelWeight * matchWeight;
        this.hardScoreLevelUpdater.accept(this.scoreLevel, hardImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.hardScoreLevelUpdater.accept(this.scoreLevel, -hardImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableLongScore.ofHard((int)this.hardScoreLevelCount, (int)this.softScoreLevelCount, (int)this.scoreLevel, (long)hardImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long[] hardImpacts = new long[this.hardScoreLevelCount];
        long[] softImpacts = new long[this.softScoreLevelCount];
        for (int hardScoreLevel = 0; hardScoreLevel < this.hardScoreLevelCount; ++hardScoreLevel) {
            long hardImpact;
            hardImpacts[hardScoreLevel] = hardImpact = ((BendableLongScore)this.constraintWeight).hardScore(hardScoreLevel) * matchWeight;
            this.hardScoreLevelUpdater.accept(hardScoreLevel, hardImpact);
        }
        for (int softScoreLevel = 0; softScoreLevel < this.softScoreLevelCount; ++softScoreLevel) {
            long softImpact;
            softImpacts[softScoreLevel] = softImpact = ((BendableLongScore)this.constraintWeight).softScore(softScoreLevel) * matchWeight;
            this.softScoreLevelUpdater.accept(softScoreLevel, softImpact);
        }
        UndoScoreImpacter undoScoreImpact = () -> {
            for (int hardScoreLevel = 0; hardScoreLevel < this.hardScoreLevelCount; ++hardScoreLevel) {
                this.hardScoreLevelUpdater.accept(hardScoreLevel, -hardImpacts[hardScoreLevel]);
            }
            for (int softScoreLevel = 0; softScoreLevel < this.softScoreLevelCount; ++softScoreLevel) {
                this.softScoreLevelUpdater.accept(softScoreLevel, -softImpacts[softScoreLevel]);
            }
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableLongScore.of((long[])hardImpacts, (long[])softImpacts), justificationsSupplier);
    }

    public static interface IntLongConsumer {
        public void accept(int var1, long var2);
    }
}

