/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.decorator;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;

public final class SelectedCountLimitEntitySelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements EntitySelector<Solution_> {
    private final EntitySelector<Solution_> childEntitySelector;
    private final boolean randomSelection;
    private final long selectedCountLimit;

    public SelectedCountLimitEntitySelector(EntitySelector<Solution_> childEntitySelector, boolean randomSelection, long selectedCountLimit) {
        this.childEntitySelector = childEntitySelector;
        this.randomSelection = randomSelection;
        this.selectedCountLimit = selectedCountLimit;
        if (selectedCountLimit < 0L) {
            throw new IllegalArgumentException("The selector (" + this + ") has a negative selectedCountLimit (" + selectedCountLimit + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childEntitySelector);
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public long getSize() {
        long childSize = this.childEntitySelector.getSize();
        return Math.min(this.selectedCountLimit, childSize);
    }

    @Override
    public Iterator<Object> iterator() {
        return new SelectedCountLimitEntityIterator(this.childEntitySelector.iterator());
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Object> endingIterator() {
        if (this.randomSelection) {
            return this.childEntitySelector.endingIterator();
        }
        return new SelectedCountLimitEntityIterator(this.childEntitySelector.endingIterator());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SelectedCountLimitEntitySelector that = (SelectedCountLimitEntitySelector)other;
        return this.randomSelection == that.randomSelection && this.selectedCountLimit == that.selectedCountLimit && Objects.equals(this.childEntitySelector, that.childEntitySelector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childEntitySelector, this.randomSelection, this.selectedCountLimit);
    }

    public String toString() {
        return "SelectedCountLimit(" + this.childEntitySelector + ")";
    }

    private class SelectedCountLimitEntityIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> childEntityIterator;
        private long selectedSize;

        public SelectedCountLimitEntityIterator(Iterator<Object> childEntityIterator) {
            this.childEntityIterator = childEntityIterator;
            this.selectedSize = 0L;
        }

        @Override
        public boolean hasNext() {
            return this.selectedSize < SelectedCountLimitEntitySelector.this.selectedCountLimit && this.childEntityIterator.hasNext();
        }

        @Override
        public Object next() {
            if (this.selectedSize >= SelectedCountLimitEntitySelector.this.selectedCountLimit) {
                throw new NoSuchElementException();
            }
            ++this.selectedSize;
            return this.childEntityIterator.next();
        }
    }
}

