/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.decorator;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.CompositeSelectionFilter;

@FunctionalInterface
public interface SelectionFilter<Solution_, T> {
    public static <Solution_, T> SelectionFilter<Solution_, T> compose(SelectionFilter<Solution_, T> ... filterArray) {
        return SelectionFilter.compose(Arrays.asList(filterArray));
    }

    public static <Solution_, T> SelectionFilter<Solution_, T> compose(List<SelectionFilter<Solution_, T>> filterList) {
        SelectionFilter[] distinctFilterArray = (SelectionFilter[])filterList.stream().flatMap(filter -> {
            if (filter == CompositeSelectionFilter.NOOP) {
                return Stream.empty();
            }
            if (filter instanceof CompositeSelectionFilter) {
                return Arrays.stream(((CompositeSelectionFilter)filter).selectionFilterArray);
            }
            return Stream.of(filter);
        }).distinct().toArray(SelectionFilter[]::new);
        switch (distinctFilterArray.length) {
            case 0: {
                return CompositeSelectionFilter.NOOP;
            }
            case 1: {
                return distinctFilterArray[0];
            }
        }
        return new CompositeSelectionFilter(distinctFilterArray);
    }

    public boolean accept(ScoreDirector<Solution_> var1, T var2);
}

