/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.decorator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public abstract class AbstractCachingEntitySelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements SelectionCacheLifecycleListener<Solution_>,
EntitySelector<Solution_> {
    protected final EntitySelector<Solution_> childEntitySelector;
    protected final SelectionCacheType cacheType;
    protected List<Object> cachedEntityList = null;

    public AbstractCachingEntitySelector(EntitySelector<Solution_> childEntitySelector, SelectionCacheType cacheType) {
        this.childEntitySelector = childEntitySelector;
        this.cacheType = cacheType;
        if (childEntitySelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has a childEntitySelector (" + childEntitySelector + ") with neverEnding (" + childEntitySelector.isNeverEnding() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childEntitySelector);
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + cacheType + ").");
        }
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    public EntitySelector<Solution_> getChildEntitySelector() {
        return this.childEntitySelector;
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void constructCache(SolverScope<Solution_> solverScope) {
        long childSize = this.childEntitySelector.getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + this + ") has a childEntitySelector (" + this.childEntitySelector + ") with childSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        this.cachedEntityList = new ArrayList<Object>((int)childSize);
        this.childEntitySelector.iterator().forEachRemaining(this.cachedEntityList::add);
        this.logger.trace("    Created cachedEntityList: size ({}), entitySelector ({}).", (Object)this.cachedEntityList.size(), (Object)this);
    }

    @Override
    public void disposeCache(SolverScope<Solution_> solverScope) {
        this.cachedEntityList = null;
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public long getSize() {
        return this.cachedEntityList.size();
    }

    @Override
    public Iterator<Object> endingIterator() {
        return this.cachedEntityList.iterator();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractCachingEntitySelector that = (AbstractCachingEntitySelector)other;
        return Objects.equals(this.childEntitySelector, that.childEntitySelector) && this.cacheType == that.cacheType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.childEntitySelector, this.cacheType});
    }
}

