/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt;

import java.util.Objects;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningListVariable;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.move.generic.list.kopt.KOptListMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptListMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelectorFactory;

public final class KOptListMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, KOptListMoveSelectorConfig> {
    private static final int DEFAULT_MINIMUM_K = 2;
    private static final int DEFAULT_MAXIMUM_K = 2;

    public KOptListMoveSelectorFactory(KOptListMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        int i;
        ValueSelectorConfig originSelectorConfig = Objects.requireNonNullElseGet(((KOptListMoveSelectorConfig)this.config).getOriginSelectorConfig(), ValueSelectorConfig::new);
        ValueSelectorConfig valueSelectorConfig = Objects.requireNonNullElseGet(((KOptListMoveSelectorConfig)this.config).getValueSelectorConfig(), ValueSelectorConfig::new);
        EntityDescriptor<Solution_> entityDescriptor = this.getTheOnlyEntityDescriptor(configPolicy.getSolutionDescriptor());
        EntityIndependentValueSelector<Solution_> originSelector = this.buildEntityIndependentValueSelector(configPolicy, entityDescriptor, originSelectorConfig, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection));
        EntityIndependentValueSelector<Solution_> valueSelector = this.buildEntityIndependentValueSelector(configPolicy, entityDescriptor, valueSelectorConfig, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection));
        GenuineVariableDescriptor<Solution_> variableDescriptor = this.getTheOnlyVariableDescriptor(entityDescriptor);
        if (!variableDescriptor.isListVariable()) {
            throw new IllegalArgumentException("The kOptListMoveSelector (" + this.config + ") can only be used when the domain model has a list variable. Check your @" + PlanningEntity.class.getSimpleName() + " and make sure it has a @" + PlanningListVariable.class.getSimpleName() + ".");
        }
        int minimumK = Objects.requireNonNullElse(((KOptListMoveSelectorConfig)this.config).getMinimumK(), 2);
        if (minimumK < 2) {
            throw new IllegalArgumentException("minimumK (" + minimumK + ") must be at least 2.");
        }
        int maximumK = Objects.requireNonNullElse(((KOptListMoveSelectorConfig)this.config).getMaximumK(), 2);
        if (maximumK < minimumK) {
            throw new IllegalArgumentException("maximumK (" + maximumK + ") must be at least minimumK (" + minimumK + ").");
        }
        int[] pickedKDistribution = new int[maximumK - minimumK + 1];
        int total = 1;
        for (i = minimumK; i < maximumK; ++i) {
            total *= 8;
        }
        for (i = 0; i < pickedKDistribution.length - 1; ++i) {
            int remainder = total / 8;
            pickedKDistribution[i] = total - remainder;
            total = remainder;
        }
        pickedKDistribution[pickedKDistribution.length - 1] = total;
        return new KOptListMoveSelector<Solution_>((ListVariableDescriptor)variableDescriptor, originSelector, valueSelector, minimumK, maximumK, pickedKDistribution);
    }

    private EntityIndependentValueSelector<Solution_> buildEntityIndependentValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, ValueSelectorConfig valueSelectorConfig, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        ValueSelector valueSelector = ValueSelectorFactory.create(valueSelectorConfig).buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, inheritedSelectionOrder);
        if (!(valueSelector instanceof EntityIndependentValueSelector)) {
            throw new IllegalArgumentException("The kOptListMoveSelector (" + this.config + ") for a list variable needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your valueSelectorConfig.");
        }
        return (EntityIndependentValueSelector)valueSelector;
    }
}

