/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.mimic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicReplayingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.ValueMimicRecorder;

public class MimicRecordingValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements ValueMimicRecorder<Solution_>,
EntityIndependentValueSelector<Solution_> {
    protected final EntityIndependentValueSelector<Solution_> childValueSelector;
    protected final List<MimicReplayingValueSelector<Solution_>> replayingValueSelectorList;

    public MimicRecordingValueSelector(EntityIndependentValueSelector<Solution_> childValueSelector) {
        this.childValueSelector = childValueSelector;
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
        this.replayingValueSelectorList = new ArrayList<MimicReplayingValueSelector<Solution_>>();
    }

    @Override
    public void addMimicReplayingValueSelector(MimicReplayingValueSelector<Solution_> replayingValueSelector) {
        this.replayingValueSelectorList.add(replayingValueSelector);
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.childValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childValueSelector.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity);
    }

    @Override
    public long getSize() {
        return this.childValueSelector.getSize();
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return new RecordingValueIterator(this.childValueSelector.iterator(entity));
    }

    @Override
    public Iterator<Object> iterator() {
        return new RecordingValueIterator(this.childValueSelector.iterator());
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.childValueSelector.endingIterator(entity);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MimicRecordingValueSelector that = (MimicRecordingValueSelector)other;
        return Objects.equals(this.childValueSelector, that.childValueSelector) && Objects.equals(this.replayingValueSelectorList.size(), that.replayingValueSelectorList.size());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childValueSelector, this.replayingValueSelectorList.size());
    }

    public String toString() {
        return "Recording(" + this.childValueSelector + ")";
    }

    private class RecordingValueIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> childValueIterator;

        public RecordingValueIterator(Iterator<Object> childValueIterator) {
            this.childValueIterator = childValueIterator;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.childValueIterator.hasNext();
            for (MimicReplayingValueSelector replayingValueSelector : MimicRecordingValueSelector.this.replayingValueSelectorList) {
                replayingValueSelector.recordedHasNext(hasNext);
            }
            return hasNext;
        }

        @Override
        public Object next() {
            Object next = this.childValueIterator.next();
            for (MimicReplayingValueSelector replayingValueSelector : MimicRecordingValueSelector.this.replayingValueSelectorList) {
                replayingValueSelector.recordedNext(next);
            }
            return next;
        }
    }
}

