/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.config.blueprint.SolverBenchmarkBluePrintConfig;
import org.optaplanner.benchmark.config.report.BenchmarkReportConfig;
import org.optaplanner.benchmark.impl.io.PlannerBenchmarkConfigIO;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.io.OptaPlannerXmlSerializationException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="plannerBenchmark")
@XmlType(propOrder={"name", "benchmarkDirectory", "threadFactoryClass", "parallelBenchmarkCount", "warmUpMillisecondsSpentLimit", "warmUpSecondsSpentLimit", "warmUpMinutesSpentLimit", "warmUpHoursSpentLimit", "warmUpDaysSpentLimit", "benchmarkReportConfig", "inheritedSolverBenchmarkConfig", "solverBenchmarkBluePrintConfigList", "solverBenchmarkConfigList"})
public class PlannerBenchmarkConfig {
    public static final String SOLVER_NAMESPACE_PREFIX = "solver";
    public static final String XML_ELEMENT_NAME = "plannerBenchmark";
    public static final String XML_NAMESPACE = "https://www.optaplanner.org/xsd/benchmark";
    public static final String PARALLEL_BENCHMARK_COUNT_AUTO = "AUTO";
    @XmlTransient
    private ClassLoader classLoader = null;
    private String name = null;
    private File benchmarkDirectory = null;
    private Class<? extends ThreadFactory> threadFactoryClass = null;
    private String parallelBenchmarkCount = null;
    private Long warmUpMillisecondsSpentLimit = null;
    private Long warmUpSecondsSpentLimit = null;
    private Long warmUpMinutesSpentLimit = null;
    private Long warmUpHoursSpentLimit = null;
    private Long warmUpDaysSpentLimit = null;
    @XmlElement(name="benchmarkReport")
    private BenchmarkReportConfig benchmarkReportConfig = null;
    @XmlElement(name="inheritedSolverBenchmark")
    private SolverBenchmarkConfig inheritedSolverBenchmarkConfig = null;
    @XmlElement(name="solverBenchmarkBluePrint")
    private List<SolverBenchmarkBluePrintConfig> solverBenchmarkBluePrintConfigList = null;
    @XmlElement(name="solverBenchmark")
    private List<SolverBenchmarkConfig> solverBenchmarkConfigList = null;

    public static PlannerBenchmarkConfig createFromSolverConfig(SolverConfig solverConfig) {
        return PlannerBenchmarkConfig.createFromSolverConfig(solverConfig, new File("local/benchmarkReport"));
    }

    public static PlannerBenchmarkConfig createFromSolverConfig(SolverConfig solverConfig, File benchmarkDirectory) {
        PlannerBenchmarkConfig plannerBenchmarkConfig = new PlannerBenchmarkConfig();
        plannerBenchmarkConfig.setBenchmarkDirectory(benchmarkDirectory);
        SolverBenchmarkConfig solverBenchmarkConfig = new SolverBenchmarkConfig();
        solverBenchmarkConfig.setSolverConfig(new SolverConfig(solverConfig));
        plannerBenchmarkConfig.setInheritedSolverBenchmarkConfig(solverBenchmarkConfig);
        plannerBenchmarkConfig.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromXmlResource(String benchmarkConfigResource) {
        return PlannerBenchmarkConfig.createFromXmlResource(benchmarkConfigResource, null);
    }

    public static PlannerBenchmarkConfig createFromXmlResource(String benchmarkConfigResource, ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        block11: {
            ClassLoader actualClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            InputStream in = actualClassLoader.getResourceAsStream(benchmarkConfigResource);
            try {
                if (in == null) {
                    String errorMessage = "The benchmarkConfigResource (" + benchmarkConfigResource + ") does not exist as a classpath resource in the classLoader (" + actualClassLoader + ").";
                    if (benchmarkConfigResource.startsWith("/")) {
                        errorMessage = errorMessage + "\nA classpath resource should not start with a slash (/). A benchmarkConfigResource adheres to ClassLoader.getResource(String). Maybe remove the leading slash from the benchmarkConfigResource.";
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromXmlInputStream(in, classLoader);
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OptaPlannerXmlSerializationException e) {
                    throw new IllegalArgumentException("Unmarshalling of benchmarkConfigResource (" + benchmarkConfigResource + ") fails.", e);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Reading the benchmarkConfigResource (" + benchmarkConfigResource + ") fails.", e);
                }
            }
            in.close();
        }
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromXmlFile(File benchmarkConfigFile) {
        return PlannerBenchmarkConfig.createFromXmlFile(benchmarkConfigFile, null);
    }

    public static PlannerBenchmarkConfig createFromXmlFile(File benchmarkConfigFile, ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        FileInputStream in = new FileInputStream(benchmarkConfigFile);
        try {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromXmlInputStream(in, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (OptaPlannerXmlSerializationException e) {
                throw new IllegalArgumentException("Unmarshalling the benchmarkConfigFile (" + benchmarkConfigFile + ") fails.", e);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The benchmarkConfigFile (" + benchmarkConfigFile + ") was not found.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading the benchmarkConfigFile (" + benchmarkConfigFile + ") fails.", e);
            }
        }
        ((InputStream)in).close();
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromXmlInputStream(InputStream in) {
        return PlannerBenchmarkConfig.createFromXmlInputStream(in, null);
    }

    public static PlannerBenchmarkConfig createFromXmlInputStream(InputStream in, ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        try {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromXmlReader(reader, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("This vm does not support the charset (" + StandardCharsets.UTF_8 + ").", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading fails.", e);
            }
        }
        ((Reader)reader).close();
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromXmlReader(Reader reader) {
        return PlannerBenchmarkConfig.createFromXmlReader(reader, null);
    }

    public static PlannerBenchmarkConfig createFromXmlReader(Reader reader, ClassLoader classLoader) {
        PlannerBenchmarkConfigIO xmlIO = new PlannerBenchmarkConfigIO();
        PlannerBenchmarkConfig benchmarkConfigObject = xmlIO.read(reader);
        if (!(benchmarkConfigObject instanceof PlannerBenchmarkConfig)) {
            throw new IllegalArgumentException("The " + PlannerBenchmarkConfig.class.getSimpleName() + "'s XML root element resolves to a different type (" + (benchmarkConfigObject == null ? null : benchmarkConfigObject.getClass().getSimpleName()) + ")." + (String)(benchmarkConfigObject instanceof SolverConfig ? "\nMaybe use " + PlannerBenchmarkFactory.class.getSimpleName() + ".createFromSolverConfigXmlResource() instead." : ""));
        }
        PlannerBenchmarkConfig benchmarkConfig = benchmarkConfigObject;
        benchmarkConfig.setClassLoader(classLoader);
        return benchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlResource(String templateResource) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlResource(String templateResource, ClassLoader classLoader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, null, classLoader);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlResource(String templateResource, Object model) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, model, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlResource(String templateResource, Object model, ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        block10: {
            ClassLoader actualClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            InputStream templateIn = actualClassLoader.getResourceAsStream(templateResource);
            try {
                if (templateIn == null) {
                    String errorMessage = "The templateResource (" + templateResource + ") does not exist as a classpath resource in the classLoader (" + actualClassLoader + ").";
                    if (templateResource.startsWith("/")) {
                        errorMessage = errorMessage + "\nA classpath resource should not start with a slash (/). A templateResource adheres to ClassLoader.getResource(String). Maybe remove the leading slash from the templateResource.";
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, model, classLoader);
                if (templateIn == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (templateIn != null) {
                        try {
                            templateIn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Reading the templateResource (" + templateResource + ") fails.", e);
                }
            }
            templateIn.close();
        }
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlFile(File templateFile) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlFile(File templateFile, ClassLoader classLoader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, null, classLoader);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlFile(File templateFile, Object model) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, model, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlFile(File templateFile, Object model, ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        FileInputStream templateIn = new FileInputStream(templateFile);
        try {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, model, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    templateIn.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The templateFile (" + templateFile + ") was not found.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading the templateFile (" + templateFile + ") fails.", e);
            }
        }
        templateIn.close();
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlInputStream(InputStream templateIn) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlInputStream(InputStream templateIn, ClassLoader classLoader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, null, classLoader);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlInputStream(InputStream templateIn, Object model) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, model, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlInputStream(InputStream templateIn, Object model, ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        InputStreamReader reader = new InputStreamReader(templateIn, StandardCharsets.UTF_8);
        try {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlReader(reader, model, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("This vm does not support the charset (" + StandardCharsets.UTF_8 + ").", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading fails.", e);
            }
        }
        ((Reader)reader).close();
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlReader(Reader templateReader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlReader(Reader templateReader, ClassLoader classLoader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader, null, classLoader);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlReader(Reader templateReader, Object model) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader, model, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlReader(Reader templateReader, Object model, ClassLoader classLoader) {
        String xmlContent;
        Template template;
        Configuration freemarkerConfiguration = new Configuration(new Version("2.3.31"));
        freemarkerConfiguration.setDefaultEncoding("UTF-8");
        freemarkerConfiguration.setNumberFormat("computer");
        freemarkerConfiguration.setDateFormat("yyyy-mm-dd");
        freemarkerConfiguration.setDateTimeFormat("yyyy-mm-dd HH:mm:ss.SSS z");
        freemarkerConfiguration.setTimeFormat("HH:mm:ss.SSS");
        try {
            template = new Template("benchmarkTemplate.ftl", templateReader, freemarkerConfiguration, "UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not read the Freemarker template from templateReader.", e);
        }
        try (StringWriter xmlContentWriter = new StringWriter();){
            template.process(model, (Writer)xmlContentWriter);
            xmlContent = xmlContentWriter.toString();
        }
        catch (TemplateException | IOException e) {
            throw new IllegalArgumentException("Can not process the Freemarker template into xmlContentWriter.", e);
        }
        try (StringReader configReader = new StringReader(xmlContent);){
            PlannerBenchmarkConfig plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromXmlReader(configReader, classLoader);
            return plannerBenchmarkConfig;
        }
    }

    public PlannerBenchmarkConfig() {
    }

    public PlannerBenchmarkConfig(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public Class<? extends ThreadFactory> getThreadFactoryClass() {
        return this.threadFactoryClass;
    }

    public void setThreadFactoryClass(Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
    }

    public String getParallelBenchmarkCount() {
        return this.parallelBenchmarkCount;
    }

    public void setParallelBenchmarkCount(String parallelBenchmarkCount) {
        this.parallelBenchmarkCount = parallelBenchmarkCount;
    }

    public Long getWarmUpMillisecondsSpentLimit() {
        return this.warmUpMillisecondsSpentLimit;
    }

    public void setWarmUpMillisecondsSpentLimit(Long warmUpMillisecondsSpentLimit) {
        this.warmUpMillisecondsSpentLimit = warmUpMillisecondsSpentLimit;
    }

    public Long getWarmUpSecondsSpentLimit() {
        return this.warmUpSecondsSpentLimit;
    }

    public void setWarmUpSecondsSpentLimit(Long warmUpSecondsSpentLimit) {
        this.warmUpSecondsSpentLimit = warmUpSecondsSpentLimit;
    }

    public Long getWarmUpMinutesSpentLimit() {
        return this.warmUpMinutesSpentLimit;
    }

    public void setWarmUpMinutesSpentLimit(Long warmUpMinutesSpentLimit) {
        this.warmUpMinutesSpentLimit = warmUpMinutesSpentLimit;
    }

    public Long getWarmUpHoursSpentLimit() {
        return this.warmUpHoursSpentLimit;
    }

    public void setWarmUpHoursSpentLimit(Long warmUpHoursSpentLimit) {
        this.warmUpHoursSpentLimit = warmUpHoursSpentLimit;
    }

    public Long getWarmUpDaysSpentLimit() {
        return this.warmUpDaysSpentLimit;
    }

    public void setWarmUpDaysSpentLimit(Long warmUpDaysSpentLimit) {
        this.warmUpDaysSpentLimit = warmUpDaysSpentLimit;
    }

    public BenchmarkReportConfig getBenchmarkReportConfig() {
        return this.benchmarkReportConfig;
    }

    public void setBenchmarkReportConfig(BenchmarkReportConfig benchmarkReportConfig) {
        this.benchmarkReportConfig = benchmarkReportConfig;
    }

    public SolverBenchmarkConfig getInheritedSolverBenchmarkConfig() {
        return this.inheritedSolverBenchmarkConfig;
    }

    public void setInheritedSolverBenchmarkConfig(SolverBenchmarkConfig inheritedSolverBenchmarkConfig) {
        this.inheritedSolverBenchmarkConfig = inheritedSolverBenchmarkConfig;
    }

    public List<SolverBenchmarkBluePrintConfig> getSolverBenchmarkBluePrintConfigList() {
        return this.solverBenchmarkBluePrintConfigList;
    }

    public void setSolverBenchmarkBluePrintConfigList(List<SolverBenchmarkBluePrintConfig> solverBenchmarkBluePrintConfigList) {
        this.solverBenchmarkBluePrintConfigList = solverBenchmarkBluePrintConfigList;
    }

    public List<SolverBenchmarkConfig> getSolverBenchmarkConfigList() {
        return this.solverBenchmarkConfigList;
    }

    public void setSolverBenchmarkConfigList(List<SolverBenchmarkConfig> solverBenchmarkConfigList) {
        this.solverBenchmarkConfigList = solverBenchmarkConfigList;
    }

    public PlannerBenchmarkConfig withClassLoader(ClassLoader classLoader) {
        this.setClassLoader(classLoader);
        return this;
    }

    public PlannerBenchmarkConfig withName(String name) {
        this.setName(name);
        return this;
    }

    public PlannerBenchmarkConfig withBenchmarkDirectory(File benchmarkDirectory) {
        this.setBenchmarkDirectory(benchmarkDirectory);
        return this;
    }

    public PlannerBenchmarkConfig withThreadFactoryClass(Class<? extends ThreadFactory> threadFactoryClass) {
        this.setThreadFactoryClass(threadFactoryClass);
        return this;
    }

    public PlannerBenchmarkConfig withParallelBenchmarkCount(String parallelBenchmarkCount) {
        this.setParallelBenchmarkCount(parallelBenchmarkCount);
        return this;
    }

    public PlannerBenchmarkConfig withWarmUpMillisecondsSpentLimit(Long warmUpMillisecondsSpentLimit) {
        this.setWarmUpMillisecondsSpentLimit(warmUpMillisecondsSpentLimit);
        return this;
    }

    public PlannerBenchmarkConfig withWarmUpSecondsSpentLimit(Long warmUpSecondsSpentLimit) {
        this.setWarmUpSecondsSpentLimit(warmUpSecondsSpentLimit);
        return this;
    }

    public PlannerBenchmarkConfig withWarmUpMinutesSpentLimit(Long warmUpMinutesSpentLimit) {
        this.setWarmUpMinutesSpentLimit(warmUpMinutesSpentLimit);
        return this;
    }

    public PlannerBenchmarkConfig withWarmUpHoursSpentLimit(Long warmUpHoursSpentLimit) {
        this.setWarmUpHoursSpentLimit(warmUpHoursSpentLimit);
        return this;
    }

    public PlannerBenchmarkConfig withWarmUpDaysSpentLimit(Long warmUpDaysSpentLimit) {
        this.setWarmUpDaysSpentLimit(warmUpDaysSpentLimit);
        return this;
    }

    public PlannerBenchmarkConfig withBenchmarkReportConfig(BenchmarkReportConfig benchmarkReportConfig) {
        this.setBenchmarkReportConfig(benchmarkReportConfig);
        return this;
    }

    public PlannerBenchmarkConfig withInheritedSolverBenchmarkConfig(SolverBenchmarkConfig inheritedSolverBenchmarkConfig) {
        this.setInheritedSolverBenchmarkConfig(inheritedSolverBenchmarkConfig);
        return this;
    }

    public PlannerBenchmarkConfig withSolverBenchmarkBluePrintConfigList(List<SolverBenchmarkBluePrintConfig> solverBenchmarkBluePrintConfigList) {
        this.setSolverBenchmarkBluePrintConfigList(solverBenchmarkBluePrintConfigList);
        return this;
    }

    public PlannerBenchmarkConfig withSolverBenchmarkBluePrintConfigs(SolverBenchmarkBluePrintConfig ... solverBenchmarkBluePrintConfigs) {
        this.setSolverBenchmarkBluePrintConfigList(List.of(solverBenchmarkBluePrintConfigs));
        return this;
    }

    public PlannerBenchmarkConfig withSolverBenchmarkConfigList(List<SolverBenchmarkConfig> solverBenchmarkConfigList) {
        this.setSolverBenchmarkConfigList(solverBenchmarkConfigList);
        return this;
    }

    public PlannerBenchmarkConfig withSolverBenchmarkConfigs(SolverBenchmarkConfig ... solverBenchmarkConfigs) {
        this.setSolverBenchmarkConfigList(List.of(solverBenchmarkConfigs));
        return this;
    }
}

