/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.jackson.JacksonUniqueIdGenerator;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrResource;

@JsonIdentityInfo(generator=JacksonUniqueIdGenerator.class)
public class MrMachineCapacity
extends AbstractPersistable {
    private MrMachine machine;
    private MrResource resource;
    private long maximumCapacity;
    private long safetyCapacity;

    MrMachineCapacity() {
    }

    public MrMachineCapacity(MrMachine machine, MrResource resource, long maximumCapacity, long safetyCapacity) {
        this.machine = machine;
        this.resource = resource;
        this.maximumCapacity = maximumCapacity;
        this.safetyCapacity = safetyCapacity;
    }

    public MrMachineCapacity(long id, MrMachine machine, MrResource resource, long maximumCapacity, long safetyCapacity) {
        super(id);
        this.machine = machine;
        this.resource = resource;
        this.maximumCapacity = maximumCapacity;
        this.safetyCapacity = safetyCapacity;
    }

    public MrMachine getMachine() {
        return this.machine;
    }

    public MrResource getResource() {
        return this.resource;
    }

    public long getMaximumCapacity() {
        return this.maximumCapacity;
    }

    public long getSafetyCapacity() {
        return this.safetyCapacity;
    }

    @JsonIgnore
    public boolean isTransientlyConsumed() {
        return this.resource.isTransientlyConsumed();
    }
}

