/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.nqueens.domain.Queen;

public class NQueensConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.horizontalConflict(factory), this.ascendingDiagonalConflict(factory), this.descendingDiagonalConflict(factory)};
    }

    protected Constraint horizontalConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Queen.class, Joiners.equal(Queen::getRowIndex)).penalize((Score)SimpleScore.ONE).asConstraint("Horizontal conflict");
    }

    protected Constraint ascendingDiagonalConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Queen.class, Joiners.equal(Queen::getAscendingDiagonalIndex)).penalize((Score)SimpleScore.ONE).asConstraint("Ascending diagonal conflict");
    }

    protected Constraint descendingDiagonalConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Queen.class, Joiners.equal(Queen::getDescendingDiagonalIndex)).penalize((Score)SimpleScore.ONE).asConstraint("Descending diagonal conflict");
    }
}

