/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.base.InitialFact;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.rule.EntryPointId;
import org.drools.base.time.JobHandle;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.UpdateContext;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.impl.WorkingMemoryReteExpireAction;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositePartitionAwareObjectSinkAdapter;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;

public class ObjectTypeNode
extends ObjectSource
implements ObjectSink {
    private static final long serialVersionUID = 510L;
    protected ObjectType objectType;
    private long expirationOffset = -1L;
    private volatile transient boolean dirty;
    protected transient IdGenerator idGenerator;
    public static final Id DEFAULT_ID = new Id(-1, 0);

    public int getOtnIdCounter() {
        return this.idGenerator.otnIdCounter;
    }

    public ObjectTypeNode() {
    }

    public ObjectTypeNode(int id, EntryPointNode source, ObjectType objectType, BuildContext context) {
        super(id, RuleBasePartitionId.MAIN_PARTITION, source, context.getRuleBase().getRuleBaseConfiguration().getAlphaNodeHashingThreshold(), context.getRuleBase().getRuleBaseConfiguration().getAlphaNodeRangeIndexThreshold());
        this.objectType = objectType;
        this.idGenerator = new IdGenerator(id);
        this.dirty = true;
        this.hashcode = this.calculateHashCode();
        this.initMemoryId(context);
    }

    public void setupParallelExecution(InternalRuleBase kbase) {
        if (this.objectType == ClassObjectType.InitialFact_ObjectType) {
            return;
        }
        CompositePartitionAwareObjectSinkAdapter partitionedSink = new CompositePartitionAwareObjectSinkAdapter(kbase.getParallelEvaluationSlotsCount());
        for (ObjectSink objectSink : this.sink.getSinks()) {
            partitionedSink.addObjectSink(objectSink, this.alphaNodeHashingThreshold, this.alphaNodeRangeIndexThreshold);
        }
        this.sink = partitionedSink;
    }

    public short getType() {
        return 30;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public RuleBasePartitionId getPartitionId() {
        return RuleBasePartitionId.MAIN_PARTITION;
    }

    @Override
    public BitMask calculateDeclaredMask(ObjectType modifiedType, List<String> settableProperties) {
        return EmptyBitMask.get();
    }

    public boolean isAssignableFrom(ObjectType objectType) {
        return this.objectType.isAssignableFrom(objectType);
    }

    public void assertInitialFact(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.checkDirty();
        this.propagateAssert(factHandle, context, reteEvaluator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDirty() {
        if (this.dirty) {
            ObjectTypeNode objectTypeNode = this;
            synchronized (objectTypeNode) {
                if (this.dirty) {
                    this.resetIdGenerator();
                    ObjectTypeNode.updateTupleSinkId(this, this);
                    this.dirty = false;
                }
            }
        }
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
    }

    public void propagateAssert(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.checkDirty();
        this.sink.propagateAssertObject(factHandle, context, reteEvaluator);
    }

    public void retractObject(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.checkDirty();
        ObjectTypeNode.doRetractObject(factHandle, context, reteEvaluator);
    }

    public void retractObject(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator, int partition) {
        this.checkDirty();
        ObjectTypeNode.retractRightTuples(factHandle, context, reteEvaluator, partition);
        ObjectTypeNode.retractLeftTuples(factHandle, context, reteEvaluator, partition);
    }

    public static void doRetractObject(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        ObjectTypeNode.retractRightTuples(factHandle, context, reteEvaluator);
        ObjectTypeNode.retractLeftTuples(factHandle, context, reteEvaluator);
    }

    public static void expireLeftTuple(LeftTuple leftTuple) {
        if (!leftTuple.isExpired()) {
            leftTuple.setExpired();
            for (LeftTuple child = leftTuple.getFirstChild(); child != null; child = child.getHandleNext()) {
                ObjectTypeNode.expireLeftTuple(child);
            }
            for (LeftTuple peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                ObjectTypeNode.expireLeftTuple(peer);
            }
        }
    }

    public static void expireRightTuple(RightTuple rightTuple) {
        for (LeftTuple child = rightTuple.getFirstChild(); child != null; child = child.getHandleNext()) {
            ObjectTypeNode.expireLeftTuple(child);
        }
    }

    public static void retractLeftTuples(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        factHandle.forEachLeftTuple(lt -> {
            LeftTupleSink sink = lt.getTupleSink();
            ((LeftInputAdapterNode)sink.getLeftTupleSource()).retractLeftTuple((LeftTuple)lt, context, reteEvaluator);
        });
        factHandle.clearLeftTuples();
    }

    public static void retractLeftTuples(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator, int partition) {
        DefaultFactHandle.CompositeLinkedTuples linkedTuples = (DefaultFactHandle.CompositeLinkedTuples)factHandle.getLinkedTuples();
        linkedTuples.forEachLeftTuple(partition, lt -> {
            LeftTupleSink sink = lt.getTupleSink();
            ((LeftInputAdapterNode)sink.getLeftTupleSource()).retractLeftTuple((LeftTuple)lt, context, reteEvaluator);
        });
        linkedTuples.clearLeftTuples(partition);
    }

    public static void retractRightTuples(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        factHandle.forEachRightTuple(rt -> rt.retractTuple(context, reteEvaluator));
        factHandle.clearRightTuples();
    }

    public static void retractRightTuples(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator, int partition) {
        DefaultFactHandle.CompositeLinkedTuples linkedTuples = (DefaultFactHandle.CompositeLinkedTuples)factHandle.getLinkedTuples();
        linkedTuples.forEachRightTuple(partition, rt -> rt.retractTuple(context, reteEvaluator));
        linkedTuples.clearRightTuples(partition);
    }

    protected void resetIdGenerator() {
        this.idGenerator.reset();
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.checkDirty();
        this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, reteEvaluator), reteEvaluator);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.checkDirty();
        Class classType = ((ClassObjectType)this.getObjectType()).getClassType();
        if (InitialFact.class.isAssignableFrom(classType)) {
            sink.assertObject(workingMemory.getInitialFactHandle(), context, workingMemory);
        } else {
            Iterator<InternalFactHandle> it = workingMemory.getStoreForClass(classType).iterator();
            while (it.hasNext()) {
                sink.assertObject(it.next(), context, workingMemory);
            }
        }
    }

    public Iterator<InternalFactHandle> getFactHandlesIterator(InternalWorkingMemory workingMemory) {
        Class classType = ((ClassObjectType)this.getObjectType()).getClassType();
        return InitialFact.class.isAssignableFrom(classType) ? Collections.singleton(workingMemory.getInitialFactHandle()).iterator() : workingMemory.getStoreForClass(classType).iterator();
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.source.addObjectSink(this);
        EntryPointNode epn = context.getRuleBase().getRete().getEntryPointNode(((EntryPointNode)this.source).getEntryPoint());
        if (epn == null) {
            return;
        }
        ObjectTypeConf objectTypeConf = epn.getTypeConfReg().getConfForObjectType(this.objectType);
        if (objectTypeConf != null) {
            objectTypeConf.resetCache();
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.dirty = true;
    }

    protected static void updateTupleSinkId(ObjectTypeNode otn, ObjectSource source) {
        for (ObjectSink sink : source.sink.getSinks()) {
            if (sink instanceof BetaNode) {
                ((BetaNode)sink).setRightInputOtnId(otn.nextOtnId());
                continue;
            }
            if (sink instanceof LeftInputAdapterNode) {
                for (LeftTupleSink liaChildSink : ((LeftInputAdapterNode)sink).getSinkPropagator().getSinks()) {
                    liaChildSink.setLeftInputOtnId(otn.nextOtnId());
                }
                continue;
            }
            if (sink instanceof WindowNode) {
                ((WindowNode)sink).setRightInputOtnId(otn.nextOtnId());
                ObjectTypeNode.updateTupleSinkId(otn, (WindowNode)sink);
                continue;
            }
            if (!(sink instanceof AlphaNode)) continue;
            ObjectTypeNode.updateTupleSinkId(otn, (AlphaNode)sink);
        }
    }

    public Id nextOtnId() {
        return this.idGenerator.nextId();
    }

    @Override
    public boolean remove(RuleRemovalContext context, ReteooBuilder builder) {
        return this.doRemove(context, builder);
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        return false;
    }

    @Override
    public String toString() {
        return "[ObjectTypeNode(" + this.id + ")::" + ((EntryPointNode)this.source).getEntryPoint() + " objectType=" + this.objectType + " expiration=" + this.getExpirationOffset() + "ms ]";
    }

    private int calculateHashCode() {
        return (this.objectType != null ? this.objectType.hashCode() : 0) * 37 + (this.source != null ? this.source.hashCode() : 0) * 31;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectTypeNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        ObjectTypeNode other = (ObjectTypeNode)object;
        return this.source.getId() == other.source.getId() && this.objectType.equals(other.objectType);
    }

    public EntryPointId getEntryPoint() {
        return ((EntryPointNode)this.source).getEntryPoint();
    }

    public long getExpirationOffset() {
        return this.expirationOffset;
    }

    public void setExpirationOffset(long expirationOffset) {
        this.expirationOffset = expirationOffset;
    }

    public void mergeExpirationOffset(ObjectTypeNode other) {
        this.setExpirationOffset(this.expirationOffset == -1L || other.expirationOffset == -1L ? -1L : Math.max(this.expirationOffset, other.expirationOffset));
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        throw new UnsupportedOperationException("This should never get called, as the PropertyReactive first happens at the AlphaNode");
    }

    public static class ExpireJobContext
    implements JobContext,
    Externalizable {
        public WorkingMemoryReteExpireAction expireAction;
        public transient ReteEvaluator reteEvaluator;
        public JobHandle handle;

        public ExpireJobContext() {
        }

        public ExpireJobContext(WorkingMemoryReteExpireAction expireAction, ReteEvaluator reteEvaluator) {
            this.expireAction = expireAction;
            this.reteEvaluator = reteEvaluator;
        }

        @Override
        public JobHandle getJobHandle() {
            return this.handle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.handle = jobHandle;
        }

        public WorkingMemoryReteExpireAction getExpireAction() {
            return this.expireAction;
        }

        @Override
        public ReteEvaluator getReteEvaluator() {
            return this.reteEvaluator;
        }

        public void setReteEvaluator(ReteEvaluator reteEvaluator) {
            this.reteEvaluator = reteEvaluator;
        }

        public JobHandle getHandle() {
            return this.handle;
        }

        public void setHandle(JobHandle handle) {
            this.handle = handle;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.expireAction = (WorkingMemoryReteExpireAction)in.readObject();
            this.handle = (JobHandle)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.expireAction);
            out.writeObject(this.handle);
        }
    }

    public static class ExpireJob
    implements Job,
    Serializable {
        @Override
        public void execute(JobContext ctx) {
            ExpireJobContext context = (ExpireJobContext)ctx;
            context.reteEvaluator.addPropagation(context.expireAction);
            context.getExpireAction().getFactHandle().removeJob((DefaultJobHandle)context.getJobHandle());
        }
    }

    public static class Id {
        private final int otnId;
        private final int id;

        public Id(int otnId, int id) {
            this.otnId = otnId;
            this.id = id;
        }

        public String toString() {
            return "ObjectTypeNode.Id[" + this.otnId + "#" + this.id + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id otherId = (Id)o;
            return this.id == otherId.id && this.otnId == otherId.otnId;
        }

        public int hashCode() {
            return 31 * this.otnId + 37 * this.id;
        }

        public boolean before(Id otherId) {
            return otherId != null && (this.otnId < otherId.otnId || this.otnId == otherId.otnId && this.id < otherId.id);
        }

        public int getId() {
            return this.id;
        }
    }

    private static class IdGenerator {
        private final int otnId;
        private int otnIdCounter;

        private IdGenerator(int otnId) {
            this.otnId = otnId;
        }

        private Id nextId() {
            return new Id(this.otnId, this.otnIdCounter++);
        }

        private void reset() {
            this.otnIdCounter = 0;
        }
    }
}

