/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.result;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.measurement.ScoreDifferencePercentage;
import org.optaplanner.benchmark.impl.ranking.ScoreSubSingleBenchmarkRankingComparator;
import org.optaplanner.benchmark.impl.ranking.SubSingleBenchmarkRankBasedComparator;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.report.ReportHelper;
import org.optaplanner.benchmark.impl.result.BenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.StatisticUtils;
import org.optaplanner.benchmark.impl.statistic.SubSingleStatistic;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.util.ConfigUtils;

public class SingleBenchmarkResult
implements BenchmarkResult {
    private static final AtomicLong ID_GENERATOR = new AtomicLong(1L);
    @XmlID
    @XmlAttribute
    private String id = String.valueOf(ID_GENERATOR.getAndIncrement());
    @XmlTransient
    private SolverBenchmarkResult solverBenchmarkResult;
    @XmlTransient
    private ProblemBenchmarkResult problemBenchmarkResult;
    @XmlElement(name="subSingleBenchmarkResult")
    private List<SubSingleBenchmarkResult> subSingleBenchmarkResultList = null;
    private Long usedMemoryAfterInputSolution = null;
    private Integer failureCount = null;
    private Score totalScore = null;
    private Score averageScore = null;
    private SubSingleBenchmarkResult median = null;
    private SubSingleBenchmarkResult best = null;
    private SubSingleBenchmarkResult worst = null;
    private Integer uninitializedSolutionCount = null;
    private Integer infeasibleScoreCount = null;
    private double[] standardDeviationDoubles = null;
    private long timeMillisSpent = -1L;
    private long scoreCalculationCount = -1L;
    private String scoreExplanationSummary = null;
    private Score<?> winningScoreDifference = null;
    private ScoreDifferencePercentage worstScoreDifferencePercentage = null;
    private Double worstScoreCalculationSpeedDifferencePercentage = null;
    private Integer ranking = null;

    public SingleBenchmarkResult() {
    }

    public SingleBenchmarkResult(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult) {
        this.solverBenchmarkResult = solverBenchmarkResult;
        this.problemBenchmarkResult = problemBenchmarkResult;
    }

    public void initSubSingleStatisticMaps() {
        for (SubSingleBenchmarkResult subSingleBenchmarkResult : this.subSingleBenchmarkResultList) {
            subSingleBenchmarkResult.initSubSingleStatisticMap();
        }
    }

    public SolverBenchmarkResult getSolverBenchmarkResult() {
        return this.solverBenchmarkResult;
    }

    public void setSolverBenchmarkResult(SolverBenchmarkResult solverBenchmarkResult) {
        this.solverBenchmarkResult = solverBenchmarkResult;
    }

    public ProblemBenchmarkResult getProblemBenchmarkResult() {
        return this.problemBenchmarkResult;
    }

    public void setProblemBenchmarkResult(ProblemBenchmarkResult problemBenchmarkResult) {
        this.problemBenchmarkResult = problemBenchmarkResult;
    }

    public List<SubSingleBenchmarkResult> getSubSingleBenchmarkResultList() {
        return this.subSingleBenchmarkResultList;
    }

    public void setSubSingleBenchmarkResultList(List<SubSingleBenchmarkResult> subSingleBenchmarkResultList) {
        this.subSingleBenchmarkResultList = subSingleBenchmarkResultList;
    }

    public Long getUsedMemoryAfterInputSolution() {
        return this.usedMemoryAfterInputSolution;
    }

    public void setUsedMemoryAfterInputSolution(Long usedMemoryAfterInputSolution) {
        this.usedMemoryAfterInputSolution = usedMemoryAfterInputSolution;
    }

    public Integer getFailureCount() {
        return this.failureCount;
    }

    public void setFailureCount(Integer failureCount) {
        this.failureCount = failureCount;
    }

    public long getTimeMillisSpent() {
        return this.timeMillisSpent;
    }

    public void setTimeMillisSpent(long timeMillisSpent) {
        this.timeMillisSpent = timeMillisSpent;
    }

    public long getScoreCalculationCount() {
        return this.scoreCalculationCount;
    }

    public void setScoreCalculationCount(long scoreCalculationCount) {
        this.scoreCalculationCount = scoreCalculationCount;
    }

    public String getScoreExplanationSummary() {
        return this.scoreExplanationSummary;
    }

    public Score<?> getWinningScoreDifference() {
        return this.winningScoreDifference;
    }

    public void setWinningScoreDifference(Score<?> winningScoreDifference) {
        this.winningScoreDifference = winningScoreDifference;
    }

    public ScoreDifferencePercentage getWorstScoreDifferencePercentage() {
        return this.worstScoreDifferencePercentage;
    }

    public void setWorstScoreDifferencePercentage(ScoreDifferencePercentage worstScoreDifferencePercentage) {
        this.worstScoreDifferencePercentage = worstScoreDifferencePercentage;
    }

    public Double getWorstScoreCalculationSpeedDifferencePercentage() {
        return this.worstScoreCalculationSpeedDifferencePercentage;
    }

    public void setWorstScoreCalculationSpeedDifferencePercentage(Double worstScoreCalculationSpeedDifferencePercentage) {
        this.worstScoreCalculationSpeedDifferencePercentage = worstScoreCalculationSpeedDifferencePercentage;
    }

    public Integer getRanking() {
        return this.ranking;
    }

    public void setRanking(Integer ranking) {
        this.ranking = ranking;
    }

    @Override
    public Score getAverageScore() {
        return this.averageScore;
    }

    public void setAverageAndTotalScoreForTesting(Score<?> averageAndTotalScore) {
        this.averageScore = averageAndTotalScore;
        this.totalScore = averageAndTotalScore;
    }

    public SubSingleBenchmarkResult getMedian() {
        return this.median;
    }

    public SubSingleBenchmarkResult getBest() {
        return this.best;
    }

    public SubSingleBenchmarkResult getWorst() {
        return this.worst;
    }

    public double[] getStandardDeviationDoubles() {
        return this.standardDeviationDoubles;
    }

    public Integer getInfeasibleScoreCount() {
        return this.infeasibleScoreCount;
    }

    public Integer getUninitializedSolutionCount() {
        return this.uninitializedSolutionCount;
    }

    public Score<?> getTotalScore() {
        return this.totalScore;
    }

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.getName());
    }

    @Override
    public String getName() {
        return this.problemBenchmarkResult.getName() + "_" + this.solverBenchmarkResult.getName();
    }

    public File getBenchmarkReportDirectory() {
        return this.problemBenchmarkResult.getBenchmarkReportDirectory();
    }

    @Override
    public boolean hasAllSuccess() {
        return this.failureCount != null && this.failureCount == 0;
    }

    public boolean isInitialized() {
        return this.averageScore != null && this.averageScore.isSolutionInitialized();
    }

    @Override
    public boolean hasAnyFailure() {
        return this.failureCount != null && this.failureCount != 0;
    }

    public boolean isScoreFeasible() {
        return this.averageScore.isFeasible();
    }

    public Long getScoreCalculationSpeed() {
        long timeMillisSpent = this.timeMillisSpent;
        if (timeMillisSpent == 0L) {
            timeMillisSpent = 1L;
        }
        return this.scoreCalculationCount * 1000L / timeMillisSpent;
    }

    public boolean isWinner() {
        return this.ranking != null && this.ranking == 0;
    }

    public SubSingleStatistic getSubSingleStatistic(ProblemStatisticType problemStatisticType) {
        return this.getMedian().getEffectiveSubSingleStatisticMap().get(problemStatisticType);
    }

    public int getSuccessCount() {
        return this.subSingleBenchmarkResultList.size() - this.failureCount;
    }

    public String getStandardDeviationString() {
        return StatisticUtils.getStandardDeviationString(this.standardDeviationDoubles);
    }

    @Override
    public String getResultDirectoryName() {
        return this.solverBenchmarkResult.getName();
    }

    @Override
    public File getResultDirectory() {
        return new File(this.problemBenchmarkResult.getProblemReportDirectory(), this.getResultDirectoryName());
    }

    public void makeDirs() {
        File singleReportDirectory = this.getResultDirectory();
        singleReportDirectory.mkdirs();
        for (SubSingleBenchmarkResult subSingleBenchmarkResult : this.subSingleBenchmarkResultList) {
            subSingleBenchmarkResult.makeDirs();
        }
    }

    public int getSubSingleCount() {
        return this.subSingleBenchmarkResultList.size();
    }

    public void accumulateResults(BenchmarkReport benchmarkReport) {
        for (SubSingleBenchmarkResult subSingleBenchmarkResult : this.subSingleBenchmarkResultList) {
            subSingleBenchmarkResult.accumulateResults(benchmarkReport);
        }
        this.determineTotalsAndAveragesAndRanking();
        this.standardDeviationDoubles = StatisticUtils.determineStandardDeviationDoubles(this.subSingleBenchmarkResultList, this.averageScore, this.getSuccessCount());
        this.determineRepresentativeSubSingleBenchmarkResult();
    }

    private void determineRepresentativeSubSingleBenchmarkResult() {
        if (this.subSingleBenchmarkResultList == null || this.subSingleBenchmarkResultList.isEmpty()) {
            throw new IllegalStateException("Cannot get representative subSingleBenchmarkResult from empty subSingleBenchmarkResultList.");
        }
        ArrayList<SubSingleBenchmarkResult> subSingleBenchmarkResultListCopy = new ArrayList<SubSingleBenchmarkResult>(this.subSingleBenchmarkResultList);
        subSingleBenchmarkResultListCopy.sort(new SubSingleBenchmarkRankBasedComparator());
        this.best = (SubSingleBenchmarkResult)subSingleBenchmarkResultListCopy.get(0);
        this.worst = (SubSingleBenchmarkResult)subSingleBenchmarkResultListCopy.get(subSingleBenchmarkResultListCopy.size() - 1);
        this.median = (SubSingleBenchmarkResult)subSingleBenchmarkResultListCopy.get(ConfigUtils.ceilDivide((int)(subSingleBenchmarkResultListCopy.size() - 1), (int)2));
        this.usedMemoryAfterInputSolution = this.median.getUsedMemoryAfterInputSolution();
        this.timeMillisSpent = this.median.getTimeMillisSpent();
        this.scoreCalculationCount = this.median.getScoreCalculationCount();
        this.scoreExplanationSummary = this.median.getScoreExplanationSummary();
    }

    private void determineTotalsAndAveragesAndRanking() {
        this.failureCount = 0;
        boolean firstNonFailure = true;
        this.totalScore = null;
        this.uninitializedSolutionCount = 0;
        this.infeasibleScoreCount = 0;
        ArrayList<SubSingleBenchmarkResult> successResultList = new ArrayList<SubSingleBenchmarkResult>(this.subSingleBenchmarkResultList);
        Iterator it = successResultList.iterator();
        while (it.hasNext()) {
            Integer n;
            SubSingleBenchmarkResult subSingleBenchmarkResult = (SubSingleBenchmarkResult)it.next();
            if (subSingleBenchmarkResult.hasAnyFailure()) {
                n = this.failureCount;
                this.failureCount = this.failureCount + 1;
                it.remove();
                continue;
            }
            if (!subSingleBenchmarkResult.isInitialized()) {
                n = this.uninitializedSolutionCount;
                this.uninitializedSolutionCount = this.uninitializedSolutionCount + 1;
            } else if (!subSingleBenchmarkResult.isScoreFeasible()) {
                n = this.infeasibleScoreCount;
                this.infeasibleScoreCount = this.infeasibleScoreCount + 1;
            }
            if (firstNonFailure) {
                this.totalScore = subSingleBenchmarkResult.getAverageScore();
                firstNonFailure = false;
                continue;
            }
            this.totalScore = this.totalScore.add(subSingleBenchmarkResult.getAverageScore());
        }
        if (!firstNonFailure) {
            this.averageScore = this.totalScore.divide((double)this.getSuccessCount());
        }
        this.determineRanking(successResultList);
    }

    private void determineRanking(List<SubSingleBenchmarkResult> rankedSubSingleBenchmarkResultList) {
        ScoreSubSingleBenchmarkRankingComparator subSingleBenchmarkRankingComparator = new ScoreSubSingleBenchmarkRankingComparator();
        rankedSubSingleBenchmarkResultList.sort(Collections.reverseOrder(subSingleBenchmarkRankingComparator));
        int ranking = 0;
        SubSingleBenchmarkResult previousSubSingleBenchmarkResult = null;
        int previousSameRankingCount = 0;
        for (SubSingleBenchmarkResult subSingleBenchmarkResult : rankedSubSingleBenchmarkResultList) {
            if (previousSubSingleBenchmarkResult != null && subSingleBenchmarkRankingComparator.compare(previousSubSingleBenchmarkResult, subSingleBenchmarkResult) != 0) {
                ranking += previousSameRankingCount;
                previousSameRankingCount = 0;
            }
            subSingleBenchmarkResult.setRanking(ranking);
            previousSubSingleBenchmarkResult = subSingleBenchmarkResult;
            ++previousSameRankingCount;
        }
    }

    protected static SingleBenchmarkResult createMerge(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult, SingleBenchmarkResult oldResult) {
        SingleBenchmarkResult newResult = new SingleBenchmarkResult(solverBenchmarkResult, problemBenchmarkResult);
        newResult.subSingleBenchmarkResultList = new ArrayList<SubSingleBenchmarkResult>(oldResult.getSubSingleBenchmarkResultList().size());
        int subSingleBenchmarkIndex = 0;
        for (SubSingleBenchmarkResult oldSubResult : oldResult.subSingleBenchmarkResultList) {
            SubSingleBenchmarkResult.createMerge(newResult, oldSubResult, subSingleBenchmarkIndex);
            ++subSingleBenchmarkIndex;
        }
        newResult.median = oldResult.median;
        newResult.best = oldResult.best;
        newResult.worst = oldResult.worst;
        solverBenchmarkResult.getSingleBenchmarkResultList().add(newResult);
        problemBenchmarkResult.getSingleBenchmarkResultList().add(newResult);
        return newResult;
    }

    public String toString() {
        return this.getName();
    }
}

