/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import org.drools.base.rule.Function;
import org.drools.compiler.builder.impl.processors.AbstractPackageCompilationPhase;
import org.drools.compiler.compiler.DuplicateFunction;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.FunctionImportDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class FunctionCompilationPhase
extends AbstractPackageCompilationPhase {
    private final KnowledgeBuilderConfiguration configuration;

    public FunctionCompilationPhase(PackageRegistry pkgRegistry, PackageDescr packageDescr, KnowledgeBuilderConfiguration configuration) {
        super(pkgRegistry, packageDescr);
        this.configuration = configuration;
    }

    @Override
    public void process() {
        for (FunctionDescr function : this.packageDescr.getFunctions()) {
            Function existingFunc = (Function)this.pkgRegistry.getPackage().getFunctions().get(function.getName());
            if (existingFunc == null || !function.getNamespace().equals(existingFunc.getNamespace())) continue;
            this.results.add((KnowledgeBuilderResult)new DuplicateFunction(function, this.configuration));
        }
        for (FunctionImportDescr functionImport : this.packageDescr.getFunctionImports()) {
            String importEntry = functionImport.getTarget();
            this.pkgRegistry.addStaticImport((ImportDescr)functionImport);
            this.pkgRegistry.getPackage().addStaticImport(importEntry);
        }
    }
}

