/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.entity.pillar;

import java.util.Comparator;
import java.util.Objects;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"subPillarEnabled", "minimumSubPillarSize", "maximumSubPillarSize"})
public final class SubPillarConfigPolicy {
    private final boolean subPillarEnabled;
    private final int minimumSubPillarSize;
    private final int maximumSubPillarSize;
    private final Comparator<?> entityComparator;

    private SubPillarConfigPolicy(int minimumSubPillarSize, int maximumSubPillarSize) {
        this.subPillarEnabled = true;
        this.minimumSubPillarSize = minimumSubPillarSize;
        this.maximumSubPillarSize = maximumSubPillarSize;
        this.validateSizes();
        this.entityComparator = null;
    }

    private SubPillarConfigPolicy(int minimumSubPillarSize, int maximumSubPillarSize, Comparator<?> entityComparator) {
        this.subPillarEnabled = true;
        this.minimumSubPillarSize = minimumSubPillarSize;
        this.maximumSubPillarSize = maximumSubPillarSize;
        this.validateSizes();
        if (entityComparator == null) {
            throw new IllegalStateException("The entityComparator must not be null.");
        }
        this.entityComparator = entityComparator;
    }

    private SubPillarConfigPolicy() {
        this.subPillarEnabled = false;
        this.minimumSubPillarSize = -1;
        this.maximumSubPillarSize = -1;
        this.entityComparator = null;
    }

    public static SubPillarConfigPolicy withoutSubpillars() {
        return new SubPillarConfigPolicy();
    }

    public static SubPillarConfigPolicy withSubpillars(int minSize, int maxSize) {
        return new SubPillarConfigPolicy(minSize, maxSize);
    }

    public static SubPillarConfigPolicy withSubpillarsUnlimited() {
        return SubPillarConfigPolicy.withSubpillars(1, Integer.MAX_VALUE);
    }

    public static SubPillarConfigPolicy sequential(int minSize, int maxSize, Comparator<?> entityComparator) {
        return new SubPillarConfigPolicy(minSize, maxSize, entityComparator);
    }

    public static SubPillarConfigPolicy sequentialUnlimited(Comparator<?> entityComparator) {
        return SubPillarConfigPolicy.sequential(1, Integer.MAX_VALUE, entityComparator);
    }

    private void validateSizes() {
        if (this.minimumSubPillarSize < 1) {
            throw new IllegalStateException("The sub pillar's minimumPillarSize (" + this.minimumSubPillarSize + ") must be at least 1.");
        }
        if (this.minimumSubPillarSize > this.maximumSubPillarSize) {
            throw new IllegalStateException("The minimumPillarSize (" + this.minimumSubPillarSize + ") must be at least maximumSubChainSize (" + this.maximumSubPillarSize + ").");
        }
    }

    public boolean isSubPillarEnabled() {
        return this.subPillarEnabled;
    }

    public int getMinimumSubPillarSize() {
        return this.minimumSubPillarSize;
    }

    public int getMaximumSubPillarSize() {
        return this.maximumSubPillarSize;
    }

    public Comparator<?> getEntityComparator() {
        return this.entityComparator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubPillarConfigPolicy that = (SubPillarConfigPolicy)o;
        return this.subPillarEnabled == that.subPillarEnabled && this.minimumSubPillarSize == that.minimumSubPillarSize && this.maximumSubPillarSize == that.maximumSubPillarSize && Objects.equals(this.entityComparator, that.entityComparator);
    }

    public int hashCode() {
        return Objects.hash(this.subPillarEnabled, this.minimumSubPillarSize, this.maximumSubPillarSize, this.entityComparator);
    }
}

