/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;
import org.optaplanner.test.impl.score.stream.ConfiguredConstraintVerifier;
import org.optaplanner.test.impl.score.stream.DefaultMultiConstraintVerification;
import org.optaplanner.test.impl.score.stream.DefaultSingleConstraintVerification;

public final class DefaultConstraintVerifier<ConstraintProvider_ extends ConstraintProvider, Solution_, Score_ extends Score<Score_>>
implements ConstraintVerifier<ConstraintProvider_, Solution_> {
    private final ConstraintProvider_ constraintProvider;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final AtomicReference<ConfiguredConstraintVerifier<ConstraintProvider_, Solution_, Score_>> configuredConstraintVerifierRef = new AtomicReference();
    private final AtomicReference<ConstraintStreamImplType> constraintStreamImplTypeRef = new AtomicReference();
    private final AtomicReference<Boolean> droolsAlphaNetworkCompilationEnabledRef = new AtomicReference();

    public DefaultConstraintVerifier(ConstraintProvider_ constraintProvider, SolutionDescriptor<Solution_> solutionDescriptor) {
        this.constraintProvider = constraintProvider;
        this.solutionDescriptor = solutionDescriptor;
    }

    public ConstraintStreamImplType getConstraintStreamImplType() {
        return this.constraintStreamImplTypeRef.get();
    }

    @Override
    public ConstraintVerifier<ConstraintProvider_, Solution_> withConstraintStreamImplType(ConstraintStreamImplType constraintStreamImplType) {
        Objects.requireNonNull(constraintStreamImplType);
        Boolean droolsAlphaNetworkCompilationEnabled = this.droolsAlphaNetworkCompilationEnabledRef.get();
        if (droolsAlphaNetworkCompilationEnabled != null && droolsAlphaNetworkCompilationEnabled.booleanValue() && constraintStreamImplType != ConstraintStreamImplType.DROOLS) {
            throw new IllegalArgumentException("Can not switch to " + ConstraintStreamImplType.class.getSimpleName() + "." + constraintStreamImplType + " while Drools Alpha Network Compilation enabled.");
        }
        this.constraintStreamImplTypeRef.set(constraintStreamImplType);
        this.configuredConstraintVerifierRef.set(null);
        return this;
    }

    public boolean isDroolsAlphaNetworkCompilationEnabled() {
        return Objects.requireNonNullElse(this.droolsAlphaNetworkCompilationEnabledRef.get(), !ConfigUtils.isNativeImage());
    }

    @Override
    public ConstraintVerifier<ConstraintProvider_, Solution_> withDroolsAlphaNetworkCompilationEnabled(boolean droolsAlphaNetworkCompilationEnabled) {
        if (droolsAlphaNetworkCompilationEnabled && this.getConstraintStreamImplType() == ConstraintStreamImplType.BAVET) {
            throw new IllegalArgumentException("Can not enable Drools Alpha Network Compilation with " + ConstraintStreamImplType.class.getSimpleName() + "." + ConstraintStreamImplType.BAVET + ".");
        }
        this.droolsAlphaNetworkCompilationEnabledRef.set(droolsAlphaNetworkCompilationEnabled);
        this.configuredConstraintVerifierRef.set(null);
        return this;
    }

    public DefaultSingleConstraintVerification<Solution_, Score_> verifyThat(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction) {
        return this.getOrCreateConfiguredConstraintVerifier().verifyThat(constraintFunction);
    }

    private ConfiguredConstraintVerifier<ConstraintProvider_, Solution_, Score_> getOrCreateConfiguredConstraintVerifier() {
        return this.configuredConstraintVerifierRef.updateAndGet(v -> {
            if (v == null) {
                return new ConfiguredConstraintVerifier(this.constraintProvider, this.solutionDescriptor, this.getConstraintStreamImplType(), this.isDroolsAlphaNetworkCompilationEnabled());
            }
            return v;
        });
    }

    public DefaultMultiConstraintVerification<Solution_, Score_> verifyThat() {
        return this.getOrCreateConfiguredConstraintVerifier().verifyThat();
    }
}

