/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.drools.core.util.Iterator;

public interface FastIterator<T> {
    public T next(T var1);

    public boolean isFullIterator();

    public static class IteratorAdapter<T>
    implements Iterator<T> {
        private final FastIterator<T> fastIterator;
        private T current = null;
        private boolean firstConsumed = false;

        public IteratorAdapter(FastIterator<T> fastIterator, T first) {
            this.fastIterator = fastIterator;
            this.current = first;
        }

        @Override
        public T next() {
            if (!this.firstConsumed) {
                this.firstConsumed = true;
                return this.current;
            }
            this.current = this.fastIterator.next(this.current);
            return this.current;
        }
    }

    public static class NullFastIterator<T>
    implements FastIterator<T> {
        public static final NullFastIterator INSTANCE = new NullFastIterator();

        @Override
        public T next(T object) {
            return null;
        }

        @Override
        public boolean isFullIterator() {
            return true;
        }
    }
}

