/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.Serializable;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.AbstractTuple;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;

public class TupleList<C>
implements TupleMemory,
Entry<TupleList<C>>,
Serializable {
    public static final long serialVersionUID = 510L;
    private TupleList<C> next;
    private Tuple first;
    private Tuple last;
    private TupleHashTableIterator iterator;
    private int size;
    private C context;

    public TupleList() {
    }

    public TupleList(C c) {
        this.context = c;
    }

    public TupleList(Tuple first, Tuple last, int size) {
        this.first = first;
        this.last = last;
        this.size = size;
    }

    public C getContext() {
        return this.context;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Tuple getFirst(Tuple tuple) {
        return this.first;
    }

    public Tuple getFirst() {
        return this.first;
    }

    public Tuple getLast() {
        return this.last;
    }

    @Override
    public void clear() {
        this.first = null;
        this.last = null;
        this.size = 0;
    }

    @Override
    public void removeAdd(Tuple tuple) {
        if (this.last == tuple) {
            return;
        }
        AbstractTuple previous = (AbstractTuple)tuple.getPrevious();
        AbstractTuple next = (AbstractTuple)tuple.getNext();
        if (previous == null) {
            next.setPrevious(null);
            this.first = next;
        } else {
            previous.setNext(next);
            next.setPrevious(previous);
        }
        this.last.setNext((AbstractTuple)tuple);
        tuple.setPrevious(this.last);
        tuple.setNext(null);
        this.last = tuple;
    }

    @Override
    public void add(Tuple tuple) {
        if (this.last != null) {
            this.last.setNext((AbstractTuple)tuple);
            tuple.setPrevious(this.last);
            this.last = tuple;
        } else {
            this.first = tuple;
            this.last = tuple;
        }
        tuple.setMemory(this);
        ++this.size;
    }

    @Override
    public void remove(Tuple tuple) {
        Tuple previous = tuple.getPrevious();
        AbstractTuple next = (AbstractTuple)tuple.getNext();
        if (previous != null && next != null) {
            previous.setNext(next);
            next.setPrevious(previous);
        } else if (next != null) {
            this.first = next;
            next.setPrevious(null);
        } else if (previous != null) {
            this.last = previous;
            previous.setNext(null);
        } else {
            this.last = null;
            this.first = null;
        }
        tuple.clear();
        --this.size;
    }

    public Tuple removeFirst() {
        Tuple tuple = this.first;
        if (this.last == tuple) {
            this.last = null;
            this.first = null;
        } else {
            this.first = (Tuple)tuple.getNext();
            if (this.first != null) {
                this.first.setPrevious(null);
            }
        }
        tuple.clear();
        --this.size;
        return tuple;
    }

    public Tuple get(Tuple tuple) {
        for (Tuple current = this.first; current != null; current = (Tuple)current.getNext()) {
            if (!tuple.equals(current)) continue;
            return current;
        }
        return null;
    }

    public Tuple get(InternalFactHandle handle) {
        for (Tuple current = this.first; current != null; current = (Tuple)current.getNext()) {
            if (handle != current.getFactHandle()) continue;
            return current;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Tuple[] toArray() {
        Tuple[] tuples = new Tuple[this.size];
        Tuple current = this.first;
        for (int i = 0; i < this.size; ++i) {
            tuples[i] = current;
            current = (Tuple)current.getNext();
        }
        return tuples;
    }

    @Override
    public TupleMemory.IndexType getIndexType() {
        return TupleMemory.IndexType.NONE;
    }

    @Override
    public FastIterator<Tuple> fastIterator() {
        return LinkedList.fastIterator;
    }

    @Override
    public FastIterator<Tuple> fullFastIterator() {
        return LinkedList.fastIterator;
    }

    @Override
    public FastIterator<Tuple> fullFastIterator(Tuple tuple) {
        return LinkedList.fastIterator;
    }

    @Override
    public Iterator<Tuple> iterator() {
        if (this.iterator == null) {
            this.iterator = new TupleHashTableIterator();
        }
        this.iterator.reset(this.first);
        return this.iterator;
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public TupleList getNext() {
        return this.next;
    }

    @Override
    public void setNext(TupleList next) {
        this.next = next;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Tuple> it = this.iterator();
        Tuple tuple = it.next();
        while (tuple != null) {
            builder.append(tuple).append("\n");
            tuple = it.next();
        }
        return builder.toString();
    }

    protected void copyStateInto(TupleList other) {
        other.next = this.next;
        other.first = this.first;
        other.context = this.context;
        other.last = this.last;
        other.iterator = this.iterator;
        other.size = this.size;
        for (Tuple current = this.first; current != null; current = (Tuple)current.getNext()) {
            current.setMemory(other);
        }
    }

    public static class TupleHashTableIterator
    implements Iterator<Tuple> {
        private Tuple current;

        public void reset(Tuple first) {
            this.current = first;
        }

        @Override
        public Tuple next() {
            if (this.current != null) {
                Tuple returnValue = this.current;
                this.current = (Tuple)this.current.getNext();
                return returnValue;
            }
            return null;
        }

        public void remove() {
        }
    }
}

