/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.list.nearby;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.list.RandomSubListSelector;
import org.optaplanner.core.impl.heuristic.selector.list.mimic.MimicReplayingSubListSelector;

final class SubListNearbySubListMatrixDemand<Solution_, Origin_, Destination_>
extends AbstractNearbyDistanceMatrixDemand<Origin_, Destination_, RandomSubListSelector<Solution_>, MimicReplayingSubListSelector<Solution_>> {
    private final ToIntFunction<Origin_> destinationSizeFunction;

    public SubListNearbySubListMatrixDemand(NearbyDistanceMeter<Origin_, Destination_> meter, NearbyRandom random, RandomSubListSelector<Solution_> childSubListSelector, MimicReplayingSubListSelector<Solution_> replayingOriginSubListSelector, ToIntFunction<Origin_> destinationSizeFunction) {
        super(meter, random, childSubListSelector, replayingOriginSubListSelector);
        this.destinationSizeFunction = destinationSizeFunction;
    }

    @Override
    protected NearbyDistanceMatrix<Origin_, Destination_> supplyNearbyDistanceMatrix() {
        long childSize = ((RandomSubListSelector)this.childSelector).getValueCount();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childSize (" + childSize + ") is higher than Integer.MAX_VALUE.");
        }
        long originSize = ((MimicReplayingSubListSelector)this.replayingSelector).getValueCount();
        if (originSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The originSubListSelector (" + this.replayingSelector + ") has a subListSize (" + originSize + ") which is higher than Integer.MAX_VALUE.");
        }
        Function<Object, Iterator> destinationIteratorProvider = origin -> ((RandomSubListSelector)this.childSelector).endingValueIterator();
        NearbyDistanceMatrix nearbyDistanceMatrix = new NearbyDistanceMatrix(this.meter, (int)originSize, destinationIteratorProvider, this.destinationSizeFunction);
        ((MimicReplayingSubListSelector)this.replayingSelector).endingValueIterator().forEachRemaining(origin -> nearbyDistanceMatrix.addAllDestinations(origin));
        return nearbyDistanceMatrix;
    }
}

