/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.optaplanner.core.api.domain.variable.PlanningListVariable;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.list.ListSwapMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.ListSwapMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelectorFactory;

public class ListSwapMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, ListSwapMoveSelectorConfig> {
    public ListSwapMoveSelectorFactory(ListSwapMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        ValueSelectorConfig valueSelectorConfig = Objects.requireNonNullElseGet(((ListSwapMoveSelectorConfig)this.config).getValueSelectorConfig(), ValueSelectorConfig::new);
        ValueSelectorConfig secondaryValueSelectorConfig = Objects.requireNonNullElse(((ListSwapMoveSelectorConfig)this.config).getSecondaryValueSelectorConfig(), valueSelectorConfig);
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntityDescriptor<Solution_> entityDescriptor = this.getTheOnlyEntityDescriptor(configPolicy.getSolutionDescriptor());
        EntityIndependentValueSelector<Solution_> leftValueSelector = this.buildEntityIndependentValueSelector(configPolicy, entityDescriptor, valueSelectorConfig, minimumCacheType, selectionOrder);
        EntityIndependentValueSelector<Solution_> rightValueSelector = this.buildEntityIndependentValueSelector(configPolicy, entityDescriptor, secondaryValueSelectorConfig, minimumCacheType, selectionOrder);
        GenuineVariableDescriptor variableDescriptor = leftValueSelector.getVariableDescriptor();
        if (variableDescriptor != rightValueSelector.getVariableDescriptor()) {
            throw new IllegalStateException("Impossible state: the leftValueSelector (" + leftValueSelector + ") and the rightValueSelector (" + rightValueSelector + ") have different variable descriptors. This should have failed fast during config unfolding.");
        }
        return new ListSwapMoveSelector<Solution_>(leftValueSelector, rightValueSelector, randomSelection);
    }

    private EntityIndependentValueSelector<Solution_> buildEntityIndependentValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, ValueSelectorConfig valueSelectorConfig, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        ValueSelector valueSelector = ValueSelectorFactory.create(valueSelectorConfig).buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, inheritedSelectionOrder);
        if (!(valueSelector instanceof EntityIndependentValueSelector)) {
            throw new IllegalArgumentException("The listSwapMoveSelector (" + this.config + ") for a list variable needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your valueSelectorConfig.");
        }
        return (EntityIndependentValueSelector)valueSelector;
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        GenuineVariableDescriptor onlySecondaryVariableDescriptor;
        GenuineVariableDescriptor onlyVariableDescriptor;
        EntityDescriptor<Solution_> entityDescriptor = this.getTheOnlyEntityDescriptor(configPolicy.getSolutionDescriptor());
        GenuineVariableDescriptor genuineVariableDescriptor = onlyVariableDescriptor = ((ListSwapMoveSelectorConfig)this.config).getValueSelectorConfig() == null ? null : ValueSelectorFactory.create(((ListSwapMoveSelectorConfig)this.config).getValueSelectorConfig()).extractVariableDescriptor(configPolicy, entityDescriptor);
        if (((ListSwapMoveSelectorConfig)this.config).getSecondaryValueSelectorConfig() != null && onlyVariableDescriptor != (onlySecondaryVariableDescriptor = ValueSelectorFactory.create(((ListSwapMoveSelectorConfig)this.config).getSecondaryValueSelectorConfig()).extractVariableDescriptor(configPolicy, entityDescriptor))) {
            throw new IllegalArgumentException("The valueSelector (" + ((ListSwapMoveSelectorConfig)this.config).getValueSelectorConfig() + ")'s variableName (" + (onlyVariableDescriptor == null ? null : onlyVariableDescriptor.getVariableName()) + ") and secondaryValueSelectorConfig (" + ((ListSwapMoveSelectorConfig)this.config).getSecondaryValueSelectorConfig() + ")'s variableName (" + (onlySecondaryVariableDescriptor == null ? null : onlySecondaryVariableDescriptor.getVariableName()) + ") must be the same planning list variable.");
        }
        if (onlyVariableDescriptor != null) {
            if (!onlyVariableDescriptor.isListVariable()) {
                throw new IllegalArgumentException("The listSwapMoveSelector (" + this.config + ") is configured to use a planning variable (" + onlyVariableDescriptor + "), which is not a planning list variable. Either fix your annotations and use a @" + PlanningListVariable.class.getSimpleName() + " on the variable to make it work with listSwapMoveSelector or use a swapMoveSelector instead.");
            }
            return null;
        }
        List<ListVariableDescriptor<Solution_>> variableDescriptorList = entityDescriptor.getGenuineVariableDescriptorList().stream().filter(GenuineVariableDescriptor::isListVariable).map(variableDescriptor -> (ListVariableDescriptor)variableDescriptor).collect(Collectors.toList());
        if (variableDescriptorList.isEmpty()) {
            throw new IllegalArgumentException("The listSwapMoveSelector (" + this.config + ") cannot unfold because there are no planning list variables for the only entity (" + entityDescriptor + ") or no planning list variables at all.");
        }
        return this.buildUnfoldedMoveSelectorConfig(variableDescriptorList);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(List<ListVariableDescriptor<Solution_>> variableDescriptorList) {
        ArrayList<MoveSelectorConfig> moveSelectorConfigList = new ArrayList<MoveSelectorConfig>(variableDescriptorList.size());
        for (ListVariableDescriptor<Solution_> variableDescriptor : variableDescriptorList) {
            ListSwapMoveSelectorConfig childMoveSelectorConfig = new ListSwapMoveSelectorConfig();
            ValueSelectorConfig childValueSelectorConfig = new ValueSelectorConfig(((ListSwapMoveSelectorConfig)this.config).getValueSelectorConfig());
            if (childValueSelectorConfig.getMimicSelectorRef() == null) {
                childValueSelectorConfig.setVariableName(variableDescriptor.getVariableName());
            }
            childMoveSelectorConfig.setValueSelectorConfig(childValueSelectorConfig);
            if (((ListSwapMoveSelectorConfig)this.config).getSecondaryValueSelectorConfig() != null) {
                ValueSelectorConfig childSecondaryValueSelectorConfig = new ValueSelectorConfig(((ListSwapMoveSelectorConfig)this.config).getSecondaryValueSelectorConfig());
                if (childSecondaryValueSelectorConfig.getMimicSelectorRef() == null) {
                    childSecondaryValueSelectorConfig.setVariableName(variableDescriptor.getVariableName());
                }
                childMoveSelectorConfig.setSecondaryValueSelectorConfig(childSecondaryValueSelectorConfig);
            }
            moveSelectorConfigList.add(childMoveSelectorConfig);
        }
        MoveSelectorConfig unfoldedMoveSelectorConfig = moveSelectorConfigList.size() == 1 ? (MoveSelectorConfig)moveSelectorConfigList.get(0) : new UnionMoveSelectorConfig(moveSelectorConfigList);
        unfoldedMoveSelectorConfig.inheritFolded((MoveSelectorConfig)this.config);
        return unfoldedMoveSelectorConfig;
    }
}

