/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value;

import java.util.Iterator;
import java.util.Objects;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;

public final class FromEntityPropertyValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements ValueSelector<Solution_> {
    private final ValueRangeDescriptor<Solution_> valueRangeDescriptor;
    private final boolean randomSelection;
    private Solution_ workingSolution;

    public FromEntityPropertyValueSelector(ValueRangeDescriptor<Solution_> valueRangeDescriptor, boolean randomSelection) {
        this.valueRangeDescriptor = valueRangeDescriptor;
        this.randomSelection = randomSelection;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.valueRangeDescriptor.getVariableDescriptor();
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.workingSolution = phaseScope.getWorkingSolution();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.workingSolution = null;
    }

    @Override
    public boolean isCountable() {
        return this.valueRangeDescriptor.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || !this.isCountable();
    }

    @Override
    public long getSize(Object entity) {
        ValueRange<?> valueRange = this.valueRangeDescriptor.extractValueRange(this.workingSolution, entity);
        return ((CountableValueRange)valueRange).getSize();
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        ValueRange<?> valueRange = this.valueRangeDescriptor.extractValueRange(this.workingSolution, entity);
        if (!this.randomSelection) {
            return ((CountableValueRange)valueRange).createOriginalIterator();
        }
        return valueRange.createRandomIterator(this.workingRandom);
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        ValueRange<?> valueRange = this.valueRangeDescriptor.extractValueRange(this.workingSolution, entity);
        return ((CountableValueRange)valueRange).createOriginalIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FromEntityPropertyValueSelector that = (FromEntityPropertyValueSelector)o;
        return this.randomSelection == that.randomSelection && Objects.equals(this.valueRangeDescriptor, that.valueRangeDescriptor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.valueRangeDescriptor, this.randomSelection);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getVariableDescriptor().getVariableName() + ")";
    }
}

