/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.nearby;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;

final class ValueNearbyDistanceMatrixDemand<Solution_, Origin_, Destination_>
extends AbstractNearbyDistanceMatrixDemand<Origin_, Destination_, ValueSelector<Solution_>, EntitySelector<Solution_>> {
    private final ToIntFunction<Origin_> destinationSizeFunction;

    public ValueNearbyDistanceMatrixDemand(NearbyDistanceMeter<Origin_, Destination_> meter, NearbyRandom random, ValueSelector<Solution_> childSelector, EntitySelector<Solution_> replayingOriginEntitySelector, ToIntFunction<Origin_> destinationSizeFunction) {
        super(meter, random, childSelector, replayingOriginEntitySelector);
        this.destinationSizeFunction = destinationSizeFunction;
    }

    @Override
    protected NearbyDistanceMatrix<Origin_, Destination_> supplyNearbyDistanceMatrix() {
        long originSize = ((EntitySelector)this.replayingSelector).getSize();
        if (originSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The originEntitySelector (" + this.replayingSelector + ") has an entitySize (" + originSize + ") which is higher than Integer.MAX_VALUE.");
        }
        Function<Object, Iterator> destinationIteratorProvider = origin -> ((ValueSelector)this.childSelector).endingIterator(origin);
        NearbyDistanceMatrix nearbyDistanceMatrix = new NearbyDistanceMatrix(this.meter, (int)originSize, destinationIteratorProvider, this.destinationSizeFunction);
        ((EntitySelector)this.replayingSelector).endingIterator().forEachRemaining(origin -> nearbyDistanceMatrix.addAllDestinations(origin));
        return nearbyDistanceMatrix;
    }
}

