/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands.jaxb;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.drools.commands.jaxb.JaxbStringObjectPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbMapAdapter
extends XmlAdapter<JaxbStringObjectPair[], Map<String, ? extends Object>> {
    protected static Logger logger = LoggerFactory.getLogger(JaxbMapAdapter.class);

    public JaxbStringObjectPair[] marshal(Map<String, ? extends Object> map) throws Exception {
        try {
            if (map == null || map.isEmpty()) {
                return new JaxbStringObjectPair[0];
            }
            ArrayList<JaxbStringObjectPair> ret = new ArrayList<JaxbStringObjectPair>(map.size());
            for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
                Object obj = entry.getValue();
                ret.add(new JaxbStringObjectPair(entry.getKey(), obj));
            }
            return ret.toArray(new JaxbStringObjectPair[map.size()]);
        }
        catch (Exception e) {
            logger.error("Unable to marshall " + map.getClass().getName() + " instance: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Map<String, Object> unmarshal(JaxbStringObjectPair[] value) throws Exception {
        try {
            LinkedHashMap<String, Object> r = new LinkedHashMap<String, Object>();
            for (JaxbStringObjectPair p : value) {
                r.put(p.getKey(), p.getValue());
            }
            return r;
        }
        catch (Exception e) {
            logger.error("Unable to *un*marshal " + value.getClass().getName() + " instance: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

