/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.swingui.components.Labeled;

@JsonIdentityInfo(scope=CloudComputer.class, generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
public class CloudComputer
extends AbstractPersistable
implements Labeled {
    private int cpuPower;
    private int memory;
    private int networkBandwidth;
    private int cost;

    CloudComputer() {
    }

    public CloudComputer(long id, int cpuPower, int memory, int networkBandwidth, int cost) {
        super(id);
        this.cpuPower = cpuPower;
        this.memory = memory;
        this.networkBandwidth = networkBandwidth;
        this.cost = cost;
    }

    public int getCpuPower() {
        return this.cpuPower;
    }

    public void setCpuPower(int cpuPower) {
        this.cpuPower = cpuPower;
    }

    public int getMemory() {
        return this.memory;
    }

    public void setMemory(int memory) {
        this.memory = memory;
    }

    public int getNetworkBandwidth() {
        return this.networkBandwidth;
    }

    public void setNetworkBandwidth(int networkBandwidth) {
        this.networkBandwidth = networkBandwidth;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    @JsonIgnore
    public int getMultiplicand() {
        return this.cpuPower * this.memory * this.networkBandwidth;
    }

    @Override
    @JsonIgnore
    public String getLabel() {
        return "Computer " + this.id;
    }
}

