/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.optaplanner.examples.common.util.Pair;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceConstraintConfiguration;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.TalkType;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;
import org.optaplanner.examples.conferencescheduling.persistence.ConnectionFollowRedirects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConferenceSchedulingCfpDevoxxImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConferenceSchedulingCfpDevoxxImporter.class);
    private static final String ZONE_ID = "Europe/Paris";
    private static final String[] SMALL_ROOMS_TYPE_NAMES = new String[]{"lab", "Hands-on Labs", "bof", "BOF (Bird of a Feather)", "ignite", "Ignite Sessions"};
    private static final String[] LARGE_ROOMS_TYPE_NAMES = new String[]{"tia", "Tools-in-Action", "uni", "University", "conf", "Conference", "Deep Dive", "key", "Keynote", "Quickie", "quick"};
    private static final String[] IGNORED_TALK_TYPES = new String[]{"ignite", "key"};
    private static final String[] IGNORED_ROOM_IDS = new String[]{"ExhibitionHall"};
    private static final String[] IGNORED_SPEAKER_NAMES = new String[]{"Devoxx Partner"};
    private String conferenceBaseUrl;
    private Map<String, TalkType> talkTypeIdToTalkTypeMap;
    private Map<String, Room> roomIdToRoomMap;
    private Map<String, Speaker> speakerNameToSpeakerMap;
    private Map<String, Talk> talkCodeToTalkMap;
    private Set<String> trackIdSet;
    private ConferenceSolution solution;
    private Map<String, Integer> timeslotTalkTypeToTotalMap = new HashMap<String, Integer>();
    private Map<String, Integer> talkTalkTypeToTotalMap = new HashMap<String, Integer>();

    public ConferenceSchedulingCfpDevoxxImporter(String conferenceBaseUrl) {
        this.conferenceBaseUrl = conferenceBaseUrl;
    }

    public ConferenceSolution importSolution() {
        this.solution = new ConferenceSolution(0L);
        this.solution.setConferenceName(this.getConferenceName());
        ConferenceConstraintConfiguration constraintConfiguration = new ConferenceConstraintConfiguration(0L);
        this.solution.setConstraintConfiguration(constraintConfiguration);
        this.importTalkTypeList();
        this.importTrackIdSet();
        this.importRoomList();
        this.importSpeakerList();
        this.importTalkList();
        this.importTimeslotList();
        for (TalkType talkType : this.solution.getTalkTypeList()) {
            LOGGER.info("{}: Timeslots Total is {}, Talks Total is {}.", new Object[]{talkType.getName(), this.timeslotTalkTypeToTotalMap.get(talkType.getName()) == null ? 0 : this.timeslotTalkTypeToTotalMap.get(talkType.getName()), this.talkTalkTypeToTotalMap.get(talkType.getName()) == null ? 0 : this.talkTalkTypeToTotalMap.get(talkType.getName())});
        }
        return this.solution;
    }

    private String getConferenceName() {
        LOGGER.debug("Sending a request to: {}", (Object)this.conferenceBaseUrl);
        JsonObject conferenceObject = this.readJson(this.conferenceBaseUrl, JsonReader::readObject);
        return conferenceObject.getString("eventCode");
    }

    private void importTalkTypeList() {
        this.talkTypeIdToTalkTypeMap = new HashMap<String, TalkType>();
        ArrayList<TalkType> talkTypeList = new ArrayList<TalkType>();
        String proposalTypeUrl = this.conferenceBaseUrl + "/proposalTypes";
        LOGGER.debug("Sending a request to: {}", (Object)proposalTypeUrl);
        JsonObject rootObject = this.readJson(proposalTypeUrl, JsonReader::readObject);
        JsonArray talkTypeArray = rootObject.getJsonArray("proposalTypes");
        for (int i = 0; i < talkTypeArray.size(); ++i) {
            JsonObject talkTypeObject = talkTypeArray.getJsonObject(i);
            String talkTypeId = talkTypeObject.getString("id");
            if (this.talkTypeIdToTalkTypeMap.keySet().contains(talkTypeId)) {
                LOGGER.warn("Duplicate talk type in {} at index {}.", (Object)proposalTypeUrl, (Object)i);
                continue;
            }
            TalkType talkType = new TalkType(i, talkTypeId);
            talkType.setCompatibleRoomSet(new HashSet<Room>());
            talkType.setCompatibleTimeslotSet(new HashSet<Timeslot>());
            talkTypeList.add(talkType);
            this.talkTypeIdToTalkTypeMap.put(talkTypeId, talkType);
        }
        this.solution.setTalkTypeList(talkTypeList);
    }

    private void importTrackIdSet() {
        this.trackIdSet = new HashSet<String>();
        String tracksUrl = this.conferenceBaseUrl + "/tracks";
        LOGGER.debug("Sending a request to: {}", (Object)tracksUrl);
        JsonObject rootObject = this.readJson(tracksUrl, JsonReader::readObject);
        JsonArray tracksArray = rootObject.getJsonArray("tracks");
        for (int i = 0; i < tracksArray.size(); ++i) {
            this.trackIdSet.add(tracksArray.getJsonObject(i).getString("id"));
        }
    }

    private void importRoomList() {
        this.roomIdToRoomMap = new HashMap<String, Room>();
        ArrayList<Room> roomList = new ArrayList<Room>();
        String roomsUrl = this.conferenceBaseUrl + "/rooms/";
        LOGGER.debug("Sending a request to: {}", (Object)roomsUrl);
        JsonObject rootObject = this.readJson(roomsUrl, JsonReader::readObject);
        JsonArray roomArray = rootObject.getJsonArray("rooms");
        for (int i = 0; i < roomArray.size(); ++i) {
            JsonObject roomObject = roomArray.getJsonObject(i);
            String id = roomObject.getString("id");
            int capacity = roomObject.getInt("capacity");
            if (Arrays.asList(IGNORED_ROOM_IDS).contains(id)) continue;
            Room room = new Room(i);
            room.setName(id);
            room.setCapacity(capacity);
            room.setTalkTypeSet(this.getTalkTypeSetForCapacity(capacity));
            for (TalkType talkType : room.getTalkTypeSet()) {
                talkType.getCompatibleRoomSet().add(room);
            }
            room.setTagSet(new HashSet<String>());
            room.setUnavailableTimeslotSet(new HashSet<Timeslot>());
            roomList.add(room);
            this.roomIdToRoomMap.put(id, room);
        }
        if (roomList.isEmpty()) {
            LOGGER.warn("There are no rooms. Log into the CFP webapp, open the tab configuration and add the rooms before importing it here.");
        }
        roomList.sort(Comparator.comparing(Room::getName));
        this.solution.setRoomList(roomList);
    }

    private void importSpeakerList() {
        this.speakerNameToSpeakerMap = new HashMap<String, Speaker>();
        ArrayList<Speaker> speakerList = new ArrayList<Speaker>();
        String speakersUrl = this.conferenceBaseUrl + "/speakers";
        LOGGER.debug("Sending a request to: {}", (Object)speakersUrl);
        JsonArray speakerArray = this.readJson(speakersUrl, JsonReader::readArray);
        for (int i = 0; i < speakerArray.size(); ++i) {
            String speakerUrl = speakerArray.getJsonObject(i).getJsonArray("links").getJsonObject(0).getString("href");
            LOGGER.debug("Sending a request to: {}", (Object)speakerUrl);
            JsonObject speakerObject = this.readJson(speakerUrl, JsonReader::readObject);
            String speakerId = speakerObject.getString("uuid");
            String speakerName = speakerObject.getString("firstName") + " " + speakerObject.getString("lastName");
            if (Arrays.asList(IGNORED_SPEAKER_NAMES).contains(speakerName)) continue;
            Speaker speaker = new Speaker(i);
            speaker.setName(speakerName);
            speaker.withPreferredRoomTagSet(new HashSet<String>()).withPreferredTimeslotTagSet(new HashSet<String>()).withProhibitedRoomTagSet(new HashSet<String>()).withProhibitedTimeslotTagSet(new HashSet<String>()).withRequiredRoomTagSet(new HashSet<String>()).withRequiredTimeslotTagSet(new HashSet<String>()).withUnavailableTimeslotSet(new HashSet<Timeslot>()).withUndesiredRoomTagSet(new HashSet<String>()).withUndesiredTimeslotTagSet(new HashSet<String>());
            speakerList.add(speaker);
            if (this.speakerNameToSpeakerMap.keySet().contains(speakerName)) {
                throw new IllegalStateException("Speaker (" + speakerName + ") with id (" + speakerId + ") already exists in the speaker list");
            }
            this.speakerNameToSpeakerMap.put(speakerName, speaker);
        }
        speakerList.sort(Comparator.comparing(Speaker::getName));
        this.solution.setSpeakerList(speakerList);
    }

    private void importTalkList() {
        this.talkCodeToTalkMap = new HashMap<String, Talk>();
        this.solution.setTalkList(new ArrayList<Talk>());
        String talksUrl = this.conferenceBaseUrl + "/talks";
        LOGGER.debug("Sending a request to: {}", (Object)talksUrl);
        for (JsonValue talksValue : this.readJson(talksUrl, JsonReader::readObject).getJsonObject("talks").values()) {
            JsonArray talkArray = (JsonArray)talksValue;
            for (int i = 0; i < talkArray.size(); ++i) {
                JsonObject talkObject = talkArray.getJsonObject(i);
                String code = talkObject.getString("id");
                String title = talkObject.getString("title");
                String talkTypeId = talkObject.getJsonObject("talkType").getString("id");
                Set<String> themeTrackSet = this.extractThemeTrackSet(talkObject, code, title);
                String language = talkObject.getString("lang");
                String audienceLevelAsString = talkObject.getString("audienceLevel").replaceAll("[^0-9]", "");
                int audienceLevel = Integer.parseInt(audienceLevelAsString.isEmpty() ? "1" : audienceLevelAsString);
                List<Speaker> speakerList = this.extractSpeakerList(talkObject, code, title);
                Set<String> contentTagSet = this.extractContentTagSet(talkObject);
                if (Arrays.asList(IGNORED_TALK_TYPES).contains(talkTypeId)) continue;
                this.createTalk(code, title, talkTypeId, themeTrackSet, language, speakerList, audienceLevel, contentTagSet);
            }
        }
    }

    private Set<String> extractThemeTrackSet(JsonObject talkObject, String code, String title) {
        HashSet<String> themeTrackSet = new HashSet<String>(Arrays.asList(talkObject.getJsonObject("track").getString("id")));
        if (!this.trackIdSet.containsAll(themeTrackSet)) {
            throw new IllegalStateException("The talk (" + title + ") with id (" + code + ") contains trackId (" + themeTrackSet + ") that doesn't exist in the trackIdSet.");
        }
        return themeTrackSet;
    }

    private List<Speaker> extractSpeakerList(JsonObject talkObject, String code, String title) {
        ArrayList<Speaker> speakerList = new ArrayList<Speaker>();
        String mainSpeakerName = talkObject.getString("mainSpeaker");
        if (Arrays.asList(IGNORED_SPEAKER_NAMES).contains(mainSpeakerName)) {
            return speakerList;
        }
        speakerList.add(this.getSpeakerOrCreateOneIfNull(code, title, mainSpeakerName));
        if (talkObject.containsKey((Object)"secondarySpeaker")) {
            String secondarySpeakerName = talkObject.getString("secondarySpeaker");
            speakerList.add(this.getSpeakerOrCreateOneIfNull(code, title, secondarySpeakerName));
        }
        if (talkObject.containsKey((Object)"otherSpeakers")) {
            JsonArray otherSpeakersArray = talkObject.getJsonArray("otherSpeakers");
            for (JsonValue otherSpeakerName : otherSpeakersArray) {
                speakerList.add(this.getSpeakerOrCreateOneIfNull(code, title, otherSpeakerName.toString().replaceAll("\"", "")));
            }
        }
        return speakerList;
    }

    private Speaker getSpeakerOrCreateOneIfNull(String code, String title, String speakerName) {
        Speaker speaker = this.speakerNameToSpeakerMap.get(speakerName);
        if (speaker == null) {
            LOGGER.warn("The talk ({}: {}) has a speaker ({}) that doesn't exist in speaker list.", new Object[]{code, title, speakerName});
            speaker = new Speaker(this.solution.getSpeakerList().size());
            speaker.setName(speakerName);
            speaker.withPreferredRoomTagSet(new HashSet<String>()).withPreferredTimeslotTagSet(new HashSet<String>()).withProhibitedRoomTagSet(new HashSet<String>()).withProhibitedTimeslotTagSet(new HashSet<String>()).withRequiredRoomTagSet(new HashSet<String>()).withRequiredTimeslotTagSet(new HashSet<String>()).withUnavailableTimeslotSet(new HashSet<Timeslot>()).withUndesiredRoomTagSet(new HashSet<String>()).withUndesiredTimeslotTagSet(new HashSet<String>());
            if (this.speakerNameToSpeakerMap.keySet().contains(speakerName)) {
                throw new IllegalStateException("Speaker (" + speakerName + ") already exists in the speaker list");
            }
            this.speakerNameToSpeakerMap.put(speakerName, speaker);
            this.solution.getSpeakerList().add(speaker);
        }
        return speaker;
    }

    private Set<String> extractContentTagSet(JsonObject talkObject) {
        if (talkObject.containsKey((Object)"tags")) {
            return talkObject.getJsonArray("tags").stream().map(JsonObject.class::cast).filter(tagObject -> !tagObject.getString("value").isEmpty()).map(tagObject -> tagObject.getString("value")).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private void createTalk(String code, String title, String talkTypeId, Set<String> themeTrackSet, String languageg, List<Speaker> speakerList, int audienceLevel, Set<String> contentTagSet) {
        Talk talk = new Talk(this.solution.getTalkList().size());
        talk.setCode(code);
        talk.setTitle(title);
        if (this.talkTypeIdToTalkTypeMap.get(talkTypeId) == null) {
            throw new IllegalStateException("The talk (" + title + ") with id (" + code + ") has a talkType (" + talkTypeId + ") that doesn't exist in the talkType list.");
        }
        talk.setTalkType(this.talkTypeIdToTalkTypeMap.get(talkTypeId));
        talk.withSpeakerList(speakerList).withThemeTrackTagSet(themeTrackSet).withSectorTagSet(new HashSet<String>()).withLanguage(languageg).withAudienceTypeSet(new HashSet<String>()).withAudienceLevel(audienceLevel).withContentTagSet(contentTagSet).withRequiredTimeslotTagSet(new HashSet<String>()).withPreferredTimeslotTagSet(new HashSet<String>()).withProhibitedTimeslotTagSet(new HashSet<String>()).withUndesiredTimeslotTagSet(new HashSet<String>()).withRequiredRoomTagSet(new HashSet<String>()).withPreferredRoomTagSet(new HashSet<String>()).withProhibitedRoomTagSet(new HashSet<String>()).withUndesiredRoomTagSet(new HashSet<String>()).withMutuallyExclusiveTalksTagSet(new HashSet<String>()).withPrerequisiteTalksCodesSet(new HashSet<Talk>());
        this.talkCodeToTalkMap.put(talk.getCode(), talk);
        this.solution.getTalkList().add(talk);
        this.talkTalkTypeToTotalMap.merge(talk.getTalkType().getName(), 1, Integer::sum);
    }

    private void importTimeslotList() {
        ArrayList<Timeslot> timeslotList = new ArrayList<Timeslot>();
        HashMap<Timeslot, ArrayList<Room>> timeslotToAvailableRoomsMap = new HashMap<Timeslot, ArrayList<Room>>();
        HashMap<Pair<LocalDateTime, LocalDateTime>, Timeslot> startAndEndTimeToTimeslotMap = new HashMap<Pair<LocalDateTime, LocalDateTime>, Timeslot>();
        this.talkTypeIdToTalkTypeMap.put("unknown", this.talkTypeIdToTalkTypeMap.get("key"));
        Long timeslotId = 0L;
        String slotsUrl = this.conferenceBaseUrl + "/slots";
        JsonArray slotsArray = this.readJson(slotsUrl, JsonReader::readObject).getJsonArray("slots");
        for (int i = 0; i < slotsArray.size(); ++i) {
            JsonObject timeslotObject = slotsArray.getJsonObject(i);
            if (Arrays.asList(IGNORED_ROOM_IDS).contains(timeslotObject.getString("room"))) continue;
            LocalDateTime startDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timeslotObject.getJsonNumber("from").longValue()), ZoneId.of(ZONE_ID));
            LocalDateTime endDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timeslotObject.getJsonNumber("to").longValue()), ZoneId.of(ZONE_ID));
            Room room = this.extractRoom(timeslotObject, "id", "room");
            String talkTypeId = timeslotObject.getString("id").split("_")[0];
            if (Arrays.asList(IGNORED_TALK_TYPES).contains(talkTypeId)) continue;
            TalkType timeslotTalkType = this.talkTypeIdToTalkTypeMap.get(talkTypeId);
            Timeslot timeslot2 = (Timeslot)startAndEndTimeToTimeslotMap.get(Pair.of(startDateTime, endDateTime));
            if (timeslot2 != null) {
                ((List)timeslotToAvailableRoomsMap.get(timeslot2)).add(room);
                if (timeslotTalkType != null) {
                    timeslot2.getTalkTypeSet().add(timeslotTalkType);
                }
            } else {
                Long l = timeslotId;
                timeslotId = timeslotId + 1L;
                timeslot2 = new Timeslot(l);
                timeslot2.withStartDateTime(startDateTime).withEndDateTime(endDateTime).withTalkTypeSet(timeslotTalkType == null ? new HashSet<TalkType>() : new HashSet<TalkType>(Arrays.asList(timeslotTalkType)));
                timeslot2.setTagSet(new HashSet<String>());
                timeslotList.add(timeslot2);
                timeslotToAvailableRoomsMap.put(timeslot2, new ArrayList<Room>(Arrays.asList(room)));
                startAndEndTimeToTimeslotMap.put(Pair.of(startDateTime, endDateTime), timeslot2);
            }
            for (TalkType talkType : timeslot2.getTalkTypeSet()) {
                talkType.getCompatibleTimeslotSet().add(timeslot2);
            }
            this.timeslotTalkTypeToTotalMap.merge(talkTypeId, 1, Integer::sum);
        }
        String schedulesUrl = this.conferenceBaseUrl + "/schedules/";
        LOGGER.debug("Sending a request to: {}", (Object)schedulesUrl);
        JsonArray daysArray = this.readJson(schedulesUrl, JsonReader::readObject).getJsonArray("links");
        for (int i = 0; i < daysArray.size(); ++i) {
            JsonObject dayObject = daysArray.getJsonObject(i);
            String dayUrl = dayObject.getString("href");
            LOGGER.debug("Sending a request to: {}", (Object)dayUrl);
            JsonArray daySlotsArray = this.readJson(dayUrl, JsonReader::readObject).getJsonArray("slots");
            for (int j = 0; j < daySlotsArray.size(); ++j) {
                LocalDateTime endDateTime;
                JsonObject timeslotObject = daySlotsArray.getJsonObject(j);
                if (Arrays.asList(IGNORED_ROOM_IDS).contains(timeslotObject.getString("roomId")) || Arrays.asList(IGNORED_TALK_TYPES).contains(timeslotObject.getString("slotId").split("_")[0])) continue;
                LocalDateTime startDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timeslotObject.getJsonNumber("fromTimeMillis").longValue()), ZoneId.of(ZONE_ID));
                Timeslot timeslot3 = (Timeslot)startAndEndTimeToTimeslotMap.get(Pair.of(startDateTime, endDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timeslotObject.getJsonNumber("toTimeMillis").longValue()), ZoneId.of(ZONE_ID))));
                if (timeslot3 == null) {
                    throw new IllegalStateException("Timeslot (" + timeslotObject.getString("slotId") + ") in + (" + dayUrl + ") does not exist in /slots endpoint.");
                }
                Room room = this.extractRoom(timeslotObject, "slotId", "roomId");
                if (!timeslotObject.containsKey((Object)"talk") || timeslotObject.isNull("talk")) continue;
                this.scheduleTalk(timeslotObject, room, timeslot3);
            }
        }
        if (timeslotList.isEmpty()) {
            LOGGER.warn("There are no timeslots. Log into the CFP webapp, open the tab configuration and add the timeslots before importing it here.");
        }
        for (Room room : this.solution.getRoomList()) {
            room.setUnavailableTimeslotSet(timeslotList.stream().filter(timeslot -> !((List)timeslotToAvailableRoomsMap.get(timeslot)).contains(room)).collect(Collectors.toSet()));
        }
        timeslotList.sort(Comparator.comparing(Timeslot::getStartDateTime));
        this.solution.setTimeslotList(timeslotList);
    }

    private Room extractRoom(JsonObject timeslotObject, String slotId, String roomId) {
        Room room = this.roomIdToRoomMap.get(timeslotObject.getString(roomId));
        if (room == null) {
            throw new IllegalStateException("The timeslot (" + timeslotObject.getString(slotId) + ") has a roomId (" + timeslotObject.getString(roomId) + ") that does not exist in the rooms list");
        }
        return room;
    }

    private Set<TalkType> getTalkTypeSetForCapacity(int capacity) {
        HashSet<TalkType> talkTypeSet = new HashSet<TalkType>();
        ArrayList typeNames = new ArrayList();
        if (capacity < 100) {
            typeNames.addAll(Arrays.asList(SMALL_ROOMS_TYPE_NAMES).stream().filter(typeName -> this.solution.getTalkTypeList().contains(this.talkTypeIdToTalkTypeMap.get(typeName))).collect(Collectors.toSet()));
        } else {
            typeNames.addAll(Arrays.asList(LARGE_ROOMS_TYPE_NAMES).stream().filter(typeName -> this.solution.getTalkTypeList().contains(this.talkTypeIdToTalkTypeMap.get(typeName))).collect(Collectors.toSet()));
        }
        for (String talkTypeName : typeNames) {
            TalkType talkType = this.talkTypeIdToTalkTypeMap.get(talkTypeName);
            if (talkType == null) continue;
            talkTypeSet.add(talkType);
        }
        return talkTypeSet;
    }

    private void scheduleTalk(JsonObject timeslotObject, Room room, Timeslot timeslot) {
        Talk talk = this.talkCodeToTalkMap.get(timeslotObject.getJsonObject("talk").getString("id"));
        if (talk == null) {
            throw new IllegalStateException("The timeslot (" + timeslotObject.getString("slotId") + ") has a talk (" + timeslotObject.getJsonObject("talk").getString("id") + ") that does not exist in the talk list");
        }
        if (talk.isPinnedByUser()) {
            throw new IllegalStateException("The timeslot (" + timeslotObject.getString("slotId") + ") has a talk (" + timeslotObject.getJsonObject("talk").getString("id") + ") that is already pinned by user at another timeslot (" + talk.getTimeslot().toString() + ").");
        }
        talk.setRoom(room);
        talk.setTimeslot(timeslot);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R readJson(String url, Function<JsonReader, R> mapper) {
        try (InputStream inputStream = new ConnectionFollowRedirects(url).getInputStream();){
            JsonReader jsonReader = Json.createReader((InputStream)inputStream);
            R r = mapper.apply(jsonReader);
            return r;
        }
        catch (IOException e) {
            throw new IllegalStateException("Import failed on URL (" + url + ").", e);
        }
    }
}

