/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.io.FileSystemItem;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBaseUpdaterOptions;
import org.drools.compiler.kie.builder.impl.KieBaseUpdaters;
import org.drools.compiler.kie.builder.impl.KieBaseUpdatersContext;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.io.InternalResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.util.PortablePath;
import org.drools.wiring.api.ResourceProvider;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.Option;
import org.kie.api.internal.utils.KieService;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.conf.AlphaNetworkCompilerOption;
import org.kie.memorycompiler.resources.ResourceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryKieModule
extends AbstractKieModule
implements ResourceReader,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MemoryKieModule.class);
    private static final String MEMORY_URL_PROTOCOL = "mfs";
    private MemoryFileSystem mfs;
    private final long creationTimestamp = System.currentTimeMillis();

    public MemoryKieModule() {
    }

    public MemoryKieModule(ReleaseId releaseId) {
        this(releaseId, new KieModuleModelImpl(), new MemoryFileSystem());
    }

    public MemoryKieModule(ReleaseId releaseId, KieModuleModel kModuleModel, MemoryFileSystem mfs) {
        super(releaseId, kModuleModel);
        this.mfs = mfs;
    }

    @Override
    public boolean isAvailable(String path) {
        return this.isAvailable(PortablePath.of((String)path));
    }

    public boolean isAvailable(PortablePath path) {
        return this.mfs.existsFile(path);
    }

    @Override
    public byte[] getBytes(String path) {
        return this.mfs.getBytes(path);
    }

    @Override
    public byte[] getBytes(PortablePath path) {
        return this.mfs.getBytes(path);
    }

    @Override
    public InternalResource getResource(String fileName) {
        return this.getResource(PortablePath.of((String)fileName));
    }

    public InternalResource getResource(PortablePath path) {
        return this.mfs.getResource(path);
    }

    public Collection<PortablePath> getFilePaths() {
        return this.mfs.getFilePaths();
    }

    @Override
    public Collection<String> getFileNames() {
        return this.getFilePaths().stream().map(PortablePath::asString).collect(Collectors.toList());
    }

    public MemoryFileSystem getMemoryFileSystem() {
        return this.mfs;
    }

    public void mark() {
        this.mfs.mark();
    }

    public Collection<String> getModifiedResourcesSinceLastMark() {
        return this.mfs.getModifiedResourcesSinceLastMark();
    }

    @Override
    public File getFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes() {
        return this.mfs.writeAsBytes();
    }

    @Override
    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public void afterKieBaseCreationUpdate(String kBaseName, InternalKnowledgeBase kBase) {
        KnowledgeBuilder knowledgeBuilderForKieBase = this.getKnowledgeBuilderForKieBase(kBaseName);
        if (knowledgeBuilderForKieBase instanceof KnowledgeBuilderImpl) {
            KnowledgeBuilderImpl knowledgeBuilderForImpl = (KnowledgeBuilderImpl)knowledgeBuilderForKieBase;
            KnowledgeBuilderConfigurationImpl builderConfiguration = knowledgeBuilderForImpl.getBuilderConfiguration();
            KieContainerImpl.CompositeRunnable compositeUpdater = new KieContainerImpl.CompositeRunnable();
            KieBaseUpdaterOptions kieBaseUpdaterOptions = new KieBaseUpdaterOptions(new KieBaseUpdaterOptions.OptionEntry((Class<? extends Option>)AlphaNetworkCompilerOption.class, (Option)builderConfiguration.getOption(AlphaNetworkCompilerOption.KEY)));
            KieBaseUpdaters updaters = (KieBaseUpdaters)KieService.load(KieBaseUpdaters.class);
            updaters.getChildren().stream().map(kbu -> kbu.create(new KieBaseUpdatersContext(kieBaseUpdaterOptions, kBase.getRete(), kBase.getRootClassLoader()))).forEach(compositeUpdater::add);
            kBase.enqueueModification((Runnable)compositeUpdater);
        }
    }

    public String toString() {
        return "MemoryKieModule[releaseId=" + this.getReleaseId() + "]";
    }

    @Override
    public MemoryKieModule cloneForIncrementalCompilation(ReleaseId releaseId, KieModuleModel kModuleModel, MemoryFileSystem newFs) {
        MemoryKieModule clone = new MemoryKieModule(releaseId, kModuleModel, newFs);
        for (InternalKieModule dep : this.getKieDependencies().values()) {
            clone.addKieDependency(dep);
        }
        for (KieBaseModel kBaseModel : this.getKieModuleModel().getKieBaseModels().values()) {
            clone.cacheKnowledgeBuilderForKieBase(kBaseModel.getName(), this.getKnowledgeBuilderForKieBase(kBaseModel.getName()));
        }
        clone.setPomModel(this.getPomModel());
        for (InternalKieModule dependency : this.getKieDependencies().values()) {
            clone.addKieDependency(dependency);
        }
        clone.setUnresolvedDependencies(this.getUnresolvedDependencies());
        return clone;
    }

    @Override
    public ResourceProvider createResourceProvider() {
        return new MemoryKieModuleResourceProvider(this.mfs);
    }

    private static class FolderMembersInputStream
    extends InputStream {
        private final InputStream dataIs;

        public FolderMembersInputStream(Folder folder) {
            this.dataIs = this.folderMembersToInputStream(folder);
        }

        @Override
        public int read() throws IOException {
            return this.dataIs.read();
        }

        private InputStream folderMembersToInputStream(Folder folder) {
            StringBuilder sb = new StringBuilder();
            Collection<? extends FileSystemItem> members = folder.getMembers();
            if (members != null) {
                for (FileSystemItem fileSystemItem : members) {
                    sb.append(fileSystemItem.getPath().asString().substring(folder.getPath().asString().length() + 1));
                    sb.append("\n");
                }
            }
            return new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private static class MemoryFolderURLConnection
    extends URLConnection {
        private final Folder folder;

        public MemoryFolderURLConnection(URL url, Folder folder) {
            super(url);
            this.folder = folder;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FolderMembersInputStream(this.folder);
        }

        @Override
        public void connect() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class MemoryFileURLConnection
    extends URLConnection {
        private final org.drools.compiler.compiler.io.File file;

        public MemoryFileURLConnection(URL url, org.drools.compiler.compiler.io.File file) {
            super(url);
            this.file = file;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.file.getContents();
        }

        @Override
        public void connect() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class MemoryFolderURLStreamHandler
    extends URLStreamHandler {
        private final Folder folder;

        private MemoryFolderURLStreamHandler(Folder folder) {
            this.folder = folder;
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return MemoryKieModule.MEMORY_URL_PROTOCOL.equals(url.getProtocol()) ? new MemoryFolderURLConnection(url, this.folder) : url.openConnection();
        }
    }

    private static class MemoryFileURLStreamHandler
    extends URLStreamHandler {
        private final org.drools.compiler.compiler.io.File file;

        private MemoryFileURLStreamHandler(org.drools.compiler.compiler.io.File file) {
            this.file = file;
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return MemoryKieModule.MEMORY_URL_PROTOCOL.equals(url.getProtocol()) ? new MemoryFileURLConnection(url, this.file) : url.openConnection();
        }
    }

    private static class MemoryKieModuleResourceProvider
    implements ResourceProvider {
        private final MemoryFileSystem mfs;

        private MemoryKieModuleResourceProvider(MemoryFileSystem mfs) {
            this.mfs = mfs;
        }

        public URL getResource(String name) {
            PortablePath portablePath = PortablePath.of((String)name);
            try {
                if (this.mfs.existsFile(portablePath)) {
                    return new URL(MemoryKieModule.MEMORY_URL_PROTOCOL, null, -1, this.constructName(name), new MemoryFileURLStreamHandler(this.mfs.getFile(portablePath)));
                }
                if (this.mfs.existsFolder(portablePath)) {
                    return new URL(MemoryKieModule.MEMORY_URL_PROTOCOL, null, -1, this.constructName(name), new MemoryFolderURLStreamHandler(this.mfs.getFolder(portablePath)));
                }
                return null;
            }
            catch (MalformedURLException e) {
                logger.debug("Can't create URL for resource " + name, (Throwable)e);
                return null;
            }
        }

        private String constructName(String name) {
            if (name.startsWith("/")) {
                return name;
            }
            return "/" + name;
        }

        public InputStream getResourceAsStream(String name) throws IOException {
            PortablePath portablePath = PortablePath.of((String)name);
            if (this.mfs.existsFile(portablePath)) {
                return this.mfs.getFile(portablePath).getContents();
            }
            if (this.mfs.existsFolder(portablePath)) {
                return new FolderMembersInputStream(this.mfs.getFolder(portablePath));
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MemoryKieModuleResourceProvider)) {
                return false;
            }
            MemoryKieModuleResourceProvider that = (MemoryKieModuleResourceProvider)o;
            return this.mfs != null ? this.mfs.equals(that.mfs) : that.mfs == null;
        }

        public int hashCode() {
            return this.mfs != null ? this.mfs.hashCode() : 0;
        }
    }
}

