/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.decorator;

import java.util.List;
import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;

public final class CompositeSelectionFilter<Solution_, T>
implements SelectionFilter<Solution_, T> {
    private final List<SelectionFilter<Solution_, T>> selectionFilterList;

    public CompositeSelectionFilter(List<SelectionFilter<Solution_, T>> selectionFilterList) {
        this.selectionFilterList = selectionFilterList;
    }

    @Override
    public boolean accept(ScoreDirector<Solution_> scoreDirector, T selection) {
        for (SelectionFilter<Solution_, T> selectionFilter : this.selectionFilterList) {
            if (selectionFilter.accept(scoreDirector, selection)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CompositeSelectionFilter that = (CompositeSelectionFilter)other;
        return Objects.equals(this.selectionFilterList, that.selectionFilterList);
    }

    public int hashCode() {
        return Objects.hash(this.selectionFilterList);
    }
}

