/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.move.NoChangeMove;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptCycle;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptDescriptor;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptUtils;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.TwoOptListMove;

final class KOptListMoveIterator<Solution_, Node_>
extends UpcomingSelectionIterator<Move<Solution_>> {
    private final Random workingRandom;
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final SingletonInverseVariableSupply inverseVariableSupply;
    private final IndexVariableSupply indexVariableSupply;
    private final EntitySelector<Solution_> entitySelector;
    private final Function<Node_, Node_> successorFunction;
    private final Function<Node_, Node_> predecessorFunction;
    private final TriPredicate<Node_, Node_, Node_> betweenFunction;
    private final int minK;
    private final int maxK;
    private final int maxCyclesPatchedInInfeasibleMove;
    private Iterator<Node_> entityIterator;

    public KOptListMoveIterator(Random workingRandom, ListVariableDescriptor<Solution_> listVariableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, IndexVariableSupply indexVariableSupply, EntitySelector<Solution_> entitySelector, int minK, int maxK) {
        this.workingRandom = workingRandom;
        this.listVariableDescriptor = listVariableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.indexVariableSupply = indexVariableSupply;
        this.entitySelector = entitySelector;
        this.minK = minK;
        this.maxK = maxK;
        this.maxCyclesPatchedInInfeasibleMove = maxK;
        this.successorFunction = KOptUtils.getSuccessorFunction(listVariableDescriptor, inverseVariableSupply, indexVariableSupply);
        this.predecessorFunction = KOptUtils.getPredecessorFunction(listVariableDescriptor, inverseVariableSupply, indexVariableSupply);
        this.betweenFunction = KOptUtils.getBetweenPredicate(indexVariableSupply);
    }

    private Iterator<Node_> getValueIteratorForEntity(Object entity) {
        List<Object> entityListVariable = this.listVariableDescriptor.getListVariable(entity);
        return this.workingRandom.ints(0, entityListVariable.size()).mapToObj(entityListVariable::get).iterator();
    }

    @Override
    protected Move<Solution_> createUpcomingSelection() {
        int k = this.workingRandom.nextInt(this.maxK - this.minK + 1) + this.minK;
        Node_ entity = this.pickEntityWithMinimumRouteLength(2 * k);
        while (entity == null) {
            if (--k <= 1) {
                return new NoChangeMove();
            }
            entity = this.pickEntityWithMinimumRouteLength(2 * k);
        }
        if (k == 2) {
            Iterator<Node_> valueIterator = this.getValueIteratorForEntity(entity);
            Node_ firstEndpoint = valueIterator.next();
            Node_ secondEndpoint = valueIterator.next();
            while (secondEndpoint == firstEndpoint) {
                secondEndpoint = valueIterator.next();
            }
            return new TwoOptListMove<Solution_>(this.listVariableDescriptor, this.indexVariableSupply, entity, firstEndpoint, secondEndpoint);
        }
        KOptDescriptor<Solution_, Node_> descriptor = this.pickKOptMove(entity, k);
        if (descriptor == null) {
            return new NoChangeMove();
        }
        return descriptor.getKOptListMove(this.listVariableDescriptor, this.indexVariableSupply, entity);
    }

    private Node_ pickEntityWithMinimumRouteLength(int minimumLength) {
        if (this.entityIterator == null) {
            this.entityIterator = this.entitySelector.endingIterator();
        }
        for (int i = 0; i < 2; ++i) {
            while (this.entityIterator.hasNext()) {
                Node_ entity = this.entityIterator.next();
                if (this.listVariableDescriptor.getListSize(entity) < minimumLength) continue;
                return entity;
            }
            this.entityIterator = this.entitySelector.endingIterator();
        }
        return null;
    }

    private KOptDescriptor<Solution_, Node_> pickKOptMove(Node_ entity, int k) {
        Object[] pickedValues = new Object[2 * k + 1];
        Iterator<Node_> valueIterator = this.getValueIteratorForEntity(entity);
        pickedValues[1] = valueIterator.next();
        pickedValues[2] = this.workingRandom.nextBoolean() ? this.getNodePredecessor(pickedValues[1]) : this.getNodeSuccessor(pickedValues[1]);
        return this.pickKOptMoveRec(valueIterator, pickedValues, 2, k);
    }

    private KOptDescriptor<Solution_, Node_> pickKOptMoveRec(Iterator<Node_> valueIterator, Node_[] pickedValues, int pickedSoFar, int K) {
        Node_ previousRemovedEdgeEndpoint = pickedValues[2 * pickedSoFar - 2];
        for (int remainingAttempts = (K - pickedSoFar + 3) * 2; remainingAttempts > 0; --remainingAttempts) {
            KOptDescriptor<Solution_, Node_> descriptor;
            Node_ nextRemovedEdgePoint = valueIterator.next();
            while (nextRemovedEdgePoint == this.getNodePredecessor(previousRemovedEdgeEndpoint) || nextRemovedEdgePoint == this.getNodeSuccessor(previousRemovedEdgeEndpoint) || this.isEdgeAlreadyAdded(pickedValues, previousRemovedEdgeEndpoint, nextRemovedEdgePoint, pickedSoFar - 2) || this.isEdgeAlreadyDeleted(pickedValues, nextRemovedEdgePoint, this.getNodePredecessor(nextRemovedEdgePoint), pickedSoFar - 2) && this.isEdgeAlreadyDeleted(pickedValues, nextRemovedEdgePoint, this.getNodeSuccessor(nextRemovedEdgePoint), pickedSoFar - 2)) {
                if (remainingAttempts == 0) {
                    return null;
                }
                nextRemovedEdgePoint = valueIterator.next();
                --remainingAttempts;
            }
            pickedValues[2 * pickedSoFar - 1] = nextRemovedEdgePoint;
            Node_ nextRemovedEdgeOppositePoint = this.isEdgeAlreadyDeleted(pickedValues, nextRemovedEdgePoint, this.getNodePredecessor(nextRemovedEdgePoint), pickedSoFar - 2) ? this.getNodeSuccessor(nextRemovedEdgePoint) : (this.isEdgeAlreadyDeleted(pickedValues, nextRemovedEdgePoint, this.getNodeSuccessor(nextRemovedEdgePoint), pickedSoFar - 2) ? this.getNodePredecessor(nextRemovedEdgePoint) : (this.workingRandom.nextBoolean() ? this.getNodeSuccessor(nextRemovedEdgePoint) : this.getNodePredecessor(nextRemovedEdgePoint)));
            pickedValues[2 * pickedSoFar] = nextRemovedEdgeOppositePoint;
            if (pickedSoFar < K) {
                descriptor = this.pickKOptMoveRec(valueIterator, pickedValues, pickedSoFar + 1, K);
                if (descriptor == null || !descriptor.isFeasible()) continue;
                return descriptor;
            }
            descriptor = new KOptDescriptor(pickedValues, this.successorFunction, this.betweenFunction);
            if (!descriptor.isFeasible()) continue;
            return descriptor;
        }
        return null;
    }

    KOptDescriptor<Solution_, Node_> patchCycles(Iterator<Node_> valueIterator, KOptDescriptor<Solution_, Node_> descriptor, Node_[] oldRemovedEdges, int k) {
        int[] removedEdgeIndexToTourOrder = descriptor.getRemovedEdgeIndexToTourOrder();
        KOptCycle cycleInfo = KOptUtils.getCyclesForPermutation(descriptor);
        int cycleCount = cycleInfo.cycleCount;
        int[] cycle = cycleInfo.indexToCycleIdentifier;
        if (cycleCount == 1 || cycleCount > this.maxCyclesPatchedInInfeasibleMove) {
            return descriptor;
        }
        int currentCycle = this.getShortestCycleIdentifier(oldRemovedEdges, cycle, removedEdgeIndexToTourOrder, cycleCount, k);
        for (int i = 0; i < k; ++i) {
            if (cycle[removedEdgeIndexToTourOrder[2 * i]] != currentCycle) continue;
            Node_ sStart = oldRemovedEdges[removedEdgeIndexToTourOrder[2 * i]];
            Node_ sStop = oldRemovedEdges[removedEdgeIndexToTourOrder[2 * i + 1]];
            Node_ s1 = sStart;
            while (s1 != sStop) {
                Node_ s2;
                Node_[] removedEdges = Arrays.copyOf(oldRemovedEdges, oldRemovedEdges.length + 2);
                removedEdges[2 * k + 1] = s1;
                removedEdges[2 * k + 2] = s2 = this.getNodeSuccessor(s1);
                int[] addedEdgeToOtherEndpoint = new int[removedEdges.length];
                KOptDescriptor<Solution_, Node_> newMove = this.patchCyclesRec(valueIterator, descriptor, removedEdges, addedEdgeToOtherEndpoint, cycle, currentCycle, k, 2, cycleCount);
                if (newMove.isFeasible()) {
                    return newMove;
                }
                s1 = s2;
            }
        }
        return descriptor;
    }

    KOptDescriptor<Solution_, Node_> patchCyclesRec(Iterator<Node_> valueIterator, KOptDescriptor<Solution_, Node_> originalMove, Node_[] oldRemovedEdges, int[] addedEdgeToOtherEndpoint, int[] cycle, int currentCycle, int k, int patchedCycleCount, int cycleCount) {
        int NewCycle;
        Integer[] cycleSaved = new Integer[1 + 2 * k];
        Object[] removedEdges = Arrays.copyOf(oldRemovedEdges, oldRemovedEdges.length + 2);
        Node_ s1 = removedEdges[2 * k + 1];
        int i = 2 * (k + patchedCycleCount) - 2;
        Node_ s2 = removedEdges[i];
        addedEdgeToOtherEndpoint[i] = i + 1;
        addedEdgeToOtherEndpoint[addedEdgeToOtherEndpoint[i]] = i;
        for (i = 1; i <= 2 * k; ++i) {
            cycleSaved[i] = cycle[i];
        }
        Node_ s3 = valueIterator.next();
        int remainingAttempts = (cycleCount - patchedCycleCount) * 2;
        while (s3 != this.getNodePredecessor(s2) || s3 != this.getNodeSuccessor(s2) || (NewCycle = this.findCycleIdentifierForNode(s3, removedEdges, originalMove.getRemovedEdgeIndexToTourOrder(), cycle)) == currentCycle || this.isEdgeAlreadyDeleted(removedEdges, s3, this.getNodePredecessor(s3), k) && this.isEdgeAlreadyDeleted(removedEdges, s3, this.getNodeSuccessor(s3), k)) {
            if (remainingAttempts == 0) {
                return originalMove;
            }
            s3 = valueIterator.next();
            --remainingAttempts;
        }
        removedEdges[2 * (k + patchedCycleCount) - 1] = s3;
        Node_ s4 = this.isEdgeAlreadyDeleted(removedEdges, s3, this.getNodePredecessor(s3), k) ? this.getNodeSuccessor(s3) : (this.isEdgeAlreadyDeleted(removedEdges, s3, this.getNodeSuccessor(s3), k) ? this.getNodePredecessor(s3) : (this.workingRandom.nextBoolean() ? this.getNodeSuccessor(s3) : this.getNodePredecessor(s3)));
        removedEdges[2 * (k + patchedCycleCount)] = s4;
        if (cycleCount > 2) {
            for (i = 1; i <= 2 * k; ++i) {
                if (cycle[i] != NewCycle) continue;
                cycle[i] = currentCycle;
            }
            KOptDescriptor<Solution_, Object> recursiveCall = this.patchCyclesRec(valueIterator, originalMove, removedEdges, addedEdgeToOtherEndpoint, cycle, currentCycle, k, patchedCycleCount + 1, cycleCount - 1);
            if (recursiveCall.isFeasible()) {
                return recursiveCall;
            }
            for (i = 1; i <= 2 * k; ++i) {
                cycle[i] = cycleSaved[i];
            }
        } else if (s4 != s1) {
            int n = 2 * (k + patchedCycleCount);
            addedEdgeToOtherEndpoint[2 * k + 1] = n;
            addedEdgeToOtherEndpoint[n] = 2 * k + 1;
            return new KOptDescriptor(removedEdges, addedEdgeToOtherEndpoint, this.successorFunction, this.betweenFunction);
        }
        return originalMove;
    }

    int findCycleIdentifierForNode(Node_ value, Node_[] pickedValues, int[] permutation, int[] indexToCycle) {
        for (int i = 1; i < pickedValues.length; ++i) {
            if (!this.isMiddleNodeBetween(pickedValues[permutation[i]], value, pickedValues[permutation[i + 1]])) continue;
            return indexToCycle[permutation[i]];
        }
        throw new IllegalStateException("Cannot find cycle the " + value + " belongs to");
    }

    int getShortestCycleIdentifier(Object[] removeEdgeEndpoints, int[] endpointIndexToCycle, int[] removeEdgeEndpointIndexToTourOrder, int cycleCount, int k) {
        int i;
        int minCycleIdentifier = 0;
        int minSize = Integer.MAX_VALUE;
        int[] size = new int[cycleCount + 1];
        for (i = 1; i <= cycleCount; ++i) {
            size[i] = 0;
        }
        removeEdgeEndpointIndexToTourOrder[0] = removeEdgeEndpointIndexToTourOrder[2 * k];
        for (i = 0; i < 2 * k; i += 2) {
            int n = endpointIndexToCycle[removeEdgeEndpointIndexToTourOrder[i]];
            size[n] = size[n] + this.getSegmentSize(removeEdgeEndpoints[removeEdgeEndpointIndexToTourOrder[i]], removeEdgeEndpoints[removeEdgeEndpointIndexToTourOrder[i + 1]]);
        }
        for (i = 1; i <= cycleCount; ++i) {
            if (size[i] >= minSize) continue;
            minSize = size[i];
            minCycleIdentifier = i;
        }
        return minCycleIdentifier;
    }

    private int getSegmentSize(Object from, Object to) {
        int endIndex;
        int startIndex = this.indexVariableSupply.getIndex(from);
        if (startIndex <= (endIndex = this.indexVariableSupply.getIndex(to).intValue())) {
            return endIndex - startIndex;
        }
        return this.listVariableDescriptor.getListSize(this.inverseVariableSupply.getInverseSingleton(from)) - startIndex + endIndex;
    }

    private boolean isEdgeAlreadyAdded(Object[] pickedValues, Object ta, Object tb, int k) {
        int i = 2 * k;
        while ((i -= 2) > 0) {
            if ((ta != pickedValues[i] || tb != pickedValues[i + 1]) && (ta != pickedValues[i + 1] || tb != pickedValues[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isEdgeAlreadyDeleted(Object[] pickedValues, Object ta, Object tb, int k) {
        int i = 2 * k + 2;
        while ((i -= 2) > 0) {
            if ((ta != pickedValues[i - 1] || tb != pickedValues[i]) && (ta != pickedValues[i] || tb != pickedValues[i - 1])) continue;
            return true;
        }
        return false;
    }

    private Node_ getNodeSuccessor(Node_ node) {
        return this.successorFunction.apply(node);
    }

    private Node_ getNodePredecessor(Node_ node) {
        return this.predecessorFunction.apply(node);
    }

    private boolean isMiddleNodeBetween(Node_ start, Node_ middle, Node_ end) {
        return this.betweenFunction.test(start, middle, end);
    }
}

