/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.persistence;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractJsonSolutionFileIO;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaplanner.examples.tsp.domain.location.DistanceType;
import org.optaplanner.examples.tsp.domain.location.RoadLocation;

public final class TspSolutionFileIO
extends AbstractJsonSolutionFileIO<TspSolution> {
    public TspSolutionFileIO() {
        super(TspSolution.class);
    }

    public TspSolution read(File inputSolutionFile) {
        TspSolution tspSolution = (TspSolution)super.read(inputSolutionFile);
        if (tspSolution.getDistanceType() == DistanceType.ROAD_DISTANCE) {
            this.deduplicateRoadLocations(tspSolution);
        }
        return tspSolution;
    }

    private void deduplicateRoadLocations(TspSolution tspSolution) {
        List roadLocationList = tspSolution.getLocationList().stream().filter(location -> location instanceof RoadLocation).map(location -> (RoadLocation)location).collect(Collectors.toList());
        Map locationsById = roadLocationList.stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        for (RoadLocation roadLocation : roadLocationList) {
            Map<RoadLocation, Double> newTravelDistanceMap = this.deduplicateMap(roadLocation.getTravelDistanceMap(), locationsById, AbstractPersistable::getId);
            roadLocation.setTravelDistanceMap(newTravelDistanceMap);
        }
    }
}

