/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.nearby;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Objects;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.entity.AbstractEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.util.MemoizingSupply;

public final class NearEntityNearbyEntitySelector<Solution_>
extends AbstractEntitySelector<Solution_> {
    private final EntitySelector<Solution_> childEntitySelector;
    private final EntitySelector<Solution_> replayingOriginEntitySelector;
    private final NearbyDistanceMeter<?, ?> nearbyDistanceMeter;
    private final NearbyRandom nearbyRandom;
    private final boolean randomSelection;
    private final boolean discardNearbyIndexZero = true;
    private final NearbyDistanceMatrixDemand<Solution_, ?, ?> nearbyDistanceMatrixDemand;
    private MemoizingSupply<NearbyDistanceMatrix<Object, Object>> nearbyDistanceMatrixSupply = null;

    public NearEntityNearbyEntitySelector(EntitySelector<Solution_> childEntitySelector, EntitySelector<Solution_> originEntitySelector, NearbyDistanceMeter<?, ?> nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        this.childEntitySelector = childEntitySelector;
        if (!(originEntitySelector instanceof MimicReplayingEntitySelector)) {
            throw new IllegalStateException("Impossible state: Nearby entity selector (" + this + ") did not receive a replaying entity selector (" + originEntitySelector + ").");
        }
        this.replayingOriginEntitySelector = originEntitySelector;
        this.nearbyDistanceMeter = nearbyDistanceMeter;
        this.nearbyRandom = nearbyRandom;
        this.randomSelection = randomSelection;
        if (randomSelection && nearbyRandom == null) {
            throw new IllegalArgumentException("The entitySelector (" + this + ") with randomSelection (" + randomSelection + ") has no nearbyRandom (" + nearbyRandom + ").");
        }
        if (!childEntitySelector.getEntityDescriptor().getEntityClass().isAssignableFrom(originEntitySelector.getEntityDescriptor().getEntityClass())) {
            throw new IllegalArgumentException("The entitySelector (" + this + ") has an entityClass (" + childEntitySelector.getEntityDescriptor().getEntityClass() + ") which is not a superclass of the originEntitySelector's entityClass (" + originEntitySelector.getEntityDescriptor().getEntityClass() + ").");
        }
        this.nearbyDistanceMatrixDemand = new NearbyDistanceMatrixDemand(nearbyDistanceMeter, childEntitySelector, this.replayingOriginEntitySelector, origin -> this.computeDestinationSize(childEntitySelector.getSize()));
        this.phaseLifecycleSupport.addEventListener(childEntitySelector);
        this.phaseLifecycleSupport.addEventListener(originEntitySelector);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.nearbyDistanceMatrixSupply = (MemoizingSupply)solverScope.getScoreDirector().getSupplyManager().demand(this.nearbyDistanceMatrixDemand);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.nearbyDistanceMatrixSupply.read();
    }

    private int computeDestinationSize(long childSize) {
        int destinationSize = (int)childSize;
        if (this.randomSelection) {
            int overallSizeMaximum = this.nearbyRandom.getOverallSizeMaximum();
            if (overallSizeMaximum != Integer.MAX_VALUE) {
                ++overallSizeMaximum;
            }
            if (destinationSize > overallSizeMaximum) {
                destinationSize = overallSizeMaximum;
            }
        }
        return destinationSize;
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        solverScope.getScoreDirector().getSupplyManager().cancel(this.nearbyDistanceMatrixDemand);
        this.nearbyDistanceMatrixSupply = null;
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.childEntitySelector.getSize() - 1L;
    }

    @Override
    public Iterator<Object> iterator() {
        Iterator<Object> replayingOriginEntityIterator = this.replayingOriginEntitySelector.iterator();
        if (!this.randomSelection) {
            return new OriginalNearbyEntityIterator(replayingOriginEntityIterator, this.childEntitySelector.getSize());
        }
        return new RandomNearbyEntityIterator(replayingOriginEntityIterator, this.childEntitySelector.getSize());
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Object> endingIterator() {
        return this.childEntitySelector.endingIterator();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NearEntityNearbyEntitySelector that = (NearEntityNearbyEntitySelector)other;
        return this.randomSelection == that.randomSelection && Objects.equals(this.childEntitySelector, that.childEntitySelector) && Objects.equals(this.replayingOriginEntitySelector, that.replayingOriginEntitySelector) && Objects.equals(this.nearbyDistanceMeter, that.nearbyDistanceMeter) && Objects.equals(this.nearbyRandom, that.nearbyRandom);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childEntitySelector, this.replayingOriginEntitySelector, this.nearbyDistanceMeter, this.nearbyRandom, this.randomSelection);
    }

    private final class OriginalNearbyEntityIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> replayingOriginEntityIterator;
        private final long childSize;
        private int nextNearbyIndex;

        public OriginalNearbyEntityIterator(Iterator<Object> replayingOriginEntityIterator, long childSize) {
            this.replayingOriginEntityIterator = replayingOriginEntityIterator;
            this.childSize = childSize;
            this.nextNearbyIndex = 1;
        }

        @Override
        public boolean hasNext() {
            return this.replayingOriginEntityIterator.hasNext() && (long)this.nextNearbyIndex < this.childSize;
        }

        @Override
        public Object next() {
            Object origin = this.replayingOriginEntityIterator.next();
            Object next = NearEntityNearbyEntitySelector.this.nearbyDistanceMatrixSupply.read().getDestination(origin, this.nextNearbyIndex);
            ++this.nextNearbyIndex;
            return next;
        }
    }

    private final class RandomNearbyEntityIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> replayingOriginEntityIterator;
        private final int nearbySize;

        public RandomNearbyEntityIterator(Iterator<Object> replayingOriginEntityIterator, long childSize) {
            this.replayingOriginEntityIterator = replayingOriginEntityIterator;
            if (childSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The valueSelector (" + this + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
            }
            this.nearbySize = (int)childSize - 1;
        }

        @Override
        public boolean hasNext() {
            return this.replayingOriginEntityIterator.hasNext() && this.nearbySize > 0;
        }

        @Override
        public Object next() {
            Object origin = this.replayingOriginEntityIterator.next();
            int nearbyIndex = NearEntityNearbyEntitySelector.this.nearbyRandom.nextInt(NearEntityNearbyEntitySelector.this.workingRandom, this.nearbySize);
            return NearEntityNearbyEntitySelector.this.nearbyDistanceMatrixSupply.read().getDestination(origin, ++nearbyIndex);
        }
    }
}

