/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.FlipSublistAction;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptAffectedElements;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptDescriptor;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.util.Pair;

final class KOptListMove<Solution_, Node_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final Object entity;
    private final KOptDescriptor<Solution_, Node_> descriptor;
    private final List<FlipSublistAction<Solution_>> equivalent2Opts;
    private final KOptAffectedElements affectedElementsInfo;
    private final int postShiftAmount;

    public KOptListMove(ListVariableDescriptor<Solution_> listVariableDescriptor, Object entity, KOptDescriptor<Solution_, Node_> descriptor, List<FlipSublistAction<Solution_>> equivalent2Opts, int postShiftAmount) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.entity = entity;
        this.descriptor = descriptor;
        this.equivalent2Opts = equivalent2Opts;
        this.postShiftAmount = postShiftAmount;
        if (equivalent2Opts.isEmpty()) {
            this.affectedElementsInfo = KOptAffectedElements.forMiddleRange(0, 0);
        } else if (postShiftAmount != 0) {
            this.affectedElementsInfo = KOptAffectedElements.forMiddleRange(0, listVariableDescriptor.getListSize(entity));
        } else {
            KOptAffectedElements currentAffectedElements = equivalent2Opts.get(0).getAffectedElements();
            for (int i = 1; i < equivalent2Opts.size(); ++i) {
                currentAffectedElements = currentAffectedElements.merge(equivalent2Opts.get(i).getAffectedElements());
            }
            this.affectedElementsInfo = currentAffectedElements;
        }
    }

    @Override
    protected AbstractMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        if (this.equivalent2Opts.isEmpty()) {
            return this;
        }
        ArrayList inverse2Opts = new ArrayList(this.equivalent2Opts.size());
        for (int i = this.equivalent2Opts.size() - 1; i >= 0; --i) {
            inverse2Opts.add(this.equivalent2Opts.get(i).createUndoMove());
        }
        return new UndoKOptListMove<Solution_, Node_>(this.listVariableDescriptor, this.entity, this.descriptor, inverse2Opts, -this.postShiftAmount, this.affectedElementsInfo);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        if (this.affectedElementsInfo.getWrappedStartIndex() != -1) {
            innerScoreDirector.beforeListVariableChanged(this.listVariableDescriptor, this.entity, this.affectedElementsInfo.getWrappedStartIndex(), this.listVariableDescriptor.getListSize(this.entity));
            innerScoreDirector.beforeListVariableChanged(this.listVariableDescriptor, this.entity, 0, this.affectedElementsInfo.getWrappedEndIndex());
        }
        for (Pair<Integer, Integer> pair : this.affectedElementsInfo.getAffectedMiddleRangeList()) {
            innerScoreDirector.beforeListVariableChanged(this.listVariableDescriptor, this.entity, (int)pair.getKey(), (int)pair.getValue());
        }
        for (FlipSublistAction flipSublistAction : this.equivalent2Opts) {
            flipSublistAction.doMoveOnGenuineVariables();
        }
        KOptListMove.rotateToOriginalPositions(this.listVariableDescriptor, this.entity, this.postShiftAmount);
        if (this.affectedElementsInfo.getWrappedStartIndex() != -1) {
            innerScoreDirector.afterListVariableChanged(this.listVariableDescriptor, this.entity, this.affectedElementsInfo.getWrappedStartIndex(), this.listVariableDescriptor.getListSize(this.entity));
            innerScoreDirector.afterListVariableChanged(this.listVariableDescriptor, this.entity, 0, this.affectedElementsInfo.getWrappedEndIndex());
        }
        for (Pair pair : this.affectedElementsInfo.getAffectedMiddleRangeList()) {
            innerScoreDirector.afterListVariableChanged(this.listVariableDescriptor, this.entity, (int)((Integer)pair.getKey()), (int)((Integer)pair.getValue()));
        }
    }

    private static <Solution_> void rotateToOriginalPositions(ListVariableDescriptor<Solution_> listVariableDescriptor, Object entity, int shiftAmount) {
        List<Object> listVariable = listVariableDescriptor.getListVariable(entity);
        Collections.rotate(listVariable, shiftAmount);
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return !this.equivalent2Opts.isEmpty();
    }

    @Override
    public Move<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        ArrayList<FlipSublistAction<Solution_>> rebasedEquivalent2Opts = new ArrayList<FlipSublistAction<Solution_>>(this.equivalent2Opts.size());
        for (FlipSublistAction<Solution_> twoOpt : this.equivalent2Opts) {
            rebasedEquivalent2Opts.add(twoOpt.rebase(destinationScoreDirector));
        }
        return new KOptListMove<Solution_, Node_>(this.listVariableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.entity), this.descriptor, rebasedEquivalent2Opts, this.postShiftAmount);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.descriptor.getK() + "-opt(" + this.listVariableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return List.of(this.entity);
    }

    @Override
    public Collection<?> getPlanningValues() {
        ArrayList<Object> out = new ArrayList<Object>();
        List<Object> listVariable = this.listVariableDescriptor.getListVariable(this.entity);
        if (this.affectedElementsInfo.getWrappedStartIndex() != -1) {
            out.addAll(listVariable.subList(this.affectedElementsInfo.getWrappedStartIndex(), listVariable.size()));
            out.addAll(listVariable.subList(0, this.affectedElementsInfo.getWrappedEndIndex()));
        }
        for (Pair<Integer, Integer> affectedInterval : this.affectedElementsInfo.getAffectedMiddleRangeList()) {
            out.addAll(listVariable.subList(affectedInterval.getKey(), affectedInterval.getValue()));
        }
        return out;
    }

    public String toString() {
        return this.descriptor.toString();
    }

    private static final class UndoKOptListMove<Solution_, Node_>
    extends AbstractMove<Solution_> {
        private final ListVariableDescriptor<Solution_> listVariableDescriptor;
        private final Object entity;
        private final KOptDescriptor<Solution_, Node_> descriptor;
        private final List<FlipSublistAction<Solution_>> equivalent2Opts;
        private final KOptAffectedElements affectedElementsInfo;
        private final int preShiftAmount;

        public UndoKOptListMove(ListVariableDescriptor<Solution_> listVariableDescriptor, Object entity, KOptDescriptor<Solution_, Node_> descriptor, List<FlipSublistAction<Solution_>> equivalent2Opts, int preShiftAmount, KOptAffectedElements affectedElementsInfo) {
            this.listVariableDescriptor = listVariableDescriptor;
            this.entity = entity;
            this.descriptor = descriptor;
            this.equivalent2Opts = equivalent2Opts;
            this.preShiftAmount = preShiftAmount;
            this.affectedElementsInfo = affectedElementsInfo;
        }

        @Override
        public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
            return true;
        }

        @Override
        protected AbstractMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
            InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
            if (this.affectedElementsInfo.getWrappedStartIndex() != -1) {
                innerScoreDirector.beforeListVariableChanged(this.listVariableDescriptor, this.entity, this.affectedElementsInfo.getWrappedStartIndex(), this.listVariableDescriptor.getListSize(this.entity));
                innerScoreDirector.beforeListVariableChanged(this.listVariableDescriptor, this.entity, 0, this.affectedElementsInfo.getWrappedEndIndex());
            }
            for (Pair<Integer, Integer> pair : this.affectedElementsInfo.getAffectedMiddleRangeList()) {
                innerScoreDirector.beforeListVariableChanged(this.listVariableDescriptor, this.entity, (int)pair.getKey(), (int)pair.getValue());
            }
            KOptListMove.rotateToOriginalPositions(this.listVariableDescriptor, this.entity, this.preShiftAmount);
            for (FlipSublistAction flipSublistAction : this.equivalent2Opts) {
                flipSublistAction.doMoveOnGenuineVariables();
            }
            if (this.affectedElementsInfo.getWrappedStartIndex() != -1) {
                innerScoreDirector.afterListVariableChanged(this.listVariableDescriptor, this.entity, this.affectedElementsInfo.getWrappedStartIndex(), this.listVariableDescriptor.getListSize(this.entity));
                innerScoreDirector.afterListVariableChanged(this.listVariableDescriptor, this.entity, 0, this.affectedElementsInfo.getWrappedEndIndex());
            }
            for (Pair pair : this.affectedElementsInfo.getAffectedMiddleRangeList()) {
                innerScoreDirector.afterListVariableChanged(this.listVariableDescriptor, this.entity, (int)((Integer)pair.getKey()), (int)((Integer)pair.getValue()));
            }
        }

        public String toString() {
            return "Undo" + this.descriptor.toString();
        }
    }
}

