/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.util.Properties;
import java.util.UUID;
import org.drools.core.BaseConfigurationFactories;
import org.drools.core.CompositeSessionConfiguration;
import org.drools.core.SessionConfigurationFactories;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.RuleBase;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.conf.CompositeBaseConfiguration;
import org.kie.internal.conf.ConfigurationFactory;
import org.kie.internal.utils.ChainedProperties;

public class RuleBaseFactory {
    public static RuleBase newRuleBase() {
        return RuleBaseFactory.newRuleBase(UUID.randomUUID().toString());
    }

    public static RuleBase newRuleBase(String kbaseId) {
        return RuleBaseFactory.newRuleBase(kbaseId, RuleBaseFactory.newKnowledgeBaseConfiguration());
    }

    public static RuleBase newRuleBase(KieBaseConfiguration conf) {
        return RuleBaseFactory.newRuleBase(UUID.randomUUID().toString(), conf);
    }

    public static RuleBase newRuleBase(String kbaseId, KieBaseConfiguration conf) {
        return new KnowledgeBaseImpl(kbaseId, (CompositeBaseConfiguration)conf);
    }

    public static KieBaseConfiguration newKnowledgeBaseConfiguration() {
        return RuleBaseFactory.newKnowledgeBaseConfiguration(null, null);
    }

    public static KieBaseConfiguration newKnowledgeBaseConfiguration(Properties properties, ClassLoader ... classLoaders) {
        if (classLoaders != null && (classLoaders.length > 1 || classLoaders[0] == null)) {
            throw new UnsupportedOperationException("Pass only a single, non null, classloader. As an array of Classloaders is no longer supported. ");
        }
        ClassLoader classLoader = classLoaders != null ? classLoaders[0] : null;
        ClassLoader projClassLoader = RuleBaseFactory.getClassLoader(classLoader);
        ChainedProperties chained = ChainedProperties.getChainedProperties((ClassLoader)projClassLoader);
        if (properties != null) {
            chained.addProperties(properties);
        }
        return new CompositeBaseConfiguration(chained, projClassLoader, new ConfigurationFactory[]{BaseConfigurationFactories.baseConf, BaseConfigurationFactories.ruleConf, BaseConfigurationFactories.flowConf});
    }

    public static KieSessionConfiguration newKnowledgeSessionConfiguration() {
        ClassLoader classLoader = RuleBaseFactory.class.getClassLoader();
        return RuleBaseFactory.newKnowledgeSessionConfiguration(ChainedProperties.getChainedProperties((ClassLoader)classLoader), classLoader);
    }

    public static KieSessionConfiguration newKnowledgeSessionConfiguration(ChainedProperties chained, ClassLoader classLoader) {
        return new CompositeSessionConfiguration(chained, classLoader, SessionConfigurationFactories.baseConf, SessionConfigurationFactories.ruleConf, SessionConfigurationFactories.flowConf);
    }

    private static ClassLoader getClassLoader(ClassLoader classLoader) {
        ClassLoader projClassLoader = classLoader instanceof ProjectClassLoader ? classLoader : ProjectClassLoader.getClassLoader((ClassLoader)classLoader, RuleBaseFactory.class);
        return projClassLoader;
    }
}

