/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.index.AbstractTupleIndexTree;
import org.drools.core.util.index.IndexUtil;
import org.drools.core.util.index.TupleIndexRBTree;
import org.drools.core.util.index.TupleList;

public class FastUtilTreeMemory
extends AbstractTupleIndexTree
implements TupleMemory {
    private Object2ObjectRBTreeMap<Comparable, TupleList> tree;
    private TreeFastIterator fastIterator;
    private TreeFastFullIterator fullFastIterator;
    private TupleList nullTupleList;

    public FastUtilTreeMemory(IndexUtil.ConstraintType constraintType, AbstractHashTable.FieldIndex index, boolean left) {
        this.index = index;
        this.constraintType = constraintType;
        this.left = left;
        this.tree = new Object2ObjectRBTreeMap();
        this.fastIterator = new TreeFastIterator(this);
        this.fullFastIterator = new TreeFastFullIterator(this);
        this.nullTupleList = new TupleList();
    }

    @Override
    public Tuple getFirst(Tuple tuple) {
        return this.fastIterator.getFirst(tuple);
    }

    @Override
    public void removeAdd(Tuple tuple) {
        AbstractTupleIndexTree.IndexTupleList tupleList = (AbstractTupleIndexTree.IndexTupleList)tuple.getMemory();
        tupleList.remove(tuple);
        if (tupleList.getFirst() == null && tupleList != this.nullTupleList) {
            this.tree.remove((Object)tupleList.key());
        }
        TupleList entry = this.getOrCreate(tuple);
        entry.add(tuple);
    }

    @Override
    public void add(Tuple tuple) {
        TupleList entry = this.getOrCreate(tuple);
        entry.add(tuple);
        ++this.factSize;
    }

    private TupleList getOrCreate(Tuple tuple) {
        Comparable key = TupleIndexRBTree.coerceType(this.index, !this.tree.isEmpty() ? (Comparable)this.tree.firstKey() : null, this.getIndexedValue(tuple, this.left));
        if (key == null) {
            return this.nullTupleList;
        }
        TupleList entry = (TupleList)this.tree.compute((Object)key, (newKey, tupleList) -> {
            if (tupleList == null) {
                tupleList = new AbstractTupleIndexTree.IndexTupleList(key);
            }
            return tupleList;
        });
        return entry;
    }

    @Override
    public void remove(Tuple tuple) {
        AbstractTupleIndexTree.IndexTupleList memory = (AbstractTupleIndexTree.IndexTupleList)tuple.getMemory();
        memory.remove(tuple);
        --this.factSize;
        if (memory.getFirst() == null && memory != this.nullTupleList) {
            this.tree.remove((Object)memory.key());
        }
        tuple.clear();
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public int size() {
        return this.factSize;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return null;
    }

    @Override
    public FastIterator<Tuple> fastIterator() {
        return this.fastIterator;
    }

    public FastIterator fullFastIterator() {
        this.fullFastIterator.reset();
        return this.fullFastIterator;
    }

    public FastIterator fullFastIterator(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tuple[] toArray() {
        Tuple[] result = new Tuple[this.size()];
        int index = 0;
        for (Object2ObjectMap.Entry entry : Object2ObjectMaps.fastIterable(this.tree)) {
            TupleList tupleList = (TupleList)entry.getValue();
            for (Tuple entry2 = tupleList.getFirst(); entry2 != null; entry2 = (Tuple)entry2.getNext()) {
                result[index++] = entry2;
            }
        }
        return result;
    }

    @Override
    public TupleMemory.IndexType getIndexType() {
        return TupleMemory.IndexType.COMPARISON;
    }

    @Override
    public void clear() {
        this.tree.clear();
        this.factSize = 0;
    }

    public static class TreeFastIterator
    implements FastIterator<Tuple> {
        FastUtilTreeMemory treeMemory;
        ObjectBidirectionalIterator<Object2ObjectMap.Entry<Comparable, TupleList>> it;
        Tuple current;
        Comparable key;
        IndexUtil.ConstraintType constraintType;

        public TreeFastIterator(FastUtilTreeMemory treeMemory) {
            this.treeMemory = treeMemory;
            this.constraintType = !treeMemory.left ? treeMemory.constraintType : treeMemory.constraintType.negate();
        }

        public Tuple getFirst(Tuple tuple) {
            this.key = TupleIndexRBTree.coerceType(this.treeMemory.index, !this.treeMemory.tree.isEmpty() ? (Comparable)this.treeMemory.tree.firstKey() : null, this.treeMemory.getIndexedValue(tuple, !this.treeMemory.left));
            if (this.key == null) {
                switch (this.constraintType) {
                    case EQUAL: 
                    case GREATER_OR_EQUAL: 
                    case LESS_OR_EQUAL: {
                        return this.treeMemory.nullTupleList.getFirst();
                    }
                }
                return null;
            }
            HolderEntry from = HolderEntry.getInstance().setKey(this.key);
            this.it = this.constraintType == IndexUtil.ConstraintType.LESS_THAN || this.constraintType == IndexUtil.ConstraintType.LESS_OR_EQUAL ? this.treeMemory.tree.object2ObjectEntrySet().iterator() : this.treeMemory.tree.object2ObjectEntrySet().iterator((Object)from);
            Tuple first = null;
            if (this.it.hasNext()) {
                switch (this.constraintType) {
                    case LESS_THAN: {
                        Object2ObjectMap.Entry tempKey = (Object2ObjectMap.Entry)this.it.next();
                        if (((Comparable)tempKey.getKey()).compareTo(this.key) < 0) {
                            first = ((TupleList)tempKey.getValue()).getFirst();
                            break;
                        }
                        this.key = null;
                        this.it = null;
                        break;
                    }
                    case LESS_OR_EQUAL: {
                        Object2ObjectMap.Entry tempKey = (Object2ObjectMap.Entry)this.it.next();
                        if (((Comparable)tempKey.getKey()).compareTo(this.key) <= 0) {
                            first = ((TupleList)tempKey.getValue()).getFirst();
                            break;
                        }
                        this.key = null;
                        this.it = null;
                        break;
                    }
                    case GREATER_OR_EQUAL: {
                        if (this.it.hasPrevious()) {
                            Object2ObjectMap.Entry prev = (Object2ObjectMap.Entry)this.it.previous();
                            if (((Comparable)prev.getKey()).compareTo(this.key) < 0) break;
                            Object2ObjectMap.Entry entry = prev;
                            first = ((TupleList)entry.getValue()).getFirst();
                            break;
                        }
                    }
                    default: {
                        Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)this.it.next();
                        first = ((TupleList)entry.getValue()).getFirst();
                        break;
                    }
                }
            }
            this.current = first;
            return first;
        }

        @Override
        public Tuple next(Tuple tuple) {
            Tuple next = (Tuple)tuple.getNext();
            if (next == null && this.it.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)this.it.next();
                TupleList list = (TupleList)entry.getValue();
                switch (this.constraintType) {
                    case LESS_THAN: {
                        if (((Comparable)entry.getKey()).compareTo(this.key) < 0) {
                            next = list.getFirst();
                            break;
                        }
                        this.it = null;
                        this.key = null;
                        break;
                    }
                    case LESS_OR_EQUAL: {
                        if (((Comparable)entry.getKey()).compareTo(this.key) <= 0) {
                            next = list.getFirst();
                            break;
                        }
                        this.it = null;
                        this.key = null;
                        break;
                    }
                    default: {
                        next = list.getFirst();
                        break;
                    }
                }
            } else if (next == null) {
                this.it = null;
                this.key = null;
            }
            this.current = next;
            return next;
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }
    }

    public static class TreeFastFullIterator
    implements FastIterator<Tuple> {
        FastUtilTreeMemory treeMemory;
        ObjectIterator<Object2ObjectMap.Entry<Comparable, TupleList>> it;
        Tuple current;
        Comparable key;

        public TreeFastFullIterator(FastUtilTreeMemory treeMemory) {
            this.treeMemory = treeMemory;
        }

        public void reset() {
            this.it = this.treeMemory.tree.object2ObjectEntrySet().iterator();
        }

        public void resume(Tuple tuple) {
            this.it = this.treeMemory.tree.object2ObjectEntrySet().iterator();
        }

        @Override
        public Tuple next(Tuple tuple) {
            Tuple next = null;
            if (tuple != null) {
                next = (Tuple)tuple.getNext();
            }
            if (next == null && this.it.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)this.it.next();
                TupleList list = (TupleList)entry.getValue();
                next = list.getFirst();
            }
            this.current = next;
            return next;
        }

        @Override
        public boolean isFullIterator() {
            return true;
        }
    }

    public static class HolderEntry
    implements Object2ObjectMap.Entry<Comparable, TupleList> {
        static HolderEntry INSTANCE = new HolderEntry();
        private Comparable key;

        public static HolderEntry getInstance() {
            return INSTANCE;
        }

        @Override
        public Comparable getKey() {
            return this.key;
        }

        public HolderEntry setKey(Comparable key) {
            this.key = key;
            return this;
        }

        @Override
        public TupleList getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TupleList setValue(TupleList value) {
            throw new UnsupportedOperationException();
        }
    }
}

