/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Arrays;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.BendableLongScoreContext;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.stream.Constraint;

public final class BendableLongScoreInliner
extends AbstractScoreInliner<BendableLongScore> {
    private final long[] hardScores;
    private final long[] softScores;

    BendableLongScoreInliner(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new long[hardLevelsSize];
        this.softScores = new long[softLevelsSize];
    }

    @Override
    public WeightedScoreImpacter<BendableLongScore, BendableLongScoreContext> buildWeightedScoreImpacter(Constraint constraint, BendableLongScore constraintWeight) {
        this.validateConstraintWeight(constraint, constraintWeight);
        Integer singleLevel = null;
        for (int i = 0; i < constraintWeight.levelsSize(); ++i) {
            if (constraintWeight.hardOrSoftScore(i) == 0L) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        BendableLongScoreContext.IntLongConsumer hardScoreUpdater = (scoreLevel, impact) -> {
            int n = scoreLevel;
            this.hardScores[n] = this.hardScores[n] + impact;
        };
        BendableLongScoreContext.IntLongConsumer softScoreUpdater = (scoreLevel, impact) -> {
            int n = scoreLevel;
            this.softScores[n] = this.softScores[n] + impact;
        };
        if (singleLevel != null) {
            boolean isHardScore = singleLevel < constraintWeight.hardLevelsSize();
            int level = isHardScore ? singleLevel : singleLevel - constraintWeight.hardLevelsSize();
            BendableLongScoreContext context = new BendableLongScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length, level, constraintWeight.hardOrSoftScore(singleLevel.intValue()), hardScoreUpdater, softScoreUpdater);
            if (isHardScore) {
                return WeightedScoreImpacter.of(context, (ctx, impact, justificationSupplier) -> ctx.changeHardScoreBy(impact, justificationSupplier));
            }
            return WeightedScoreImpacter.of(context, (ctx, impact, justificationSupplier) -> ctx.changeSoftScoreBy(impact, justificationSupplier));
        }
        BendableLongScoreContext context = new BendableLongScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length, hardScoreUpdater, softScoreUpdater);
        return WeightedScoreImpacter.of(context, (ctx, impact, justificationSupplier) -> ctx.changeScoreBy(impact, justificationSupplier));
    }

    @Override
    public BendableLongScore extractScore(int initScore) {
        return BendableLongScore.ofUninitialized((int)initScore, (long[])Arrays.copyOf(this.hardScores, this.hardScores.length), (long[])Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableLongScore.class.getSimpleName() + " inliner";
    }
}

