/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.internal.utils;

import java.util.ServiceLoader;

public interface KieService
extends Comparable<KieService> {
    default public int servicePriority() {
        return 0;
    }

    @Override
    default public int compareTo(KieService other) {
        if (this.servicePriority() == other.servicePriority()) {
            throw new IllegalStateException("Found 2 services with same priority (" + this.servicePriority() + "): " + this.getClass().getCanonicalName() + " and " + other.getClass().getCanonicalName());
        }
        return this.servicePriority() - other.servicePriority();
    }

    public static <T extends KieService> T load(Class<T> serviceClass) {
        ServiceLoader<KieService> loader = ServiceLoader.load(serviceClass, serviceClass.getClassLoader());
        KieService service = null;
        for (KieService impl : loader) {
            if (service != null && impl.compareTo(service) <= 0) continue;
            service = impl;
        }
        return (T)service;
    }
}

