/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.travelingtournament.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.jackson.JacksonUniqueIdGenerator;
import org.optaplanner.examples.common.persistence.jackson.KeySerializer;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.travelingtournament.domain.TeamKeyDeserializer;

@JsonIdentityInfo(generator=JacksonUniqueIdGenerator.class)
public class Team
extends AbstractPersistable
implements Labeled {
    private String name;
    private Map<Team, Integer> distanceToTeamMap;

    public Team() {
    }

    public Team(long id) {
        super(id);
    }

    public Team(long id, String name) {
        this(id);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonSerialize(keyUsing=KeySerializer.class)
    @JsonDeserialize(keyUsing=TeamKeyDeserializer.class)
    public Map<Team, Integer> getDistanceToTeamMap() {
        return this.distanceToTeamMap;
    }

    public void setDistanceToTeamMap(Map<Team, Integer> distanceToTeamMap) {
        this.distanceToTeamMap = distanceToTeamMap;
    }

    @JsonIgnore
    public int getDistance(Team other) {
        return this.distanceToTeamMap.get(other);
    }

    @Override
    public String getLabel() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

