/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactoryService;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactoryService;
import org.optaplanner.core.impl.score.director.ScoreDirectorType;
import org.optaplanner.test.impl.score.stream.ConfiguredConstraintVerifier;

final class ScoreDirectorFactoryCache<ConstraintProvider_ extends ConstraintProvider, Solution_, Score_ extends Score<Score_>> {
    private final Map<String, AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_>> scoreDirectorFactoryMap = new HashMap<String, AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_>>();
    private final ConfiguredConstraintVerifier<ConstraintProvider_, Solution_, Score_> parent;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final ServiceLoader<ScoreDirectorFactoryService<Solution_, Score_>> serviceLoader;

    public ScoreDirectorFactoryCache(ConfiguredConstraintVerifier<ConstraintProvider_, Solution_, Score_> parent, SolutionDescriptor<Solution_> solutionDescriptor) {
        this.parent = Objects.requireNonNull(parent);
        this.solutionDescriptor = Objects.requireNonNull(solutionDescriptor);
        this.serviceLoader = ServiceLoader.load(ScoreDirectorFactoryService.class);
    }

    private AbstractConstraintStreamScoreDirectorFactoryService<Solution_, Score_> getScoreDirectorFactoryService() {
        ConstraintStreamImplType constraintStreamImplType = this.parent.getConstraintStreamImplType();
        return this.serviceLoader.stream().map(ServiceLoader.Provider::get).filter(s -> s.getSupportedScoreDirectorType() == ScoreDirectorType.CONSTRAINT_STREAMS).map(s -> (AbstractConstraintStreamScoreDirectorFactoryService)s).filter(s -> constraintStreamImplType == null || s.supportsImplType(constraintStreamImplType)).max(Comparator.comparingInt(ScoreDirectorFactoryService::getPriority)).orElseThrow(() -> new IllegalStateException("Constraint Streams implementation was not found on the classpath.\nMaybe include org.optaplanner:optaplanner-constraint-streams-drools dependency or org.optaplanner:optaplanner-constraint-streams-bavet in your project?\nMaybe ensure your uberjar bundles META-INF/services from included JAR files?"));
    }

    public AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction, ConstraintProvider_ constraintProvider, EnvironmentMode environmentMode) {
        AbstractConstraintStreamScoreDirectorFactoryService<Solution_, Score_> scoreDirectorFactoryService = this.getScoreDirectorFactoryService();
        Constraint constraint = constraintFunction.apply(constraintProvider, scoreDirectorFactoryService.buildConstraintFactory(this.solutionDescriptor, environmentMode));
        String constraintId = constraint.getConstraintId();
        return this.getScoreDirectorFactory(constraintId, constraintFactory -> new Constraint[]{constraint}, environmentMode);
    }

    public AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory(String key, ConstraintProvider constraintProvider, EnvironmentMode environmentMode) {
        return this.scoreDirectorFactoryMap.computeIfAbsent(key, k -> this.createScoreDirectorFactory(this.getScoreDirectorFactoryService(), constraintProvider, environmentMode));
    }

    private boolean determineDroolsAlphaNetworkCompilationEnabled(AbstractConstraintStreamScoreDirectorFactoryService<Solution_, Score_> scoreDirectorFactoryService) {
        return this.parent.getDroolsAlphaNetworkCompilationEnabled() && this.determineConstraintStreamImplType(scoreDirectorFactoryService) == ConstraintStreamImplType.DROOLS;
    }

    private ConstraintStreamImplType determineConstraintStreamImplType(AbstractConstraintStreamScoreDirectorFactoryService<Solution_, Score_> scoreDirectorFactoryService) {
        return scoreDirectorFactoryService.supportsImplType(ConstraintStreamImplType.BAVET) ? ConstraintStreamImplType.BAVET : ConstraintStreamImplType.DROOLS;
    }

    private AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> createScoreDirectorFactory(AbstractConstraintStreamScoreDirectorFactoryService<Solution_, Score_> scoreDirectorFactoryService, ConstraintProvider constraintProvider, EnvironmentMode environmentMode) {
        return scoreDirectorFactoryService.buildScoreDirectorFactory(this.solutionDescriptor, constraintProvider, environmentMode, this.determineDroolsAlphaNetworkCompilationEnabled(scoreDirectorFactoryService));
    }
}

