/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.ElementDestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.ListChangeMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelectorFactory;

public class ChangeMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, ChangeMoveSelectorConfig> {
    public ChangeMoveSelectorFactory(ChangeMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        if (((ChangeMoveSelectorConfig)this.config).getEntitySelectorConfig() == null) {
            throw new IllegalStateException("The entitySelectorConfig (" + ((ChangeMoveSelectorConfig)this.config).getEntitySelectorConfig() + ") should haven been initialized during unfolding.");
        }
        if (((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig() == null) {
            throw new IllegalStateException("The valueSelectorConfig (" + ((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig() + ") should haven been initialized during unfolding.");
        }
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntitySelector entitySelector = EntitySelectorFactory.create(((ChangeMoveSelectorConfig)this.config).getEntitySelectorConfig()).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder);
        ValueSelector sourceValueSelector = ValueSelectorFactory.create(((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig()).buildValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, selectionOrder);
        if (sourceValueSelector.getVariableDescriptor().isListVariable()) {
            if (!(sourceValueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The changeMoveSelector (" + this.config + ") for a list variable needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + sourceValueSelector + "). Check your valueSelectorConfig.");
            }
            ValueSelector destinationValueSelector = ValueSelectorFactory.create(new ValueSelectorConfig()).buildValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, selectionOrder, configPolicy.isReinitializeVariableFilterEnabled(), ValueSelectorFactory.ListValueFilteringType.ACCEPT_ASSIGNED);
            ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)sourceValueSelector.getVariableDescriptor();
            ElementDestinationSelector destinationSelector = new ElementDestinationSelector(listVariableDescriptor, entitySelector, (EntityIndependentValueSelector)destinationValueSelector, randomSelection);
            return new ListChangeMoveSelector(listVariableDescriptor, (EntityIndependentValueSelector)sourceValueSelector, destinationSelector, randomSelection);
        }
        return new ChangeMoveSelector(entitySelector, sourceValueSelector, randomSelection);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        EntityDescriptor onlyEntityDescriptor = ((ChangeMoveSelectorConfig)this.config).getEntitySelectorConfig() == null ? null : EntitySelectorFactory.create(((ChangeMoveSelectorConfig)this.config).getEntitySelectorConfig()).extractEntityDescriptor(configPolicy);
        Collection<Object> entityDescriptors = onlyEntityDescriptor != null ? Collections.singletonList(onlyEntityDescriptor) : configPolicy.getSolutionDescriptor().getGenuineEntityDescriptors();
        ArrayList<GenuineVariableDescriptor<Solution_>> variableDescriptorList = new ArrayList<GenuineVariableDescriptor<Solution_>>();
        for (EntityDescriptor entityDescriptor : entityDescriptors) {
            GenuineVariableDescriptor onlyVariableDescriptor;
            GenuineVariableDescriptor genuineVariableDescriptor = onlyVariableDescriptor = ((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig() == null ? null : ValueSelectorFactory.create(((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig()).extractVariableDescriptor(configPolicy, entityDescriptor);
            if (onlyVariableDescriptor != null) {
                if (onlyEntityDescriptor != null) {
                    return null;
                }
                variableDescriptorList.add(onlyVariableDescriptor);
                continue;
            }
            variableDescriptorList.addAll(entityDescriptor.getGenuineVariableDescriptorList());
        }
        return this.buildUnfoldedMoveSelectorConfig(variableDescriptorList);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(List<GenuineVariableDescriptor<Solution_>> variableDescriptorList) {
        ArrayList<MoveSelectorConfig> moveSelectorConfigList = new ArrayList<MoveSelectorConfig>(variableDescriptorList.size());
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : variableDescriptorList) {
            ChangeMoveSelectorConfig childMoveSelectorConfig = new ChangeMoveSelectorConfig();
            EntitySelectorConfig childEntitySelectorConfig = new EntitySelectorConfig(((ChangeMoveSelectorConfig)this.config).getEntitySelectorConfig());
            if (childEntitySelectorConfig.getMimicSelectorRef() == null) {
                childEntitySelectorConfig.setEntityClass(variableDescriptor.getEntityDescriptor().getEntityClass());
            }
            childMoveSelectorConfig.setEntitySelectorConfig(childEntitySelectorConfig);
            ValueSelectorConfig childValueSelectorConfig = new ValueSelectorConfig(((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig());
            if (childValueSelectorConfig.getMimicSelectorRef() == null) {
                childValueSelectorConfig.setVariableName(variableDescriptor.getVariableName());
            }
            childMoveSelectorConfig.setValueSelectorConfig(childValueSelectorConfig);
            moveSelectorConfigList.add(childMoveSelectorConfig);
        }
        MoveSelectorConfig unfoldedMoveSelectorConfig = moveSelectorConfigList.size() == 1 ? (MoveSelectorConfig)moveSelectorConfigList.get(0) : new UnionMoveSelectorConfig(moveSelectorConfigList);
        unfoldedMoveSelectorConfig.inheritFolded((MoveSelectorConfig)this.config);
        return unfoldedMoveSelectorConfig;
    }
}

