/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractRandomSwapIterator;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomSubListSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.SubList;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.SubListSwapMove;

public class RandomSubListSwapMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final RandomSubListSelector<Solution_> leftSubListSelector;
    private final RandomSubListSelector<Solution_> rightSubListSelector;
    private final boolean selectReversingMoveToo;

    public RandomSubListSwapMoveSelector(ListVariableDescriptor<Solution_> listVariableDescriptor, RandomSubListSelector<Solution_> leftSubListSelector, RandomSubListSelector<Solution_> rightSubListSelector, boolean selectReversingMoveToo) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.leftSubListSelector = leftSubListSelector;
        this.rightSubListSelector = rightSubListSelector;
        this.selectReversingMoveToo = selectReversingMoveToo;
        this.phaseLifecycleSupport.addEventListener(leftSubListSelector);
        this.phaseLifecycleSupport.addEventListener(rightSubListSelector);
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new AbstractRandomSwapIterator<Solution_, Move<Solution_>, SubList>(this.leftSubListSelector, this.rightSubListSelector){

            @Override
            protected Move<Solution_> newSwapSelection(SubList leftSubSelection, SubList rightSubSelection) {
                boolean reversing = RandomSubListSwapMoveSelector.this.selectReversingMoveToo && RandomSubListSwapMoveSelector.this.workingRandom.nextBoolean();
                return new SubListSwapMove(RandomSubListSwapMoveSelector.this.listVariableDescriptor, leftSubSelection, rightSubSelection, reversing);
            }
        };
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return true;
    }

    @Override
    public long getSize() {
        long leftSubListCount = this.leftSubListSelector.getSize();
        long rightSubListCount = this.rightSubListSelector.getSize();
        return leftSubListCount * rightSubListCount * (long)(this.selectReversingMoveToo ? 2 : 1);
    }

    boolean isSelectReversingMoveToo() {
        return this.selectReversingMoveToo;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftSubListSelector + ", " + this.rightSubListSelector + ")";
    }
}

