/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.util.function.Function;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.ScoreExplanation;
import org.optaplanner.core.api.solver.SolutionManager;
import org.optaplanner.core.api.solver.SolutionUpdatePolicy;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.score.DefaultScoreExplanation;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;
import org.optaplanner.core.impl.solver.DefaultSolverManager;

public final class DefaultSolutionManager<Solution_, Score_ extends Score<Score_>>
implements SolutionManager<Solution_, Score_> {
    private final InnerScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory;

    public <ProblemId_> DefaultSolutionManager(SolverManager<Solution_, ProblemId_> solverManager) {
        this(((DefaultSolverManager)solverManager).getSolverFactory());
    }

    public DefaultSolutionManager(SolverFactory<Solution_> solverFactory) {
        this.scoreDirectorFactory = ((DefaultSolverFactory)solverFactory).getScoreDirectorFactory();
    }

    public InnerScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public Score_ update(Solution_ solution, SolutionUpdatePolicy solutionUpdatePolicy) {
        if (solutionUpdatePolicy == SolutionUpdatePolicy.NO_UPDATE) {
            throw new IllegalArgumentException("Can not call " + this.getClass().getSimpleName() + ".update() with this solutionUpdatePolicy (" + solutionUpdatePolicy + ").");
        }
        return (Score_)this.callScoreDirector(solution, solutionUpdatePolicy, s -> s.getSolutionDescriptor().getScore(s.getWorkingSolution()), false);
    }

    @Override
    public ScoreExplanation<Solution_, Score_> explain(Solution_ solution, SolutionUpdatePolicy solutionUpdatePolicy) {
        Object freshScore;
        Score currentScore = this.scoreDirectorFactory.getSolutionDescriptor().getScore(solution);
        ScoreExplanation explanation = this.callScoreDirector(solution, solutionUpdatePolicy, DefaultScoreExplanation::new, true);
        if (!solutionUpdatePolicy.isScoreUpdateEnabled() && currentScore != null && !(freshScore = explanation.getScore()).equals(currentScore)) {
            throw new IllegalStateException("Current score (" + currentScore + ") and freshly calculated score (" + freshScore + ") for solution (" + solution + ") do not match.\nMaybe run " + EnvironmentMode.FULL_ASSERT + " to check for score corruptions.\nOtherwise enable " + SolutionUpdatePolicy.class.getSimpleName() + "." + SolutionUpdatePolicy.UPDATE_ALL + " to update the stale score.");
        }
        return explanation;
    }

    private <Result_> Result_ callScoreDirector(Solution_ solution, SolutionUpdatePolicy solutionUpdatePolicy, Function<InnerScoreDirector<Solution_, Score_>, Result_> function, boolean enableConstraintMatch) {
        try (InnerScoreDirector<Solution_, Score_> scoreDirector = this.scoreDirectorFactory.buildScoreDirector(false, enableConstraintMatch);){
            boolean constraintMatchEnabled = scoreDirector.isConstraintMatchEnabled();
            if (enableConstraintMatch && !constraintMatchEnabled) {
                throw new IllegalStateException("When constraintMatchEnabled (" + constraintMatchEnabled + ") is disabled, this method should not be called.");
            }
            scoreDirector.setWorkingSolution(solution);
            if (solutionUpdatePolicy.isShadowVariableUpdateEnabled()) {
                scoreDirector.forceTriggerVariableListeners();
            }
            if (solutionUpdatePolicy.isScoreUpdateEnabled()) {
                scoreDirector.calculateScore();
            }
            Result_ Result_ = function.apply(scoreDirector);
            return Result_;
        }
    }
}

