/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.TupleSets;
import org.drools.core.common.UpdateContext;
import org.drools.core.phreak.RuntimeSegmentUtilities;
import org.drools.core.phreak.TupleEvaluationUtil;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.definition.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeftInputAdapterNode
extends LeftTupleSource
implements ObjectSinkNode,
MemoryFactory<LiaNodeMemory> {
    protected static final transient Logger log = LoggerFactory.getLogger(LeftInputAdapterNode.class);
    private static final long serialVersionUID = 510L;
    private ObjectSource objectSource;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;
    private boolean leftTupleMemoryEnabled;
    protected BitMask sinkMask;

    public LeftInputAdapterNode() {
    }

    public LeftInputAdapterNode(int id, ObjectSource source, BuildContext context) {
        super(id, context);
        this.setObjectCount(1);
        this.objectSource = source;
        this.leftTupleMemoryEnabled = context.isTupleMemoryEnabled();
        ObjectSource current = source;
        while (current.getType() != 30) {
            current = current.getParentObjectSource();
        }
        this.setStreamMode(context.isStreamMode() && context.getRootObjectTypeNode().getObjectType().isEvent());
        this.sinkMask = this.calculateSinkMask(context);
        this.hashcode = this.calculateHashCode();
    }

    private BitMask calculateSinkMask(BuildContext context) {
        Pattern pattern;
        Pattern pattern2 = pattern = context.getLastBuiltPatterns() != null ? context.getLastBuiltPatterns()[0] : null;
        if (pattern == null) {
            return AllSetBitMask.get();
        }
        ObjectType objectType = pattern.getObjectType();
        if (!(objectType instanceof ClassObjectType)) {
            return AllSetBitMask.get();
        }
        return PropertySpecificUtil.isPropertyReactive(context, objectType) ? pattern.getPositiveWatchMask(pattern.getAccessibleProperties(context.getRuleBase())) : AllSetBitMask.get();
    }

    public ObjectSource getObjectSource() {
        return this.objectSource;
    }

    @Override
    public short getType() {
        return 120;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.leftTupleMemoryEnabled;
    }

    public ObjectSource getParentObjectSource() {
        return this.objectSource;
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.objectSource.addObjectSink(this);
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.objectSource.networkUpdated(updateContext);
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        LiaNodeMemory lm = reteEvaluator.getNodeMemory(this);
        LeftInputAdapterNode.doInsertObject(factHandle, context, this, reteEvaluator, lm, true, true);
    }

    public static void doInsertObject(InternalFactHandle factHandle, PropagationContext context, LeftInputAdapterNode liaNode, ReteEvaluator reteEvaluator, LiaNodeMemory lm, boolean linkOrNotify, boolean useLeftMemory) {
        boolean notifySegment;
        SegmentMemory sm = lm.getOrCreateSegmentMemory(liaNode, reteEvaluator);
        if (sm.getTipNode() == liaNode) {
            if (sm.isEmpty()) {
                RuntimeSegmentUtilities.createChildSegments(reteEvaluator, sm, liaNode.getSinkPropagator());
            }
            sm = (SegmentMemory)sm.getFirst();
        }
        int counter = lm.getAndIncreaseCounter();
        boolean bl = notifySegment = linkOrNotify && counter != 0;
        if (counter == 0) {
            if (linkOrNotify) {
                lm.linkNode(reteEvaluator);
            } else {
                lm.linkNodeWithoutRuleNotify();
            }
        }
        LeftTupleSink sink = liaNode.getSinkPropagator().getFirstLeftTupleSink();
        LeftTuple leftTuple = sink.createLeftTuple(factHandle, useLeftMemory);
        leftTuple.setPropagationContext(context);
        if (sm.getRootNode() == liaNode) {
            LeftInputAdapterNode.doInsertSegmentMemoryWithFlush(reteEvaluator, notifySegment, lm, sm, leftTuple, liaNode.isStreamMode());
        } else {
            LeftTuple peer = leftTuple;
            SegmentMemory originaSm = sm;
            for (sm = sm.getNext(); sm != null; sm = sm.getNext()) {
                sink = sm.getSinkFactory();
                peer = sink.createPeer(peer);
            }
            sm = originaSm;
            HashSet<PathMemory> pathsToFlush = new HashSet<PathMemory>();
            pathsToFlush.addAll(LeftInputAdapterNode.doInsertSegmentMemory(reteEvaluator, notifySegment, lm, sm, leftTuple, liaNode.isStreamMode()));
            if (sm.getRootNode() != liaNode) {
                peer = leftTuple;
                for (sm = sm.getNext(); sm != null; sm = sm.getNext()) {
                    peer = peer.getPeer();
                    pathsToFlush.addAll(LeftInputAdapterNode.doInsertSegmentMemory(reteEvaluator, notifySegment, lm, sm, peer, liaNode.isStreamMode()));
                }
            }
            for (PathMemory outPmem : pathsToFlush) {
                TupleEvaluationUtil.forceFlushPath(reteEvaluator, outPmem);
            }
        }
    }

    public static void doInsertSegmentMemoryWithFlush(ReteEvaluator reteEvaluator, boolean notifySegment, LiaNodeMemory lm, SegmentMemory sm, LeftTuple leftTuple, boolean streamMode) {
        for (PathMemory outPmem : LeftInputAdapterNode.doInsertSegmentMemory(reteEvaluator, notifySegment, lm, sm, leftTuple, streamMode)) {
            TupleEvaluationUtil.forceFlushPath(reteEvaluator, outPmem);
        }
    }

    public static List<PathMemory> doInsertSegmentMemory(ReteEvaluator reteEvaluator, boolean linkOrNotify, LiaNodeMemory lm, SegmentMemory sm, LeftTuple leftTuple, boolean streamMode) {
        PathMemory pmem = TupleEvaluationUtil.findPathToFlush(sm, leftTuple, streamMode);
        if (pmem != null) {
            TupleEvaluationUtil.forceFlushLeftTuple(pmem, sm, reteEvaluator, TupleEvaluationUtil.createLeftTupleTupleSets(leftTuple, (short)1));
            if (linkOrNotify) {
                lm.setNodeDirty(reteEvaluator);
            }
            return TupleEvaluationUtil.findPathsToFlushFromRia(reteEvaluator, pmem);
        }
        boolean stagedInsertWasEmpty = sm.getStagedLeftTuples().addInsert(leftTuple);
        if (stagedInsertWasEmpty && linkOrNotify) {
            lm.setNodeDirty(reteEvaluator);
        }
        return Collections.emptyList();
    }

    public static void doDeleteObject(LeftTuple leftTuple, PropagationContext context, SegmentMemory sm, ReteEvaluator reteEvaluator, LeftInputAdapterNode liaNode, boolean linkOrNotify, LiaNodeMemory lm) {
        if (sm.getTipNode() == liaNode) {
            if (sm.isEmpty()) {
                RuntimeSegmentUtilities.createChildSegments(reteEvaluator, sm, liaNode.getSinkPropagator());
            }
            sm = (SegmentMemory)sm.getFirst();
        }
        LeftInputAdapterNode.doDeleteSegmentMemory(leftTuple, context, lm, sm, reteEvaluator, linkOrNotify, liaNode.isStreamMode());
        if (sm.getNext() != null) {
            for (sm = sm.getNext(); sm != null && (leftTuple = leftTuple.getPeer()) != null; sm = sm.getNext()) {
                LeftInputAdapterNode.doDeleteSegmentMemory(leftTuple, context, lm, sm, reteEvaluator, linkOrNotify, liaNode.isStreamMode());
            }
        }
        if (lm.getAndDecreaseCounter() == 1) {
            if (linkOrNotify) {
                lm.unlinkNode(reteEvaluator);
            } else {
                lm.unlinkNodeWithoutRuleNotify();
            }
        }
    }

    private static void doDeleteSegmentMemory(LeftTuple leftTuple, PropagationContext pctx, LiaNodeMemory lm, SegmentMemory sm, ReteEvaluator reteEvaluator, boolean linkOrNotify, boolean streamMode) {
        leftTuple.setPropagationContext(pctx);
        if (TupleEvaluationUtil.flushLeftTupleIfNecessary(reteEvaluator, sm, leftTuple, streamMode, (short)3)) {
            if (linkOrNotify) {
                lm.setNodeDirty(reteEvaluator);
            }
            return;
        }
        TupleSets<LeftTuple> leftTuples = sm.getStagedLeftTuples();
        boolean stagedDeleteWasEmpty = leftTuples.addDelete(leftTuple);
        if (stagedDeleteWasEmpty && linkOrNotify) {
            lm.setNodeDirty(reteEvaluator);
        }
    }

    public static void doUpdateObject(LeftTuple leftTuple, PropagationContext context, ReteEvaluator reteEvaluator, LeftInputAdapterNode liaNode, boolean linkOrNotify, LiaNodeMemory lm, SegmentMemory sm) {
        if (sm.getTipNode() == liaNode) {
            if (sm.isEmpty()) {
                RuntimeSegmentUtilities.createChildSegments(reteEvaluator, sm, liaNode.getSinkPropagator());
            }
            sm = (SegmentMemory)sm.getFirst();
        }
        LeftInputAdapterNode.doUpdateSegmentMemory(leftTuple, context, reteEvaluator, linkOrNotify, lm, sm, liaNode.isStreamMode());
        if (sm.getNext() != null) {
            for (sm = sm.getNext(); sm != null; sm = sm.getNext()) {
                leftTuple = leftTuple.getPeer();
                LeftInputAdapterNode.doUpdateSegmentMemory(leftTuple, context, reteEvaluator, linkOrNotify, lm, sm, liaNode.isStreamMode());
            }
        }
    }

    private static void doUpdateSegmentMemory(LeftTuple leftTuple, PropagationContext pctx, ReteEvaluator reteEvaluator, boolean linkOrNotify, LiaNodeMemory lm, SegmentMemory sm, boolean streamMode) {
        leftTuple.setPropagationContext(pctx);
        TupleSets<LeftTuple> leftTuples = sm.getStagedLeftTuples();
        if (leftTuple.getStagedType() == 0) {
            if (TupleEvaluationUtil.flushLeftTupleIfNecessary(reteEvaluator, sm, leftTuple, streamMode, (short)2)) {
                if (linkOrNotify) {
                    lm.setNodeDirty(reteEvaluator);
                }
                return;
            }
            boolean stagedUpdateWasEmpty = leftTuples.addUpdate(leftTuple);
            if (stagedUpdateWasEmpty && linkOrNotify) {
                lm.setNodeDirty(reteEvaluator);
            }
        }
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, ReteEvaluator reteEvaluator) {
        LiaNodeMemory lm = reteEvaluator.getNodeMemory(this);
        SegmentMemory smem = lm.getSegmentMemory();
        if (smem.getTipNode() == this) {
            smem = (SegmentMemory)smem.getFirst();
        }
        LeftInputAdapterNode.doDeleteObject(leftTuple, context, smem, reteEvaluator, this, true, lm);
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        ObjectTypeNode.Id otnId = this.sink.getFirstLeftTupleSink().getLeftInputOtnId();
        LeftTuple leftTuple = this.processDeletesFromModify(modifyPreviousTuples, context, reteEvaluator, otnId);
        LiaNodeMemory lm = reteEvaluator.getNodeMemory(this);
        LeftTupleSinkNode sink = this.getSinkPropagator().getFirstLeftTupleSink();
        BitMask mask = sink.getLeftInferredMask();
        if (leftTuple != null && leftTuple.getInputOtnId().equals(otnId)) {
            modifyPreviousTuples.removeLeftTuple(this.partitionId);
            leftTuple.reAdd();
            if (context.getModificationMask().intersects(mask)) {
                LeftInputAdapterNode.doUpdateObject(leftTuple, context, reteEvaluator, (LeftInputAdapterNode)leftTuple.getTupleSource(), true, lm, lm.getOrCreateSegmentMemory(this, reteEvaluator));
                if (leftTuple instanceof InternalMatch) {
                    ((InternalMatch)((Object)leftTuple)).setActive(true);
                }
            }
        } else if (context.getModificationMask().intersects(mask)) {
            LeftInputAdapterNode.doInsertObject(factHandle, context, this, reteEvaluator, lm, true, true);
        }
    }

    protected LeftTuple processDeletesFromModify(ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator, ObjectTypeNode.Id otnId) {
        LeftTuple leftTuple = modifyPreviousTuples.peekLeftTuple(this.partitionId);
        while (leftTuple != null && leftTuple.getInputOtnId().before(otnId)) {
            modifyPreviousTuples.removeLeftTuple(this.partitionId);
            modifyPreviousTuples.doDeleteObject(context, reteEvaluator, leftTuple);
            leftTuple = modifyPreviousTuples.peekLeftTuple(this.partitionId);
        }
        return leftTuple;
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.modifyObject(factHandle, modifyPreviousTuples, context, reteEvaluator);
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.objectSource.removeObjectSink(this);
            return true;
        }
        return false;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        return null;
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    private int calculateHashCode() {
        return 31 * this.objectSource.hashCode() + 37 * this.sinkMask.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object.getClass() != LeftInputAdapterNode.class || this.hashCode() != object.hashCode()) {
            return false;
        }
        return this.objectSource.getId() == ((LeftInputAdapterNode)object).objectSource.getId() && this.sinkMask.equals(((LeftInputAdapterNode)object).sinkMask);
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this.objectSource;
        while (source != null) {
            if (source instanceof ObjectTypeNode) {
                return (ObjectTypeNode)source;
            }
            source = source.source;
        }
        return null;
    }

    @Override
    public LiaNodeMemory createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        return new LiaNodeMemory();
    }

    @Override
    public void setSourcePartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        this.setSourcePartitionId(this.objectSource, context, partitionId);
    }

    @Override
    public void setPartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        if (this.partitionId != null && this.partitionId != partitionId) {
            this.objectSource.sink.changeSinkPartition(this, this.partitionId, partitionId, this.objectSource.alphaNodeHashingThreshold, this.objectSource.alphaNodeRangeIndexThreshold);
        }
        this.partitionId = partitionId;
    }

    public boolean isTerminal() {
        return false;
    }

    public static class RightTupleSinkAdapter
    implements ObjectSink {
        private LeftTupleSink sink;
        private LeftInputAdapterNode liaNode;

        public RightTupleSinkAdapter(LeftInputAdapterNode liaNode) {
            this.liaNode = liaNode;
        }

        public RightTupleSinkAdapter() {
        }

        @Override
        public void assertObject(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
            this.liaNode.assertObject(factHandle, context, reteEvaluator);
        }

        @Override
        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
            throw new UnsupportedOperationException("ObjectSinkAdapter onlys supports assertObject method calls");
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public RuleBasePartitionId getPartitionId() {
            return this.sink.getPartitionId();
        }

        @Override
        public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short getType() {
            return 120;
        }

        @Override
        public Rule[] getAssociatedRules() {
            return this.sink.getAssociatedRules();
        }

        @Override
        public boolean isAssociatedWith(Rule rule) {
            return this.sink.isAssociatedWith(rule);
        }

        @Override
        public NetworkNode[] getSinks() {
            return new NetworkNode[0];
        }

        @Override
        public void addAssociatedTerminal(TerminalNode terminalNode) {
            this.sink.addAssociatedTerminal(terminalNode);
        }

        @Override
        public void removeAssociatedTerminal(TerminalNode terminalNode) {
            this.sink.removeAssociatedTerminal(terminalNode);
        }

        @Override
        public int getAssociatedTerminalsSize() {
            return this.sink.getAssociatedTerminalsSize();
        }

        @Override
        public boolean hasAssociatedTerminal(NetworkNode terminalNode) {
            return this.sink.hasAssociatedTerminal(terminalNode);
        }
    }

    public static class LiaNodeMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements SegmentNodeMemory {
        private int counter;
        private SegmentMemory segmentMemory;
        private long nodePosMaskBit;

        public int getCounter() {
            return this.counter;
        }

        public int getAndIncreaseCounter() {
            return this.counter++;
        }

        public int getAndDecreaseCounter() {
            return this.counter--;
        }

        public void setCounter(int counter) {
            this.counter = counter;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.segmentMemory;
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentNodes) {
            this.segmentMemory = segmentNodes;
        }

        @Override
        public long getNodePosMaskBit() {
            return this.nodePosMaskBit;
        }

        @Override
        public void setNodePosMaskBit(long nodePosMask) {
            this.nodePosMaskBit = nodePosMask;
        }

        @Override
        public void setNodeDirtyWithoutNotify() {
        }

        @Override
        public void setNodeCleanWithoutNotify() {
        }

        public void linkNodeWithoutRuleNotify() {
            this.segmentMemory.linkNodeWithoutRuleNotify(this.nodePosMaskBit);
        }

        public void linkNode(ReteEvaluator reteEvaluator) {
            this.segmentMemory.linkNode(this.nodePosMaskBit, reteEvaluator);
        }

        public boolean unlinkNode(ReteEvaluator reteEvaluator) {
            return this.segmentMemory.unlinkNode(this.nodePosMaskBit, reteEvaluator);
        }

        public void unlinkNodeWithoutRuleNotify() {
            this.segmentMemory.unlinkNodeWithoutRuleNotify(this.nodePosMaskBit);
        }

        @Override
        public short getNodeType() {
            return 120;
        }

        public void setNodeDirty(ReteEvaluator reteEvaluator) {
            this.segmentMemory.notifyRuleLinkSegment(reteEvaluator, this.nodePosMaskBit);
        }

        @Override
        public void reset() {
            this.counter = 0;
        }
    }
}

