/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.list.nearby;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableDemand;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbySelector;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.list.DestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.ElementDestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.ElementRef;
import org.optaplanner.core.impl.heuristic.selector.list.nearby.ListNearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicReplayingValueSelector;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public final class NearValueNearbyDestinationSelector<Solution_>
extends AbstractNearbySelector<Solution_, ElementDestinationSelector<Solution_>, MimicReplayingValueSelector<Solution_>>
implements DestinationSelector<Solution_> {
    private SingletonInverseVariableSupply inverseVariableSupply;
    private IndexVariableSupply indexVariableSupply;

    public NearValueNearbyDestinationSelector(ElementDestinationSelector<Solution_> childDestinationSelector, EntityIndependentValueSelector<Solution_> originValueSelector, NearbyDistanceMeter<?, ?> nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        super(childDestinationSelector, originValueSelector, nearbyDistanceMeter, nearbyRandom, randomSelection);
    }

    @Override
    protected MimicReplayingValueSelector<Solution_> castReplayingSelector(Object uncastReplayingSelector) {
        if (!(uncastReplayingSelector instanceof MimicReplayingValueSelector)) {
            throw new IllegalStateException("Impossible state: Nearby destination selector (" + this + ") did not receive a replaying value selector (" + uncastReplayingSelector + ").");
        }
        return (MimicReplayingValueSelector)uncastReplayingSelector;
    }

    @Override
    protected AbstractNearbyDistanceMatrixDemand<?, ?, ?, ?> createDemand() {
        return new ListNearbyDistanceMatrixDemand(this.nearbyDistanceMeter, this.nearbyRandom, (ElementDestinationSelector)this.childSelector, (MimicReplayingValueSelector)this.replayingSelector, this::computeDestinationSize);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        ListVariableDescriptor listVariableDescriptor = ((ElementDestinationSelector)this.childSelector).getVariableDescriptor();
        this.inverseVariableSupply = supplyManager.demand(new SingletonListInverseVariableDemand(listVariableDescriptor));
        this.indexVariableSupply = supplyManager.demand(new IndexVariableDemand(listVariableDescriptor));
    }

    private int computeDestinationSize(Object origin) {
        int overallSizeMaximum;
        long childSize = ((ElementDestinationSelector)this.childSelector).getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childDestinationSelector (" + this.childSelector + ") has a destinationSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        int destinationSize = (int)childSize;
        if (this.randomSelection && destinationSize > (overallSizeMaximum = this.nearbyRandom.getOverallSizeMaximum())) {
            destinationSize = overallSizeMaximum;
        }
        return destinationSize;
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.indexVariableSupply = null;
    }

    @Override
    public boolean isCountable() {
        return ((ElementDestinationSelector)this.childSelector).isCountable();
    }

    @Override
    public long getSize() {
        return ((ElementDestinationSelector)this.childSelector).getSize();
    }

    @Override
    public Iterator<ElementRef> iterator() {
        Iterator<Object> replayingOriginValueIterator = ((MimicReplayingValueSelector)this.replayingSelector).iterator();
        if (!this.randomSelection) {
            return new OriginalValueNearbyDestinationIterator(replayingOriginValueIterator, ((ElementDestinationSelector)this.childSelector).getSize());
        }
        return new RandomValueNearbyDestinationIterator(replayingOriginValueIterator, ((ElementDestinationSelector)this.childSelector).getSize());
    }

    private ElementRef elementRef(Object next) {
        if (((ElementDestinationSelector)this.childSelector).getEntityDescriptor().matchesEntity(next)) {
            return ElementRef.of(next, 0);
        }
        return ElementRef.of(this.inverseVariableSupply.getInverseSingleton(next), this.indexVariableSupply.getIndex(next) + 1);
    }

    private final class OriginalValueNearbyDestinationIterator
    extends SelectionIterator<ElementRef> {
        private final Iterator<Object> replayingOriginValueIterator;
        private final long childSize;
        private boolean originSelected = false;
        private boolean originIsNotEmpty;
        private Object origin;
        private int nextNearbyIndex;

        public OriginalValueNearbyDestinationIterator(Iterator<Object> replayingOriginValueIterator, long childSize) {
            this.replayingOriginValueIterator = replayingOriginValueIterator;
            this.childSize = childSize;
            this.nextNearbyIndex = 0;
        }

        private void selectOrigin() {
            if (this.originSelected) {
                return;
            }
            this.originIsNotEmpty = this.replayingOriginValueIterator.hasNext();
            this.origin = this.replayingOriginValueIterator.next();
            this.originSelected = true;
        }

        @Override
        public boolean hasNext() {
            this.selectOrigin();
            return this.originIsNotEmpty && (long)this.nextNearbyIndex < this.childSize;
        }

        @Override
        public ElementRef next() {
            this.selectOrigin();
            Object next = ((NearbyDistanceMatrix)NearValueNearbyDestinationSelector.this.nearbyDistanceMatrixSupply.read()).getDestination(this.origin, this.nextNearbyIndex);
            ++this.nextNearbyIndex;
            return NearValueNearbyDestinationSelector.this.elementRef(next);
        }
    }

    private final class RandomValueNearbyDestinationIterator
    extends SelectionIterator<ElementRef> {
        private final Iterator<Object> replayingOriginValueIterator;
        private final int nearbySize;

        public RandomValueNearbyDestinationIterator(Iterator<Object> replayingOriginValueIterator, long childSize) {
            this.replayingOriginValueIterator = replayingOriginValueIterator;
            if (childSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The destinationSelector (" + this + ") has a destinationSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
            }
            this.nearbySize = (int)childSize;
        }

        @Override
        public boolean hasNext() {
            return this.replayingOriginValueIterator.hasNext() && this.nearbySize > 0;
        }

        @Override
        public ElementRef next() {
            Object origin = this.replayingOriginValueIterator.next();
            int nearbyIndex = NearValueNearbyDestinationSelector.this.nearbyRandom.nextInt(NearValueNearbyDestinationSelector.this.workingRandom, this.nearbySize);
            Object next = ((NearbyDistanceMatrix)NearValueNearbyDestinationSelector.this.nearbyDistanceMatrixSupply.read()).getDestination(origin, nearbyIndex);
            return NearValueNearbyDestinationSelector.this.elementRef(next);
        }
    }
}

