/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableDemand;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.util.CollectionUtils;

final class TwoOptListMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final IndexVariableSupply indexVariableSupply;
    private final Object entity;
    private final Object firstEdgeStartpoint;
    private final Object firstEdgeEndpoint;
    private final Object secondEdgeStartpoint;
    private final Object secondEdgeEndpoint;

    public TwoOptListMove(ListVariableDescriptor<Solution_> variableDescriptor, IndexVariableSupply indexVariableSupply, Object entity, Object firstEdgeEndpoint, Object secondEdgeEndpoint) {
        this(variableDescriptor, indexVariableSupply, entity, TwoOptListMove.getStartPoint(variableDescriptor, indexVariableSupply, entity, firstEdgeEndpoint), firstEdgeEndpoint, TwoOptListMove.getStartPoint(variableDescriptor, indexVariableSupply, entity, secondEdgeEndpoint), secondEdgeEndpoint);
    }

    public TwoOptListMove(ListVariableDescriptor<Solution_> variableDescriptor, IndexVariableSupply indexVariableSupply, Object entity, Object firstEdgeStartpoint, Object firstEdgeEndpoint, Object secondEdgeStartpoint, Object secondEdgeEndpoint) {
        this.variableDescriptor = variableDescriptor;
        this.indexVariableSupply = indexVariableSupply;
        this.entity = entity;
        this.firstEdgeStartpoint = firstEdgeStartpoint;
        this.firstEdgeEndpoint = firstEdgeEndpoint;
        this.secondEdgeStartpoint = secondEdgeStartpoint;
        this.secondEdgeEndpoint = secondEdgeEndpoint;
    }

    @Override
    protected TwoOptListMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        return new TwoOptListMove<Solution_>(this.variableDescriptor, this.indexVariableSupply, this.entity, this.firstEdgeStartpoint, this.secondEdgeStartpoint, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        int secondEdgeEndpointIndex;
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        List<Object> listVariable = this.variableDescriptor.getListVariable(this.entity);
        int firstEdgeEndpointIndex = this.indexVariableSupply.getIndex(this.firstEdgeEndpoint);
        if (firstEdgeEndpointIndex < (secondEdgeEndpointIndex = this.indexVariableSupply.getIndex(this.secondEdgeEndpoint).intValue())) {
            if (firstEdgeEndpointIndex > 0) {
                innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.entity, firstEdgeEndpointIndex, secondEdgeEndpointIndex);
            } else {
                innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.entity, 0, listVariable.size());
            }
            Collections.reverse(listVariable.subList(firstEdgeEndpointIndex, secondEdgeEndpointIndex));
            if (firstEdgeEndpointIndex == 0) {
                Collections.rotate(listVariable, -(secondEdgeEndpointIndex - 1));
            }
            if (firstEdgeEndpointIndex > 0) {
                innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.entity, firstEdgeEndpointIndex, secondEdgeEndpointIndex);
            } else {
                innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.entity, 0, listVariable.size());
            }
        } else {
            List<Object> firstHalfReversedPath = listVariable.subList(firstEdgeEndpointIndex, listVariable.size());
            List<Object> secondHalfReversedPath = listVariable.subList(0, secondEdgeEndpointIndex);
            innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.entity, 0, listVariable.size());
            int totalLength = firstHalfReversedPath.size() + secondHalfReversedPath.size();
            int firstElementShift = 0;
            for (int i = 0; i < totalLength >> 1; ++i) {
                if (i < firstHalfReversedPath.size()) {
                    if (i < secondHalfReversedPath.size()) {
                        int secondHalfIndex = secondHalfReversedPath.size() - i - 1;
                        if (secondHalfIndex == 0) {
                            firstElementShift = firstEdgeEndpointIndex + i;
                        }
                        Object savedFirstItem = firstHalfReversedPath.get(i);
                        firstHalfReversedPath.set(i, secondHalfReversedPath.get(secondHalfIndex));
                        secondHalfReversedPath.set(secondHalfIndex, savedFirstItem);
                        continue;
                    }
                    int secondIndex = firstHalfReversedPath.size() - i + secondHalfReversedPath.size() - 1;
                    Object savedFirstItem = firstHalfReversedPath.get(i);
                    firstHalfReversedPath.set(i, firstHalfReversedPath.get(secondIndex));
                    firstHalfReversedPath.set(secondIndex, savedFirstItem);
                    continue;
                }
                int firstIndex = i - firstHalfReversedPath.size();
                int secondIndex = secondHalfReversedPath.size() - i - 1;
                if (firstIndex == 0) {
                    firstElementShift = secondIndex;
                } else if (secondIndex == 0) {
                    firstElementShift = firstIndex;
                }
                Object savedFirstItem = secondHalfReversedPath.get(firstIndex);
                secondHalfReversedPath.set(firstIndex, secondHalfReversedPath.get(secondIndex));
                secondHalfReversedPath.set(secondIndex, savedFirstItem);
            }
            Collections.rotate(listVariable, -firstElementShift);
            innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.entity, 0, listVariable.size());
        }
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return true;
    }

    @Override
    public TwoOptListMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        SupplyManager supplyManager = ((InnerScoreDirector)destinationScoreDirector).getSupplyManager();
        IndexVariableSupply supply = supplyManager.demand(new IndexVariableDemand<Solution_>(this.variableDescriptor));
        return new TwoOptListMove<Solution_>(this.variableDescriptor, supply, destinationScoreDirector.lookUpWorkingObject(this.entity), destinationScoreDirector.lookUpWorkingObject(this.firstEdgeStartpoint), destinationScoreDirector.lookUpWorkingObject(this.firstEdgeEndpoint), destinationScoreDirector.lookUpWorkingObject(this.secondEdgeStartpoint), destinationScoreDirector.lookUpWorkingObject(this.secondEdgeEndpoint));
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return "2-Opt(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return List.of(this.entity);
    }

    @Override
    public Collection<?> getPlanningValues() {
        int secondEdgeEndpointIndex;
        List<Object> listVariable = this.variableDescriptor.getListVariable(this.entity);
        int firstEdgeEndpointIndex = this.indexVariableSupply.getIndex(this.firstEdgeEndpoint);
        if (firstEdgeEndpointIndex < (secondEdgeEndpointIndex = this.indexVariableSupply.getIndex(this.secondEdgeEndpoint).intValue())) {
            return new ArrayList<Object>(listVariable.subList(firstEdgeEndpointIndex, secondEdgeEndpointIndex));
        }
        List<Object> firstHalfReversedPath = listVariable.subList(firstEdgeEndpointIndex, listVariable.size());
        List<Object> secondHalfReversedPath = listVariable.subList(0, secondEdgeEndpointIndex);
        return CollectionUtils.concat(firstHalfReversedPath, secondHalfReversedPath);
    }

    public Object getEntity() {
        return this.entity;
    }

    public Object getFirstEdgeEndpoint() {
        return this.firstEdgeEndpoint;
    }

    public Object getSecondEdgeEndpoint() {
        return this.secondEdgeEndpoint;
    }

    public Object getFirstEdgeStartpoint() {
        return this.firstEdgeStartpoint;
    }

    public Object getSecondEdgeStartpoint() {
        return this.secondEdgeStartpoint;
    }

    private static <Solution_> Object getStartPoint(ListVariableDescriptor<Solution_> variableDescriptor, IndexVariableSupply indexVariableSupply, Object entity, Object endPoint) {
        List<Object> listVariable = variableDescriptor.getListVariable(entity);
        int endPointIndex = indexVariableSupply.getIndex(endPoint);
        if (endPointIndex == 0) {
            return listVariable.get(listVariable.size() - 1);
        }
        return listVariable.get(endPointIndex - 1);
    }

    public String toString() {
        return "2-Opt(entity=" + this.entity + ", removed=[(" + this.firstEdgeStartpoint + " -> " + this.firstEdgeEndpoint + "), (" + this.secondEdgeStartpoint + " -> " + this.secondEdgeEndpoint + ")], added=[(" + this.firstEdgeStartpoint + " -> " + this.secondEdgeStartpoint + "), (" + this.firstEdgeEndpoint + " -> " + this.secondEdgeEndpoint + ")])";
    }
}

