/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Date;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.SessionPseudoClock;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.DefaultTimerJobFactoryManager;
import org.drools.core.time.impl.DefaultTimerJobInstance;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.core.time.impl.TimerJobInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoClockScheduler
implements TimerService,
SessionPseudoClock,
Externalizable,
InternalSchedulerService {
    private final Logger logger = LoggerFactory.getLogger(PseudoClockScheduler.class);
    protected AtomicLong timer = new AtomicLong(0L);
    protected PriorityQueue<DefaultTimerJobInstance> queue = new PriorityQueue();
    private TimerJobFactoryManager jobFactoryManager = DefaultTimerJobFactoryManager.INSTANCE;
    protected AtomicLong idCounter = new AtomicLong(0L);

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.timer = new AtomicLong(in.readLong());
        PriorityQueue tmp = (PriorityQueue)in.readObject();
        if (tmp != null) {
            this.queue = tmp;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.timer.get());
        out.writeObject(this.queue.isEmpty() ? null : this.queue);
    }

    @Override
    public void setTimerJobFactoryManager(TimerJobFactoryManager timerJobFactoryManager) {
        this.jobFactoryManager = timerJobFactoryManager;
    }

    @Override
    public TimerJobFactoryManager getTimerJobFactoryManager() {
        return this.jobFactoryManager;
    }

    @Override
    public long getCurrentTime() {
        return this.timer.get();
    }

    @Override
    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        Date date = trigger.hasNextFireTime();
        if (date == null) {
            return null;
        }
        DefaultJobHandle jobHandle = new DefaultJobHandle(this.idCounter.getAndIncrement());
        TimerJobInstance jobInstance = this.jobFactoryManager.createTimerJobInstance(job, ctx, trigger, jobHandle, this);
        jobHandle.setTimerJobInstance(jobInstance);
        this.internalSchedule(jobInstance);
        return jobHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalSchedule(TimerJobInstance timerJobInstance) {
        this.jobFactoryManager.addTimerJobInstance(timerJobInstance);
        PseudoClockScheduler pseudoClockScheduler = this;
        synchronized (pseudoClockScheduler) {
            this.queue.add((DefaultTimerJobInstance)timerJobInstance);
        }
    }

    @Override
    public synchronized boolean removeJob(JobHandle jobHandle) {
        jobHandle.setCancel(true);
        this.jobFactoryManager.removeTimerJobInstance(((DefaultJobHandle)jobHandle).getTimerJobInstance());
        return this.queue.remove((DefaultTimerJobInstance)((DefaultJobHandle)jobHandle).getTimerJobInstance());
    }

    public long advanceTime(long amount, TimeUnit unit) {
        return this.runCallBacksAndIncreaseTimer(unit.toMillis(amount));
    }

    public void setStartupTime(long i) {
        this.timer.set(i);
    }

    @Override
    public synchronized void reset() {
        this.idCounter.set(0L);
        this.timer.set(0L);
        this.queue.clear();
    }

    @Override
    public void shutdown() {
    }

    private synchronized long runCallBacksAndIncreaseTimer(long increase) {
        long fireTime;
        long endTime = this.timer.get() + increase;
        TimerJobInstance item = this.queue.peek();
        while (item != null && item.getTrigger().hasNextFireTime() != null && (fireTime = item.getTrigger().hasNextFireTime().getTime()) <= endTime) {
            this.queue.poll();
            if (!item.getJobHandle().isCancel()) {
                try {
                    this.timer.getAndSet(fireTime);
                    ((Callable)((Object)item)).call();
                }
                catch (Exception e) {
                    this.logger.error("Exception running callbacks: ", (Throwable)e);
                }
            }
            item = this.queue.peek();
        }
        this.timer.set(endTime);
        return this.timer.get();
    }

    @Override
    public synchronized long getTimeToNextJob() {
        TimerJobInstance item = this.queue.peek();
        return item != null ? item.getTrigger().hasNextFireTime().getTime() - this.timer.get() : -1L;
    }

    @Override
    public Collection<TimerJobInstance> getTimerJobInstances(long id) {
        return this.jobFactoryManager.getTimerJobInstances();
    }
}

