/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.core.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryHeapQueue<T extends Queue.QueueEntry>
implements Queue<T>,
Externalizable {
    protected static final transient Logger log = LoggerFactory.getLogger(BinaryHeapQueue.class);
    private static final int DEFAULT_CAPACITY = 13;
    private Comparator<T> comparator;
    private int size;
    private ArrayList<T> elements;

    public BinaryHeapQueue() {
    }

    public BinaryHeapQueue(Comparator<T> comparator) {
        this(comparator, 13);
    }

    public BinaryHeapQueue(Comparator<T> comparator, int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("invalid capacity");
        }
        this.elements = new ArrayList(capacity + 1);
        this.elements.add(null);
        this.comparator = comparator;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.comparator = (Comparator)in.readObject();
        this.elements = (ArrayList)in.readObject();
        this.size = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.comparator);
        out.writeObject(this.elements);
        out.writeInt(this.size);
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.elements.add(null);
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.elements.size() == this.size + 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T peek() {
        return (T)(this.size > 0 ? (Queue.QueueEntry)this.elements.get(1) : null);
    }

    @Override
    public void enqueue(T element) {
        if (this.isFull()) {
            this.grow();
        }
        this.percolateUpMaxHeap(element);
        element.setQueued(true);
        if (log.isTraceEnabled()) {
            log.trace("Queue Added {} {}", (Object)element.getQueueIndex(), element);
        }
    }

    @Override
    public T dequeue() {
        if (this.isEmpty()) {
            return null;
        }
        Queue.QueueEntry result = (Queue.QueueEntry)this.elements.get(1);
        this.dequeue(result.getQueueIndex());
        return (T)result;
    }

    @Override
    public void dequeue(T activation) {
        this.dequeue(activation.getQueueIndex());
    }

    T dequeue(int index) {
        if (index < 1 || index > this.size) {
            return null;
        }
        Queue.QueueEntry result = (Queue.QueueEntry)this.elements.get(index);
        if (log.isTraceEnabled()) {
            log.trace("Queue Removed {} {}", (Object)result.getQueueIndex(), (Object)result);
        }
        this.setElement(index, (Queue.QueueEntry)this.elements.get(this.size));
        this.elements.set(this.size, null);
        --this.size;
        if (this.size != 0 && index <= this.size) {
            int compareToParent = 0;
            if (index > 1) {
                compareToParent = this.compare((Queue.QueueEntry)this.elements.get(index), (Queue.QueueEntry)this.elements.get(index / 2));
            }
            if (index > 1 && compareToParent > 0) {
                this.percolateUpMaxHeap(index);
            } else {
                this.percolateDownMaxHeap(index);
            }
        }
        result.setQueued(false);
        result.setQueueIndex(-1);
        return (T)result;
    }

    protected void percolateDownMaxHeap(int index) {
        Queue.QueueEntry element = (Queue.QueueEntry)this.elements.get(index);
        int hole = index;
        while (hole * 2 <= this.size) {
            int child = hole * 2;
            if (child != this.size && this.compare((Queue.QueueEntry)this.elements.get(child + 1), (Queue.QueueEntry)this.elements.get(child)) > 0) {
                ++child;
            }
            if (this.compare((Queue.QueueEntry)this.elements.get(child), element) <= 0) break;
            this.setElement(hole, (Queue.QueueEntry)this.elements.get(child));
            hole = child;
        }
        this.setElement(hole, element);
    }

    protected void percolateUpMaxHeap(int index) {
        int hole = index;
        Queue.QueueEntry element = (Queue.QueueEntry)this.elements.get(hole);
        while (hole > 1 && this.compare(element, (Queue.QueueEntry)this.elements.get(hole / 2)) > 0) {
            int next = hole / 2;
            this.setElement(hole, (Queue.QueueEntry)this.elements.get(next));
            hole = next;
        }
        this.setElement(hole, element);
    }

    protected void percolateUpMaxHeap(T element) {
        if (this.isFull()) {
            this.elements.add(element);
            element.setQueueIndex(++this.size);
        } else {
            this.elements.set(++this.size, element);
            element.setQueueIndex(this.size);
        }
        this.percolateUpMaxHeap(this.size);
    }

    private int compare(T a, T b) {
        return this.comparator.compare(a, b);
    }

    private void grow() {
        this.elements.ensureCapacity(this.elements.size() * 2);
    }

    private void setElement(int index, T element) {
        this.elements.set(index, element);
        element.setQueueIndex(index);
    }

    @Override
    public Collection<T> getAll() {
        List<T> subList = this.isEmpty() ? Collections.EMPTY_LIST : this.elements.subList(1, this.size + 1);
        return subList;
    }

    public String toString() {
        return Stream.of(this.elements).filter(Objects::nonNull).collect(Collectors.toList()).toString();
    }
}

