/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.score;

import java.util.Objects;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceConstraintConfiguration;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;

public final class ConferenceSchedulingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.roomUnavailableTimeslot(factory), this.roomConflict(factory), this.speakerUnavailableTimeslot(factory), this.speakerConflict(factory), this.talkPrerequisiteTalks(factory), this.talkMutuallyExclusiveTalksTags(factory), this.consecutiveTalksPause(factory), this.crowdControl(factory), this.speakerRequiredTimeslotTags(factory), this.speakerProhibitedTimeslotTags(factory), this.talkRequiredTimeslotTags(factory), this.talkProhibitedTimeslotTags(factory), this.speakerRequiredRoomTags(factory), this.speakerProhibitedRoomTags(factory), this.talkRequiredRoomTags(factory), this.talkProhibitedRoomTags(factory), this.publishedTimeslot(factory), this.publishedRoom(factory), this.themeTrackConflict(factory), this.themeTrackRoomStability(factory), this.sectorConflict(factory), this.audienceTypeDiversity(factory), this.audienceTypeThemeTrackConflict(factory), this.audienceLevelDiversity(factory), this.contentAudienceLevelFlowViolation(factory), this.contentConflict(factory), this.languageDiversity(factory), this.sameDayTalks(factory), this.popularTalks(factory), this.speakerPreferredTimeslotTags(factory), this.speakerUndesiredTimeslotTags(factory), this.talkPreferredTimeslotTags(factory), this.talkUndesiredTimeslotTags(factory), this.speakerPreferredRoomTags(factory), this.speakerUndesiredRoomTags(factory), this.talkPreferredRoomTags(factory), this.talkUndesiredRoomTags(factory)};
    }

    protected Constraint roomUnavailableTimeslot(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(Talk::hasUnavailableRoom).penalizeConfigurable(Talk::getDurationInMinutes).asConstraint("Room unavailable timeslot");
    }

    protected Constraint roomConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.equal(Talk::getRoom), Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime())).penalizeConfigurable(Talk::overlappingDurationInMinutes).asConstraint("Room conflict");
    }

    protected Constraint speakerUnavailableTimeslot(ConstraintFactory factory) {
        return factory.forEachIncludingNullVars(Talk.class).filter(talk -> talk.getTimeslot() != null).join(Speaker.class, Joiners.filtering((talk, speaker) -> talk.hasSpeaker((Speaker)speaker) && speaker.getUnavailableTimeslotSet().contains(talk.getTimeslot()))).penalizeConfigurable((talk, speaker) -> talk.getDurationInMinutes()).asConstraint("Speaker unavailable timeslot");
    }

    protected Constraint speakerConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime())).join(Speaker.class, Joiners.filtering((talk1, talk2, speaker) -> talk1.hasSpeaker((Speaker)speaker) && talk2.hasSpeaker((Speaker)speaker))).penalizeConfigurable((talk1, talk2, speaker) -> talk2.overlappingDurationInMinutes((Talk)talk1)).asConstraint("Speaker conflict");
    }

    protected Constraint talkPrerequisiteTalks(ConstraintFactory factory) {
        return factory.forEach(Talk.class).join(Talk.class, Joiners.greaterThan(t -> t.getTimeslot().getEndDateTime(), t -> t.getTimeslot().getStartDateTime()), Joiners.filtering((talk1, talk2) -> talk2.getPrerequisiteTalkSet().contains(talk1))).penalizeConfigurable(Talk::combinedDurationInMinutes).asConstraint("Talk prerequisite talks");
    }

    protected Constraint talkMutuallyExclusiveTalksTags(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime()), Joiners.filtering((talk1, talk2) -> talk2.overlappingMutuallyExclusiveTalksTagCount((Talk)talk1) > 0)).penalizeConfigurable((talk1, talk2) -> talk1.overlappingMutuallyExclusiveTalksTagCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2)).asConstraint("Talk mutually-exclusive-talks tags");
    }

    protected Constraint consecutiveTalksPause(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.filtering((talk1, talk2) -> talk2.hasMutualSpeaker((Talk)talk1))).ifExists(ConferenceConstraintConfiguration.class, Joiners.filtering((talk1, talk2, config) -> !talk1.getTimeslot().pauseExists(talk2.getTimeslot(), config.getMinimumConsecutiveTalksPauseInMinutes()))).penalizeConfigurable(Talk::combinedDurationInMinutes).asConstraint("Consecutive talks pause");
    }

    protected Constraint crowdControl(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.getCrowdControlRisk() > 0).join(Talk.class, Joiners.equal(Talk::getTimeslot)).filter((talk1, talk2) -> !Objects.equals(talk1, talk2) && talk2.getCrowdControlRisk() > 0).groupBy((talk1, talk2) -> talk1, ConstraintCollectors.countBi()).filter((talk, count) -> count != 1).penalizeConfigurable((talk, count) -> talk.getDurationInMinutes()).asConstraint("Crowd control");
    }

    protected Constraint speakerRequiredTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingSpeakerRequiredTimeslotTagCount() > 0).penalizeConfigurable(talk -> talk.missingSpeakerRequiredTimeslotTagCount() * talk.getDurationInMinutes()).asConstraint("Speaker required timeslot tags");
    }

    protected Constraint speakerProhibitedTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingSpeakerProhibitedTimeslotTagCount() > 0).penalizeConfigurable(talk -> talk.prevailingSpeakerProhibitedTimeslotTagCount() * talk.getDurationInMinutes()).asConstraint("Speaker prohibited timeslot tags");
    }

    protected Constraint talkRequiredTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingRequiredTimeslotTagCount() > 0).penalizeConfigurable(talk -> talk.missingRequiredTimeslotTagCount() * talk.getDurationInMinutes()).asConstraint("Talk required timeslot tags");
    }

    protected Constraint talkProhibitedTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingProhibitedTimeslotTagCount() > 0).penalizeConfigurable(talk -> talk.prevailingProhibitedTimeslotTagCount() * talk.getDurationInMinutes()).asConstraint("Talk prohibited timeslot tags");
    }

    protected Constraint speakerRequiredRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingSpeakerRequiredRoomTagCount() > 0).penalizeConfigurable(talk -> talk.missingSpeakerRequiredRoomTagCount() * talk.getDurationInMinutes()).asConstraint("Speaker required room tags");
    }

    protected Constraint speakerProhibitedRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingSpeakerProhibitedRoomTagCount() > 0).penalizeConfigurable(talk -> talk.prevailingSpeakerProhibitedRoomTagCount() * talk.getDurationInMinutes()).asConstraint("Speaker prohibited room tags");
    }

    protected Constraint talkRequiredRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingRequiredRoomTagCount() > 0).penalizeConfigurable(talk -> talk.missingRequiredRoomTagCount() * talk.getDurationInMinutes()).asConstraint("Talk required room tags");
    }

    protected Constraint talkProhibitedRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingProhibitedRoomTagCount() > 0).penalizeConfigurable(talk -> talk.prevailingProhibitedRoomTagCount() * talk.getDurationInMinutes()).asConstraint("Talk prohibited room tags");
    }

    protected Constraint publishedTimeslot(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.getPublishedTimeslot() != null && talk.getTimeslot() != talk.getPublishedTimeslot()).penalizeConfigurable().asConstraint("Published timeslot");
    }

    protected Constraint publishedRoom(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.getPublishedRoom() != null && talk.getRoom() != talk.getPublishedRoom()).penalizeConfigurable().asConstraint("Published room");
    }

    protected Constraint themeTrackConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime()), Joiners.filtering((talk1, talk2) -> talk2.overlappingThemeTrackCount((Talk)talk1) > 0)).penalizeConfigurable((talk1, talk2) -> talk1.overlappingThemeTrackCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2)).asConstraint("Theme track conflict");
    }

    protected Constraint themeTrackRoomStability(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.equal(talk -> talk.getTimeslot().getStartDateTime().toLocalDate()), Joiners.filtering((talk1, talk2) -> talk2.overlappingThemeTrackCount((Talk)talk1) > 0)).filter((talk1, talk2) -> talk1.getRoom() != talk2.getRoom()).penalizeConfigurable((talk1, talk2) -> talk1.overlappingThemeTrackCount((Talk)talk2) * talk1.combinedDurationInMinutes((Talk)talk2)).asConstraint("Theme track room stability");
    }

    protected Constraint sectorConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime()), Joiners.filtering((talk1, talk2) -> talk2.overlappingSectorCount((Talk)talk1) > 0)).penalizeConfigurable((talk1, talk2) -> talk1.overlappingSectorCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2)).asConstraint("Sector conflict");
    }

    protected Constraint audienceTypeDiversity(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.equal(Talk::getTimeslot), Joiners.filtering((talk1, talk2) -> talk2.overlappingAudienceTypeCount((Talk)talk1) > 0)).rewardConfigurable((talk1, talk2) -> talk1.overlappingAudienceTypeCount((Talk)talk2) * talk1.getTimeslot().getDurationInMinutes()).asConstraint("Audience type diversity");
    }

    protected Constraint audienceTypeThemeTrackConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime()), Joiners.filtering((talk1, talk2) -> talk2.overlappingThemeTrackCount((Talk)talk1) > 0), Joiners.filtering((talk1, talk2) -> talk2.overlappingAudienceTypeCount((Talk)talk1) > 0)).penalizeConfigurable((talk1, talk2) -> talk1.overlappingThemeTrackCount((Talk)talk2) * talk1.overlappingAudienceTypeCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2)).asConstraint("Audience type theme track conflict");
    }

    protected Constraint audienceLevelDiversity(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.equal(Talk::getTimeslot)).filter((talk1, talk2) -> talk1.getAudienceLevel() != talk2.getAudienceLevel()).rewardConfigurable((talk1, talk2) -> talk1.getTimeslot().getDurationInMinutes()).asConstraint("Audience level diversity");
    }

    protected Constraint contentAudienceLevelFlowViolation(ConstraintFactory factory) {
        return factory.forEach(Talk.class).join(Talk.class, Joiners.lessThan(Talk::getAudienceLevel), Joiners.greaterThan(talk1 -> talk1.getTimeslot().getEndDateTime(), talk2 -> talk2.getTimeslot().getStartDateTime()), Joiners.filtering((talk1, talk2) -> talk2.overlappingContentCount((Talk)talk1) > 0)).penalizeConfigurable((talk1, talk2) -> talk1.overlappingContentCount((Talk)talk2) * talk1.combinedDurationInMinutes((Talk)talk2)).asConstraint("Content audience level flow violation");
    }

    protected Constraint contentConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.overlapping(t -> t.getTimeslot().getStartDateTime(), t -> t.getTimeslot().getEndDateTime()), Joiners.filtering((talk1, talk2) -> talk2.overlappingContentCount((Talk)talk1) > 0)).penalizeConfigurable((talk1, talk2) -> talk1.overlappingContentCount((Talk)talk2) * talk1.overlappingDurationInMinutes((Talk)talk2)).asConstraint("Content conflict");
    }

    protected Constraint languageDiversity(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class, Joiners.equal(Talk::getTimeslot)).filter((talk1, talk2) -> !talk1.getLanguage().equals(talk2.getLanguage())).rewardConfigurable((talk1, talk2) -> talk1.getTimeslot().getDurationInMinutes()).asConstraint("Language diversity");
    }

    protected Constraint sameDayTalks(ConstraintFactory factory) {
        return factory.forEachUniquePair(Talk.class).filter((talk1, talk2) -> !talk1.getTimeslot().isOnSameDayAs(talk2.getTimeslot()) && (talk1.overlappingContentCount((Talk)talk2) > 0 || talk1.overlappingThemeTrackCount((Talk)talk2) > 0)).penalizeConfigurable((talk1, talk2) -> (talk2.overlappingThemeTrackCount((Talk)talk1) + talk2.overlappingContentCount((Talk)talk1)) * talk1.combinedDurationInMinutes((Talk)talk2)).asConstraint("Same day talks");
    }

    protected Constraint popularTalks(ConstraintFactory factory) {
        return factory.forEach(Talk.class).join(Talk.class, Joiners.lessThan(Talk::getFavoriteCount), Joiners.greaterThan(talk -> talk.getRoom().getCapacity())).penalizeConfigurable(Talk::combinedDurationInMinutes).asConstraint("Popular talks");
    }

    protected Constraint speakerPreferredTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingSpeakerPreferredTimeslotTagCount() > 0).penalizeConfigurable(talk -> talk.missingSpeakerPreferredTimeslotTagCount() * talk.getDurationInMinutes()).asConstraint("Speaker preferred timeslot tags");
    }

    protected Constraint speakerUndesiredTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingSpeakerUndesiredTimeslotTagCount() > 0).penalizeConfigurable(talk -> talk.prevailingSpeakerUndesiredTimeslotTagCount() * talk.getDurationInMinutes()).asConstraint("Speaker undesired timeslot tags");
    }

    protected Constraint talkPreferredTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingPreferredTimeslotTagCount() > 0).penalizeConfigurable(talk -> talk.missingPreferredTimeslotTagCount() * talk.getDurationInMinutes()).asConstraint("Talk preferred timeslot tags");
    }

    protected Constraint talkUndesiredTimeslotTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingUndesiredTimeslotTagCount() > 0).penalizeConfigurable(talk -> talk.prevailingUndesiredTimeslotTagCount() * talk.getDurationInMinutes()).asConstraint("Talk undesired timeslot tags");
    }

    protected Constraint speakerPreferredRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingSpeakerPreferredRoomTagCount() > 0).penalizeConfigurable(talk -> talk.missingSpeakerPreferredRoomTagCount() * talk.getDurationInMinutes()).asConstraint("Speaker preferred room tags");
    }

    protected Constraint speakerUndesiredRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingSpeakerUndesiredRoomTagCount() > 0).penalizeConfigurable(talk -> talk.prevailingSpeakerUndesiredRoomTagCount() * talk.getDurationInMinutes()).asConstraint("Speaker undesired room tags");
    }

    protected Constraint talkPreferredRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.missingPreferredRoomTagCount() > 0).penalizeConfigurable(talk -> talk.missingPreferredRoomTagCount() * talk.getDurationInMinutes()).asConstraint("Talk preferred room tags");
    }

    protected Constraint talkUndesiredRoomTags(ConstraintFactory factory) {
        return factory.forEach(Talk.class).filter(talk -> talk.prevailingUndesiredRoomTagCount() > 0).penalizeConfigurable(talk -> talk.prevailingUndesiredRoomTagCount() * talk.getDurationInMinutes()).asConstraint("Talk undesired room tags");
    }
}

